package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link StencilClient.TemplateReleaseItem}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTemplateReleaseItem.builder()}.
 */
@Generated(from = "StencilClient.TemplateReleaseItem", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableTemplateReleaseItem
    implements StencilClient.TemplateReleaseItem {
  private final String id;
  private final String hash;
  private final String name;
  private final String content;
  private final String type;

  private ImmutableTemplateReleaseItem(
      String id,
      String hash,
      String name,
      String content,
      String type) {
    this.id = id;
    this.hash = hash;
    this.name = name;
    this.content = content;
    this.type = type;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code hash} attribute
   */
  @JsonProperty("hash")
  @Override
  public String getHash() {
    return hash;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code content} attribute
   */
  @JsonProperty("content")
  @Override
  public String getContent() {
    return content;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public String getType() {
    return type;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.TemplateReleaseItem#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTemplateReleaseItem withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableTemplateReleaseItem(newValue, this.hash, this.name, this.content, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.TemplateReleaseItem#getHash() hash} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hash
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTemplateReleaseItem withHash(String value) {
    String newValue = Objects.requireNonNull(value, "hash");
    if (this.hash.equals(newValue)) return this;
    return new ImmutableTemplateReleaseItem(this.id, newValue, this.name, this.content, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.TemplateReleaseItem#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTemplateReleaseItem withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableTemplateReleaseItem(this.id, this.hash, newValue, this.content, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.TemplateReleaseItem#getContent() content} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for content
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTemplateReleaseItem withContent(String value) {
    String newValue = Objects.requireNonNull(value, "content");
    if (this.content.equals(newValue)) return this;
    return new ImmutableTemplateReleaseItem(this.id, this.hash, this.name, newValue, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.TemplateReleaseItem#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTemplateReleaseItem withType(String value) {
    String newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableTemplateReleaseItem(this.id, this.hash, this.name, this.content, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTemplateReleaseItem} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTemplateReleaseItem
        && equalTo((ImmutableTemplateReleaseItem) another);
  }

  private boolean equalTo(ImmutableTemplateReleaseItem another) {
    return id.equals(another.id)
        && hash.equals(another.hash)
        && name.equals(another.name)
        && content.equals(another.content)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code hash}, {@code name}, {@code content}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + hash.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + content.hashCode();
    h += (h << 5) + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TemplateReleaseItem} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("TemplateReleaseItem")
        .omitNullValues()
        .add("id", id)
        .add("hash", hash)
        .add("name", name)
        .add("content", content)
        .add("type", type)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "StencilClient.TemplateReleaseItem", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements StencilClient.TemplateReleaseItem {
    @Nullable String id;
    @Nullable String hash;
    @Nullable String name;
    @Nullable String content;
    @Nullable String type;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("hash")
    public void setHash(String hash) {
      this.hash = hash;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("content")
    public void setContent(String content) {
      this.content = content;
    }
    @JsonProperty("type")
    public void setType(String type) {
      this.type = type;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getHash() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getContent() { throw new UnsupportedOperationException(); }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableTemplateReleaseItem fromJson(Json json) {
    ImmutableTemplateReleaseItem.Builder builder = ImmutableTemplateReleaseItem.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.hash != null) {
      builder.hash(json.hash);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.content != null) {
      builder.content(json.content);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link StencilClient.TemplateReleaseItem} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TemplateReleaseItem instance
   */
  public static ImmutableTemplateReleaseItem copyOf(StencilClient.TemplateReleaseItem instance) {
    if (instance instanceof ImmutableTemplateReleaseItem) {
      return (ImmutableTemplateReleaseItem) instance;
    }
    return ImmutableTemplateReleaseItem.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTemplateReleaseItem ImmutableTemplateReleaseItem}.
   * <pre>
   * ImmutableTemplateReleaseItem.builder()
   *    .id(String) // required {@link StencilClient.TemplateReleaseItem#getId() id}
   *    .hash(String) // required {@link StencilClient.TemplateReleaseItem#getHash() hash}
   *    .name(String) // required {@link StencilClient.TemplateReleaseItem#getName() name}
   *    .content(String) // required {@link StencilClient.TemplateReleaseItem#getContent() content}
   *    .type(String) // required {@link StencilClient.TemplateReleaseItem#getType() type}
   *    .build();
   * </pre>
   * @return A new ImmutableTemplateReleaseItem builder
   */
  public static ImmutableTemplateReleaseItem.Builder builder() {
    return new ImmutableTemplateReleaseItem.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTemplateReleaseItem ImmutableTemplateReleaseItem}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "StencilClient.TemplateReleaseItem", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_HASH = 0x2L;
    private static final long INIT_BIT_NAME = 0x4L;
    private static final long INIT_BIT_CONTENT = 0x8L;
    private static final long INIT_BIT_TYPE = 0x10L;
    private long initBits = 0x1fL;

    private @Nullable String id;
    private @Nullable String hash;
    private @Nullable String name;
    private @Nullable String content;
    private @Nullable String type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.thestencil.client.api.StencilClient.TemplateReleaseItem} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StencilClient.TemplateReleaseItem instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.thestencil.client.api.StencilClient.ReleaseItem} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StencilClient.ReleaseItem instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof StencilClient.TemplateReleaseItem) {
        StencilClient.TemplateReleaseItem instance = (StencilClient.TemplateReleaseItem) object;
        name(instance.getName());
        type(instance.getType());
        content(instance.getContent());
      }
      if (object instanceof StencilClient.ReleaseItem) {
        StencilClient.ReleaseItem instance = (StencilClient.ReleaseItem) object;
        hash(instance.getHash());
        id(instance.getId());
      }
    }

    /**
     * Initializes the value for the {@link StencilClient.TemplateReleaseItem#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.TemplateReleaseItem#getHash() hash} attribute.
     * @param hash The value for hash 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("hash")
    public final Builder hash(String hash) {
      this.hash = Objects.requireNonNull(hash, "hash");
      initBits &= ~INIT_BIT_HASH;
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.TemplateReleaseItem#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.TemplateReleaseItem#getContent() content} attribute.
     * @param content The value for content 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("content")
    public final Builder content(String content) {
      this.content = Objects.requireNonNull(content, "content");
      initBits &= ~INIT_BIT_CONTENT;
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.TemplateReleaseItem#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("type")
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTemplateReleaseItem ImmutableTemplateReleaseItem}.
     * @return An immutable instance of TemplateReleaseItem
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTemplateReleaseItem build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTemplateReleaseItem(id, hash, name, content, type);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_HASH) != 0) attributes.add("hash");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_CONTENT) != 0) attributes.add("content");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build TemplateReleaseItem, some of required attributes are not set " + attributes;
    }
  }
}
