package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link UpdateBuilder.PageMutator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePageMutator.builder()}.
 */
@Generated(from = "UpdateBuilder.PageMutator", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutablePageMutator implements UpdateBuilder.PageMutator {
  private final String pageId;
  private final String content;
  private final String locale;
  private final @Nullable Boolean devMode;

  private ImmutablePageMutator(
      String pageId,
      String content,
      String locale,
      @Nullable Boolean devMode) {
    this.pageId = pageId;
    this.content = content;
    this.locale = locale;
    this.devMode = devMode;
  }

  /**
   * @return The value of the {@code pageId} attribute
   */
  @JsonProperty("pageId")
  @Override
  public String getPageId() {
    return pageId;
  }

  /**
   * @return The value of the {@code content} attribute
   */
  @JsonProperty("content")
  @Override
  public String getContent() {
    return content;
  }

  /**
   * @return The value of the {@code locale} attribute
   */
  @JsonProperty("locale")
  @Override
  public String getLocale() {
    return locale;
  }

  /**
   * @return The value of the {@code devMode} attribute
   */
  @JsonProperty("devMode")
  @Override
  public @Nullable Boolean getDevMode() {
    return devMode;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UpdateBuilder.PageMutator#getPageId() pageId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pageId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePageMutator withPageId(String value) {
    String newValue = Objects.requireNonNull(value, "pageId");
    if (this.pageId.equals(newValue)) return this;
    return new ImmutablePageMutator(newValue, this.content, this.locale, this.devMode);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UpdateBuilder.PageMutator#getContent() content} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for content
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePageMutator withContent(String value) {
    String newValue = Objects.requireNonNull(value, "content");
    if (this.content.equals(newValue)) return this;
    return new ImmutablePageMutator(this.pageId, newValue, this.locale, this.devMode);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UpdateBuilder.PageMutator#getLocale() locale} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for locale
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePageMutator withLocale(String value) {
    String newValue = Objects.requireNonNull(value, "locale");
    if (this.locale.equals(newValue)) return this;
    return new ImmutablePageMutator(this.pageId, this.content, newValue, this.devMode);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UpdateBuilder.PageMutator#getDevMode() devMode} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for devMode (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePageMutator withDevMode(@Nullable Boolean value) {
    if (Objects.equals(this.devMode, value)) return this;
    return new ImmutablePageMutator(this.pageId, this.content, this.locale, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePageMutator} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePageMutator
        && equalTo((ImmutablePageMutator) another);
  }

  private boolean equalTo(ImmutablePageMutator another) {
    return pageId.equals(another.pageId)
        && content.equals(another.content)
        && locale.equals(another.locale)
        && Objects.equals(devMode, another.devMode);
  }

  /**
   * Computes a hash code from attributes: {@code pageId}, {@code content}, {@code locale}, {@code devMode}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + pageId.hashCode();
    h += (h << 5) + content.hashCode();
    h += (h << 5) + locale.hashCode();
    h += (h << 5) + Objects.hashCode(devMode);
    return h;
  }

  /**
   * Prints the immutable value {@code PageMutator} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("PageMutator")
        .omitNullValues()
        .add("pageId", pageId)
        .add("content", content)
        .add("locale", locale)
        .add("devMode", devMode)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "UpdateBuilder.PageMutator", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements UpdateBuilder.PageMutator {
    @Nullable String pageId;
    @Nullable String content;
    @Nullable String locale;
    @Nullable Boolean devMode;
    @JsonProperty("pageId")
    public void setPageId(String pageId) {
      this.pageId = pageId;
    }
    @JsonProperty("content")
    public void setContent(String content) {
      this.content = content;
    }
    @JsonProperty("locale")
    public void setLocale(String locale) {
      this.locale = locale;
    }
    @JsonProperty("devMode")
    public void setDevMode(@Nullable Boolean devMode) {
      this.devMode = devMode;
    }
    @Override
    public String getPageId() { throw new UnsupportedOperationException(); }
    @Override
    public String getContent() { throw new UnsupportedOperationException(); }
    @Override
    public String getLocale() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getDevMode() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutablePageMutator fromJson(Json json) {
    ImmutablePageMutator.Builder builder = ImmutablePageMutator.builder();
    if (json.pageId != null) {
      builder.pageId(json.pageId);
    }
    if (json.content != null) {
      builder.content(json.content);
    }
    if (json.locale != null) {
      builder.locale(json.locale);
    }
    if (json.devMode != null) {
      builder.devMode(json.devMode);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link UpdateBuilder.PageMutator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PageMutator instance
   */
  public static ImmutablePageMutator copyOf(UpdateBuilder.PageMutator instance) {
    if (instance instanceof ImmutablePageMutator) {
      return (ImmutablePageMutator) instance;
    }
    return ImmutablePageMutator.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePageMutator ImmutablePageMutator}.
   * <pre>
   * ImmutablePageMutator.builder()
   *    .pageId(String) // required {@link UpdateBuilder.PageMutator#getPageId() pageId}
   *    .content(String) // required {@link UpdateBuilder.PageMutator#getContent() content}
   *    .locale(String) // required {@link UpdateBuilder.PageMutator#getLocale() locale}
   *    .devMode(Boolean | null) // nullable {@link UpdateBuilder.PageMutator#getDevMode() devMode}
   *    .build();
   * </pre>
   * @return A new ImmutablePageMutator builder
   */
  public static ImmutablePageMutator.Builder builder() {
    return new ImmutablePageMutator.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePageMutator ImmutablePageMutator}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "UpdateBuilder.PageMutator", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_PAGE_ID = 0x1L;
    private static final long INIT_BIT_CONTENT = 0x2L;
    private static final long INIT_BIT_LOCALE = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String pageId;
    private @Nullable String content;
    private @Nullable String locale;
    private @Nullable Boolean devMode;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PageMutator} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(UpdateBuilder.PageMutator instance) {
      Objects.requireNonNull(instance, "instance");
      pageId(instance.getPageId());
      content(instance.getContent());
      locale(instance.getLocale());
      @Nullable Boolean devModeValue = instance.getDevMode();
      if (devModeValue != null) {
        devMode(devModeValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateBuilder.PageMutator#getPageId() pageId} attribute.
     * @param pageId The value for pageId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("pageId")
    public final Builder pageId(String pageId) {
      this.pageId = Objects.requireNonNull(pageId, "pageId");
      initBits &= ~INIT_BIT_PAGE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateBuilder.PageMutator#getContent() content} attribute.
     * @param content The value for content 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("content")
    public final Builder content(String content) {
      this.content = Objects.requireNonNull(content, "content");
      initBits &= ~INIT_BIT_CONTENT;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateBuilder.PageMutator#getLocale() locale} attribute.
     * @param locale The value for locale 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("locale")
    public final Builder locale(String locale) {
      this.locale = Objects.requireNonNull(locale, "locale");
      initBits &= ~INIT_BIT_LOCALE;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateBuilder.PageMutator#getDevMode() devMode} attribute.
     * @param devMode The value for devMode (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("devMode")
    public final Builder devMode(@Nullable Boolean devMode) {
      this.devMode = devMode;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePageMutator ImmutablePageMutator}.
     * @return An immutable instance of PageMutator
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePageMutator build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePageMutator(pageId, content, locale, devMode);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PAGE_ID) != 0) attributes.add("pageId");
      if ((initBits & INIT_BIT_CONTENT) != 0) attributes.add("content");
      if ((initBits & INIT_BIT_LOCALE) != 0) attributes.add("locale");
      return "Cannot build PageMutator, some of required attributes are not set " + attributes;
    }
  }
}
