package io.thestencil.client.api;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Markdowns.ImageTag}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableImageTag.builder()}.
 */
@Generated(from = "Markdowns.ImageTag", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableImageTag implements Markdowns.ImageTag {
  private final Integer line;
  private final String title;
  private final String altText;
  private final String path;

  private ImmutableImageTag(Integer line, String title, String altText, String path) {
    this.line = line;
    this.title = title;
    this.altText = altText;
    this.path = path;
  }

  /**
   * @return The value of the {@code line} attribute
   */
  @Override
  public Integer getLine() {
    return line;
  }

  /**
   * @return The value of the {@code title} attribute
   */
  @Override
  public String getTitle() {
    return title;
  }

  /**
   * @return The value of the {@code altText} attribute
   */
  @Override
  public String getAltText() {
    return altText;
  }

  /**
   * @return The value of the {@code path} attribute
   */
  @Override
  public String getPath() {
    return path;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Markdowns.ImageTag#getLine() line} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for line
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableImageTag withLine(Integer value) {
    Integer newValue = Objects.requireNonNull(value, "line");
    if (this.line.equals(newValue)) return this;
    return new ImmutableImageTag(newValue, this.title, this.altText, this.path);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Markdowns.ImageTag#getTitle() title} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for title
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableImageTag withTitle(String value) {
    String newValue = Objects.requireNonNull(value, "title");
    if (this.title.equals(newValue)) return this;
    return new ImmutableImageTag(this.line, newValue, this.altText, this.path);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Markdowns.ImageTag#getAltText() altText} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for altText
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableImageTag withAltText(String value) {
    String newValue = Objects.requireNonNull(value, "altText");
    if (this.altText.equals(newValue)) return this;
    return new ImmutableImageTag(this.line, this.title, newValue, this.path);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Markdowns.ImageTag#getPath() path} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for path
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableImageTag withPath(String value) {
    String newValue = Objects.requireNonNull(value, "path");
    if (this.path.equals(newValue)) return this;
    return new ImmutableImageTag(this.line, this.title, this.altText, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableImageTag} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableImageTag
        && equalTo((ImmutableImageTag) another);
  }

  private boolean equalTo(ImmutableImageTag another) {
    return line.equals(another.line)
        && title.equals(another.title)
        && altText.equals(another.altText)
        && path.equals(another.path);
  }

  /**
   * Computes a hash code from attributes: {@code line}, {@code title}, {@code altText}, {@code path}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + line.hashCode();
    h += (h << 5) + title.hashCode();
    h += (h << 5) + altText.hashCode();
    h += (h << 5) + path.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ImageTag} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ImageTag")
        .omitNullValues()
        .add("line", line)
        .add("title", title)
        .add("altText", altText)
        .add("path", path)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Markdowns.ImageTag} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ImageTag instance
   */
  public static ImmutableImageTag copyOf(Markdowns.ImageTag instance) {
    if (instance instanceof ImmutableImageTag) {
      return (ImmutableImageTag) instance;
    }
    return ImmutableImageTag.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableImageTag ImmutableImageTag}.
   * <pre>
   * ImmutableImageTag.builder()
   *    .line(Integer) // required {@link Markdowns.ImageTag#getLine() line}
   *    .title(String) // required {@link Markdowns.ImageTag#getTitle() title}
   *    .altText(String) // required {@link Markdowns.ImageTag#getAltText() altText}
   *    .path(String) // required {@link Markdowns.ImageTag#getPath() path}
   *    .build();
   * </pre>
   * @return A new ImmutableImageTag builder
   */
  public static ImmutableImageTag.Builder builder() {
    return new ImmutableImageTag.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableImageTag ImmutableImageTag}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Markdowns.ImageTag", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_LINE = 0x1L;
    private static final long INIT_BIT_TITLE = 0x2L;
    private static final long INIT_BIT_ALT_TEXT = 0x4L;
    private static final long INIT_BIT_PATH = 0x8L;
    private long initBits = 0xfL;

    private @Nullable Integer line;
    private @Nullable String title;
    private @Nullable String altText;
    private @Nullable String path;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ImageTag} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Markdowns.ImageTag instance) {
      Objects.requireNonNull(instance, "instance");
      line(instance.getLine());
      title(instance.getTitle());
      altText(instance.getAltText());
      path(instance.getPath());
      return this;
    }

    /**
     * Initializes the value for the {@link Markdowns.ImageTag#getLine() line} attribute.
     * @param line The value for line 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder line(Integer line) {
      this.line = Objects.requireNonNull(line, "line");
      initBits &= ~INIT_BIT_LINE;
      return this;
    }

    /**
     * Initializes the value for the {@link Markdowns.ImageTag#getTitle() title} attribute.
     * @param title The value for title 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder title(String title) {
      this.title = Objects.requireNonNull(title, "title");
      initBits &= ~INIT_BIT_TITLE;
      return this;
    }

    /**
     * Initializes the value for the {@link Markdowns.ImageTag#getAltText() altText} attribute.
     * @param altText The value for altText 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder altText(String altText) {
      this.altText = Objects.requireNonNull(altText, "altText");
      initBits &= ~INIT_BIT_ALT_TEXT;
      return this;
    }

    /**
     * Initializes the value for the {@link Markdowns.ImageTag#getPath() path} attribute.
     * @param path The value for path 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder path(String path) {
      this.path = Objects.requireNonNull(path, "path");
      initBits &= ~INIT_BIT_PATH;
      return this;
    }

    /**
     * Builds a new {@link ImmutableImageTag ImmutableImageTag}.
     * @return An immutable instance of ImageTag
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableImageTag build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableImageTag(line, title, altText, path);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_LINE) != 0) attributes.add("line");
      if ((initBits & INIT_BIT_TITLE) != 0) attributes.add("title");
      if ((initBits & INIT_BIT_ALT_TEXT) != 0) attributes.add("altText");
      if ((initBits & INIT_BIT_PATH) != 0) attributes.add("path");
      return "Cannot build ImageTag, some of required attributes are not set " + attributes;
    }
  }
}
