package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link StencilClient.Article}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableArticle.builder()}.
 */
@Generated(from = "StencilClient.Article", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableArticle implements StencilClient.Article {
  private final @Nullable String parentId;
  private final @Nullable Boolean devMode;
  private final String name;
  private final Integer order;

  private ImmutableArticle(
      @Nullable String parentId,
      @Nullable Boolean devMode,
      String name,
      Integer order) {
    this.parentId = parentId;
    this.devMode = devMode;
    this.name = name;
    this.order = order;
  }

  /**
   * @return The value of the {@code parentId} attribute
   */
  @JsonProperty("parentId")
  @Override
  public @Nullable String getParentId() {
    return parentId;
  }

  /**
   * @return The value of the {@code devMode} attribute
   */
  @JsonProperty("devMode")
  @JsonInclude(JsonInclude.Include.NON_NULL)
  @Override
  public @Nullable Boolean getDevMode() {
    return devMode;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code order} attribute
   */
  @JsonProperty("order")
  @Override
  public Integer getOrder() {
    return order;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.Article#getParentId() parentId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for parentId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableArticle withParentId(@Nullable String value) {
    if (Objects.equals(this.parentId, value)) return this;
    return new ImmutableArticle(value, this.devMode, this.name, this.order);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.Article#getDevMode() devMode} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for devMode (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableArticle withDevMode(@Nullable Boolean value) {
    if (Objects.equals(this.devMode, value)) return this;
    return new ImmutableArticle(this.parentId, value, this.name, this.order);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.Article#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableArticle withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableArticle(this.parentId, this.devMode, newValue, this.order);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.Article#getOrder() order} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for order
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableArticle withOrder(Integer value) {
    Integer newValue = Objects.requireNonNull(value, "order");
    if (this.order.equals(newValue)) return this;
    return new ImmutableArticle(this.parentId, this.devMode, this.name, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableArticle} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableArticle
        && equalTo((ImmutableArticle) another);
  }

  private boolean equalTo(ImmutableArticle another) {
    return Objects.equals(parentId, another.parentId)
        && Objects.equals(devMode, another.devMode)
        && name.equals(another.name)
        && order.equals(another.order);
  }

  /**
   * Computes a hash code from attributes: {@code parentId}, {@code devMode}, {@code name}, {@code order}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(parentId);
    h += (h << 5) + Objects.hashCode(devMode);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + order.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Article} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Article")
        .omitNullValues()
        .add("parentId", parentId)
        .add("devMode", devMode)
        .add("name", name)
        .add("order", order)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "StencilClient.Article", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements StencilClient.Article {
    @Nullable String parentId;
    @Nullable Boolean devMode;
    @Nullable String name;
    @Nullable Integer order;
    @JsonProperty("parentId")
    public void setParentId(@Nullable String parentId) {
      this.parentId = parentId;
    }
    @JsonProperty("devMode")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public void setDevMode(@Nullable Boolean devMode) {
      this.devMode = devMode;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("order")
    public void setOrder(Integer order) {
      this.order = order;
    }
    @Override
    public String getParentId() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getDevMode() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getOrder() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableArticle fromJson(Json json) {
    ImmutableArticle.Builder builder = ImmutableArticle.builder();
    if (json.parentId != null) {
      builder.parentId(json.parentId);
    }
    if (json.devMode != null) {
      builder.devMode(json.devMode);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.order != null) {
      builder.order(json.order);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link StencilClient.Article} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Article instance
   */
  public static ImmutableArticle copyOf(StencilClient.Article instance) {
    if (instance instanceof ImmutableArticle) {
      return (ImmutableArticle) instance;
    }
    return ImmutableArticle.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableArticle ImmutableArticle}.
   * <pre>
   * ImmutableArticle.builder()
   *    .parentId(String | null) // nullable {@link StencilClient.Article#getParentId() parentId}
   *    .devMode(Boolean | null) // nullable {@link StencilClient.Article#getDevMode() devMode}
   *    .name(String) // required {@link StencilClient.Article#getName() name}
   *    .order(Integer) // required {@link StencilClient.Article#getOrder() order}
   *    .build();
   * </pre>
   * @return A new ImmutableArticle builder
   */
  public static ImmutableArticle.Builder builder() {
    return new ImmutableArticle.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableArticle ImmutableArticle}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "StencilClient.Article", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_ORDER = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String parentId;
    private @Nullable Boolean devMode;
    private @Nullable String name;
    private @Nullable Integer order;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Article} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StencilClient.Article instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String parentIdValue = instance.getParentId();
      if (parentIdValue != null) {
        parentId(parentIdValue);
      }
      @Nullable Boolean devModeValue = instance.getDevMode();
      if (devModeValue != null) {
        devMode(devModeValue);
      }
      name(instance.getName());
      order(instance.getOrder());
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.Article#getParentId() parentId} attribute.
     * @param parentId The value for parentId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("parentId")
    public final Builder parentId(@Nullable String parentId) {
      this.parentId = parentId;
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.Article#getDevMode() devMode} attribute.
     * @param devMode The value for devMode (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("devMode")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public final Builder devMode(@Nullable Boolean devMode) {
      this.devMode = devMode;
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.Article#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.Article#getOrder() order} attribute.
     * @param order The value for order 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("order")
    public final Builder order(Integer order) {
      this.order = Objects.requireNonNull(order, "order");
      initBits &= ~INIT_BIT_ORDER;
      return this;
    }

    /**
     * Builds a new {@link ImmutableArticle ImmutableArticle}.
     * @return An immutable instance of Article
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableArticle build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableArticle(parentId, devMode, name, order);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_ORDER) != 0) attributes.add("order");
      return "Cannot build Article, some of required attributes are not set " + attributes;
    }
  }
}
