/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.api;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.thestencil.client.api.CreateBuilder;
import io.thestencil.client.api.DeleteBuilder;
import io.thestencil.client.api.ImmutableSiteState;
import io.thestencil.client.api.MigrationBuilder;
import io.thestencil.client.api.StencilClient;
import io.thestencil.client.api.StencilStore;
import io.thestencil.client.api.UpdateBuilder;
import io.thestencil.client.api.VersionBuilder;
import java.util.Map;
import javax.annotation.Nullable;
import org.immutables.value.Value;

public interface StencilComposer {
    public CreateBuilder create();

    public UpdateBuilder update();

    public DeleteBuilder delete();

    public MigrationBuilder migration();

    public StencilStore.QueryBuilder query();

    public StencilClient.MarkdownBuilder markdown();

    public StencilClient.SitesBuilder sites();

    public VersionBuilder version();

    public static enum SiteContentType {
        OK,
        ERRORS,
        NOT_CREATED,
        EMPTY,
        RELEASE;

    }

    @JsonSerialize(as=ImmutableSiteState.class)
    @JsonDeserialize(as=ImmutableSiteState.class)
    @Value.Immutable
    public static interface SiteState {
        public String getName();

        @Nullable
        public String getCommit();

        public SiteContentType getContentType();

        public Map<String, StencilClient.Entity<StencilClient.Release>> getReleases();

        public Map<String, StencilClient.Entity<StencilClient.Locale>> getLocales();

        public Map<String, StencilClient.Entity<StencilClient.Page>> getPages();

        public Map<String, StencilClient.Entity<StencilClient.Link>> getLinks();

        public Map<String, StencilClient.Entity<StencilClient.Article>> getArticles();

        public Map<String, StencilClient.Entity<StencilClient.Workflow>> getWorkflows();

        public Map<String, StencilClient.Entity<StencilClient.Template>> getTemplates();
    }
}

