/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.smallrye.mutiny.Uni;
import io.thestencil.client.api.ImmutableArticle;
import io.thestencil.client.api.ImmutableArticleReleaseItem;
import io.thestencil.client.api.ImmutableEntity;
import io.thestencil.client.api.ImmutableLink;
import io.thestencil.client.api.ImmutableLinkReleaseItem;
import io.thestencil.client.api.ImmutableLocale;
import io.thestencil.client.api.ImmutableLocaleLabel;
import io.thestencil.client.api.ImmutableLocaleReleaseItem;
import io.thestencil.client.api.ImmutablePage;
import io.thestencil.client.api.ImmutablePageReleaseItem;
import io.thestencil.client.api.ImmutableRelease;
import io.thestencil.client.api.ImmutableTemplate;
import io.thestencil.client.api.ImmutableTemplateReleaseItem;
import io.thestencil.client.api.ImmutableVersionInfo;
import io.thestencil.client.api.ImmutableWorkflow;
import io.thestencil.client.api.ImmutableWorkflowReleaseItem;
import io.thestencil.client.api.Markdowns;
import io.thestencil.client.api.MigrationBuilder;
import io.thestencil.client.api.StencilComposer;
import io.thestencil.client.api.StencilStore;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import javax.annotation.Nullable;
import org.immutables.value.Value;

public interface StencilClient {
    public ClientRepoBuilder repo();

    public StencilStore getStore();

    public MarkdownBuilder markdown();

    public SitesBuilder sites();

    @JsonSerialize(as=ImmutableVersionInfo.class)
    @JsonDeserialize(as=ImmutableVersionInfo.class)
    @Value.Immutable
    public static interface VersionInfo {
        public String getVersion();

        public String getDate();
    }

    public static interface ReleaseItem
    extends Serializable {
        public String getId();

        public String getHash();
    }

    @JsonSerialize(as=ImmutableTemplateReleaseItem.class)
    @JsonDeserialize(as=ImmutableTemplateReleaseItem.class)
    @Value.Immutable
    public static interface TemplateReleaseItem
    extends ReleaseItem {
        public String getName();

        public String getContent();

        public String getType();
    }

    @JsonSerialize(as=ImmutablePageReleaseItem.class)
    @JsonDeserialize(as=ImmutablePageReleaseItem.class)
    @Value.Immutable
    public static interface PageReleaseItem
    extends ReleaseItem {
        public String getLocale();

        public String getH1();
    }

    @JsonSerialize(as=ImmutableArticleReleaseItem.class)
    @JsonDeserialize(as=ImmutableArticleReleaseItem.class)
    @Value.Immutable
    public static interface ArticleReleaseItem
    extends ReleaseItem {
        public String getName();

        @Nullable
        public String getParentId();
    }

    @JsonSerialize(as=ImmutableLocaleReleaseItem.class)
    @JsonDeserialize(as=ImmutableLocaleReleaseItem.class)
    @Value.Immutable
    public static interface LocaleReleaseItem
    extends ReleaseItem {
        public String getValue();
    }

    @JsonSerialize(as=ImmutableWorkflowReleaseItem.class)
    @JsonDeserialize(as=ImmutableWorkflowReleaseItem.class)
    @Value.Immutable
    public static interface WorkflowReleaseItem
    extends ReleaseItem {
        public String getValue();

        public List<String> getArticles();

        public List<LocaleLabel> getLabels();
    }

    @JsonSerialize(as=ImmutableLinkReleaseItem.class)
    @JsonDeserialize(as=ImmutableLinkReleaseItem.class)
    @Value.Immutable
    public static interface LinkReleaseItem
    extends ReleaseItem {
        public String getValue();

        public String getContentType();

        public List<String> getArticles();

        public List<LocaleLabel> getLabels();
    }

    @JsonSerialize(as=ImmutableRelease.class)
    @JsonDeserialize(as=ImmutableRelease.class)
    @Value.Immutable
    public static interface Release
    extends EntityBody {
        public String getParentCommit();

        public String getName();

        public String getNote();

        public LocalDateTime getCreated();

        public List<LocaleReleaseItem> getLocales();

        public List<ArticleReleaseItem> getArticles();

        public List<LinkReleaseItem> getLinks();

        public List<WorkflowReleaseItem> getWorkflows();

        public List<PageReleaseItem> getPages();

        public List<TemplateReleaseItem> getTemplates();
    }

    @JsonSerialize(as=ImmutableLocaleLabel.class)
    @JsonDeserialize(as=ImmutableLocaleLabel.class)
    @Value.Immutable
    public static interface LocaleLabel
    extends Serializable {
        public String getLocale();

        public String getLabelValue();
    }

    @JsonSerialize(as=ImmutableLink.class)
    @JsonDeserialize(as=ImmutableLink.class)
    @Value.Immutable
    public static interface Link
    extends EntityBody {
        public String getValue();

        @Nullable
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public Boolean getDevMode();

        public String getContentType();

        public List<String> getArticles();

        public List<LocaleLabel> getLabels();
    }

    @JsonSerialize(as=ImmutableWorkflow.class)
    @JsonDeserialize(as=ImmutableWorkflow.class)
    @Value.Immutable
    public static interface Workflow
    extends EntityBody {
        public String getValue();

        @Nullable
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public Boolean getDevMode();

        public List<String> getArticles();

        public List<LocaleLabel> getLabels();
    }

    @JsonSerialize(as=ImmutablePage.class)
    @JsonDeserialize(as=ImmutablePage.class)
    @Value.Immutable
    public static interface Page
    extends EntityBody {
        public String getArticle();

        @Nullable
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public Boolean getDevMode();

        public String getLocale();

        public String getContent();
    }

    @JsonSerialize(as=ImmutableLocale.class)
    @JsonDeserialize(as=ImmutableLocale.class)
    @Value.Immutable
    public static interface Locale
    extends EntityBody {
        public String getValue();

        public Boolean getEnabled();
    }

    @JsonSerialize(as=ImmutableTemplate.class)
    @JsonDeserialize(as=ImmutableTemplate.class)
    @Value.Immutable
    public static interface Template
    extends EntityBody {
        public String getName();

        public String getDescription();

        public String getContent();

        public String getType();
    }

    @JsonSerialize(as=ImmutableArticle.class)
    @JsonDeserialize(as=ImmutableArticle.class)
    @Value.Immutable
    public static interface Article
    extends EntityBody {
        @Nullable
        public String getParentId();

        @Nullable
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public Boolean getDevMode();

        public String getName();

        public Integer getOrder();
    }

    public static interface EntityBody
    extends Serializable {
    }

    public static enum EntityType {
        LOCALE,
        LINK,
        ARTICLE,
        WORKFLOW,
        RELEASE,
        PAGE,
        TEMPLATE;

    }

    @JsonSerialize(as=ImmutableEntity.class)
    @JsonDeserialize(as=ImmutableEntity.class)
    @Value.Immutable
    public static interface Entity<T extends EntityBody>
    extends Serializable {
        public String getId();

        public EntityType getType();

        public T getBody();
    }

    public static interface ClientRepoBuilder {
        public ClientRepoBuilder repoName(String var1);

        public ClientRepoBuilder headName(String var1);

        public Uni<StencilClient> create();

        public StencilClient build();
    }

    public static interface MarkdownBuilder {
        public MarkdownBuilder json(String var1, boolean var2);

        public MarkdownBuilder json(StencilComposer.SiteState var1, boolean var2);

        public MarkdownBuilder md(String var1, byte[] var2);

        public Markdowns build();
    }

    public static interface SitesBuilder {
        public SitesBuilder imagePath(String var1);

        public SitesBuilder created(long var1);

        public SitesBuilder source(Markdowns var1);

        public MigrationBuilder.Sites build();
    }
}

