/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.thestencil.client.api.StencilClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="StencilClient.WorkflowReleaseItem", generator="Immutables")
@Immutable
public final class ImmutableWorkflowReleaseItem
implements StencilClient.WorkflowReleaseItem {
    private final String id;
    private final String hash;
    private final String value;
    private final ImmutableList<String> articles;
    private final ImmutableList<StencilClient.LocaleLabel> labels;

    private ImmutableWorkflowReleaseItem(String id, String hash, String value, ImmutableList<String> articles, ImmutableList<StencilClient.LocaleLabel> labels) {
        this.id = id;
        this.hash = hash;
        this.value = value;
        this.articles = articles;
        this.labels = labels;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="hash")
    public String getHash() {
        return this.hash;
    }

    @Override
    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    @JsonProperty(value="articles")
    public ImmutableList<String> getArticles() {
        return this.articles;
    }

    @JsonProperty(value="labels")
    public ImmutableList<StencilClient.LocaleLabel> getLabels() {
        return this.labels;
    }

    public final ImmutableWorkflowReleaseItem withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableWorkflowReleaseItem(newValue, this.hash, this.value, this.articles, this.labels);
    }

    public final ImmutableWorkflowReleaseItem withHash(String value) {
        String newValue = Objects.requireNonNull(value, "hash");
        if (this.hash.equals(newValue)) {
            return this;
        }
        return new ImmutableWorkflowReleaseItem(this.id, newValue, this.value, this.articles, this.labels);
    }

    public final ImmutableWorkflowReleaseItem withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new ImmutableWorkflowReleaseItem(this.id, this.hash, newValue, this.articles, this.labels);
    }

    public final ImmutableWorkflowReleaseItem withArticles(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableWorkflowReleaseItem(this.id, this.hash, this.value, (ImmutableList<String>)newValue, this.labels);
    }

    public final ImmutableWorkflowReleaseItem withArticles(Iterable<String> elements) {
        if (this.articles == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableWorkflowReleaseItem(this.id, this.hash, this.value, (ImmutableList<String>)newValue, this.labels);
    }

    public final ImmutableWorkflowReleaseItem withLabels(StencilClient.LocaleLabel ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableWorkflowReleaseItem(this.id, this.hash, this.value, this.articles, (ImmutableList<StencilClient.LocaleLabel>)newValue);
    }

    public final ImmutableWorkflowReleaseItem withLabels(Iterable<? extends StencilClient.LocaleLabel> elements) {
        if (this.labels == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableWorkflowReleaseItem(this.id, this.hash, this.value, this.articles, (ImmutableList<StencilClient.LocaleLabel>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWorkflowReleaseItem && this.equalTo((ImmutableWorkflowReleaseItem)another);
    }

    private boolean equalTo(ImmutableWorkflowReleaseItem another) {
        return this.id.equals(another.id) && this.hash.equals(another.hash) && this.value.equals(another.value) && this.articles.equals(another.articles) && this.labels.equals(another.labels);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.hash.hashCode();
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + this.articles.hashCode();
        h += (h << 5) + this.labels.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"WorkflowReleaseItem").omitNullValues().add("id", (Object)this.id).add("hash", (Object)this.hash).add("value", (Object)this.value).add("articles", this.articles).add("labels", this.labels).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableWorkflowReleaseItem fromJson(Json json) {
        Builder builder = ImmutableWorkflowReleaseItem.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.hash != null) {
            builder.hash(json.hash);
        }
        if (json.value != null) {
            builder.value(json.value);
        }
        if (json.articles != null) {
            builder.addAllArticles(json.articles);
        }
        if (json.labels != null) {
            builder.addAllLabels(json.labels);
        }
        return builder.build();
    }

    public static ImmutableWorkflowReleaseItem copyOf(StencilClient.WorkflowReleaseItem instance) {
        if (instance instanceof ImmutableWorkflowReleaseItem) {
            return (ImmutableWorkflowReleaseItem)instance;
        }
        return ImmutableWorkflowReleaseItem.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StencilClient.WorkflowReleaseItem", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_HASH = 2L;
        private static final long INIT_BIT_VALUE = 4L;
        private long initBits = 7L;
        @Nullable
        private String id;
        @Nullable
        private String hash;
        @Nullable
        private String value;
        private ImmutableList.Builder<String> articles = ImmutableList.builder();
        private ImmutableList.Builder<StencilClient.LocaleLabel> labels = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StencilClient.ReleaseItem instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StencilClient.WorkflowReleaseItem instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            StencilClient.ReleaseItem instance;
            if (object instanceof StencilClient.ReleaseItem) {
                instance = (StencilClient.ReleaseItem)object;
                this.hash(instance.getHash());
                this.id(instance.getId());
            }
            if (object instanceof StencilClient.WorkflowReleaseItem) {
                instance = (StencilClient.WorkflowReleaseItem)object;
                this.value(instance.getValue());
                this.addAllArticles(instance.getArticles());
                this.addAllLabels(instance.getLabels());
            }
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="hash")
        @CanIgnoreReturnValue
        public final Builder hash(String hash) {
            this.hash = Objects.requireNonNull(hash, "hash");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="value")
        @CanIgnoreReturnValue
        public final Builder value(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addArticles(String element) {
            this.articles.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addArticles(String ... elements) {
            this.articles.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="articles")
        @CanIgnoreReturnValue
        public final Builder articles(Iterable<String> elements) {
            this.articles = ImmutableList.builder();
            return this.addAllArticles(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllArticles(Iterable<String> elements) {
            this.articles.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLabels(StencilClient.LocaleLabel element) {
            this.labels.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLabels(StencilClient.LocaleLabel ... elements) {
            this.labels.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="labels")
        @CanIgnoreReturnValue
        public final Builder labels(Iterable<? extends StencilClient.LocaleLabel> elements) {
            this.labels = ImmutableList.builder();
            return this.addAllLabels(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllLabels(Iterable<? extends StencilClient.LocaleLabel> elements) {
            this.labels.addAll(elements);
            return this;
        }

        public ImmutableWorkflowReleaseItem build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableWorkflowReleaseItem(this.id, this.hash, this.value, (ImmutableList<String>)this.articles.build(), (ImmutableList<StencilClient.LocaleLabel>)this.labels.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("hash");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build WorkflowReleaseItem, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="StencilClient.WorkflowReleaseItem", generator="Immutables")
    static final class Json
    implements StencilClient.WorkflowReleaseItem {
        @Nullable
        String id;
        @Nullable
        String hash;
        @Nullable
        String value;
        @Nullable
        List<String> articles = ImmutableList.of();
        @Nullable
        List<StencilClient.LocaleLabel> labels = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="hash")
        public void setHash(String hash) {
            this.hash = hash;
        }

        @JsonProperty(value="value")
        public void setValue(String value) {
            this.value = value;
        }

        @JsonProperty(value="articles")
        public void setArticles(List<String> articles) {
            this.articles = articles;
        }

        @JsonProperty(value="labels")
        public void setLabels(List<StencilClient.LocaleLabel> labels) {
            this.labels = labels;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getArticles() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<StencilClient.LocaleLabel> getLabels() {
            throw new UnsupportedOperationException();
        }
    }
}

