/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.thestencil.client.api.StencilClient;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="StencilClient.Page", generator="Immutables")
@Immutable
public final class ImmutablePage
implements StencilClient.Page {
    private final String article;
    @Nullable
    private final Boolean devMode;
    private final String locale;
    private final String content;

    private ImmutablePage(String article, @Nullable Boolean devMode, String locale, String content) {
        this.article = article;
        this.devMode = devMode;
        this.locale = locale;
        this.content = content;
    }

    @Override
    @JsonProperty(value="article")
    public String getArticle() {
        return this.article;
    }

    @Override
    @JsonProperty(value="devMode")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public Boolean getDevMode() {
        return this.devMode;
    }

    @Override
    @JsonProperty(value="locale")
    public String getLocale() {
        return this.locale;
    }

    @Override
    @JsonProperty(value="content")
    public String getContent() {
        return this.content;
    }

    public final ImmutablePage withArticle(String value) {
        String newValue = Objects.requireNonNull(value, "article");
        if (this.article.equals(newValue)) {
            return this;
        }
        return new ImmutablePage(newValue, this.devMode, this.locale, this.content);
    }

    public final ImmutablePage withDevMode(@Nullable Boolean value) {
        if (Objects.equals(this.devMode, value)) {
            return this;
        }
        return new ImmutablePage(this.article, value, this.locale, this.content);
    }

    public final ImmutablePage withLocale(String value) {
        String newValue = Objects.requireNonNull(value, "locale");
        if (this.locale.equals(newValue)) {
            return this;
        }
        return new ImmutablePage(this.article, this.devMode, newValue, this.content);
    }

    public final ImmutablePage withContent(String value) {
        String newValue = Objects.requireNonNull(value, "content");
        if (this.content.equals(newValue)) {
            return this;
        }
        return new ImmutablePage(this.article, this.devMode, this.locale, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePage && this.equalTo((ImmutablePage)another);
    }

    private boolean equalTo(ImmutablePage another) {
        return this.article.equals(another.article) && Objects.equals(this.devMode, another.devMode) && this.locale.equals(another.locale) && this.content.equals(another.content);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.article.hashCode();
        h += (h << 5) + Objects.hashCode(this.devMode);
        h += (h << 5) + this.locale.hashCode();
        h += (h << 5) + this.content.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Page").omitNullValues().add("article", (Object)this.article).add("devMode", (Object)this.devMode).add("locale", (Object)this.locale).add("content", (Object)this.content).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePage fromJson(Json json) {
        Builder builder = ImmutablePage.builder();
        if (json.article != null) {
            builder.article(json.article);
        }
        if (json.devMode != null) {
            builder.devMode(json.devMode);
        }
        if (json.locale != null) {
            builder.locale(json.locale);
        }
        if (json.content != null) {
            builder.content(json.content);
        }
        return builder.build();
    }

    public static ImmutablePage copyOf(StencilClient.Page instance) {
        if (instance instanceof ImmutablePage) {
            return (ImmutablePage)instance;
        }
        return ImmutablePage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StencilClient.Page", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ARTICLE = 1L;
        private static final long INIT_BIT_LOCALE = 2L;
        private static final long INIT_BIT_CONTENT = 4L;
        private long initBits = 7L;
        @Nullable
        private String article;
        @Nullable
        private Boolean devMode;
        @Nullable
        private String locale;
        @Nullable
        private String content;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StencilClient.Page instance) {
            Objects.requireNonNull(instance, "instance");
            this.article(instance.getArticle());
            Boolean devModeValue = instance.getDevMode();
            if (devModeValue != null) {
                this.devMode(devModeValue);
            }
            this.locale(instance.getLocale());
            this.content(instance.getContent());
            return this;
        }

        @JsonProperty(value="article")
        @CanIgnoreReturnValue
        public final Builder article(String article) {
            this.article = Objects.requireNonNull(article, "article");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="devMode")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @CanIgnoreReturnValue
        public final Builder devMode(@Nullable Boolean devMode) {
            this.devMode = devMode;
            return this;
        }

        @JsonProperty(value="locale")
        @CanIgnoreReturnValue
        public final Builder locale(String locale) {
            this.locale = Objects.requireNonNull(locale, "locale");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="content")
        @CanIgnoreReturnValue
        public final Builder content(String content) {
            this.content = Objects.requireNonNull(content, "content");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutablePage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePage(this.article, this.devMode, this.locale, this.content);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("article");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("locale");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("content");
            }
            return "Cannot build Page, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="StencilClient.Page", generator="Immutables")
    static final class Json
    implements StencilClient.Page {
        @Nullable
        String article;
        @Nullable
        Boolean devMode;
        @Nullable
        String locale;
        @Nullable
        String content;

        Json() {
        }

        @JsonProperty(value="article")
        public void setArticle(String article) {
            this.article = article;
        }

        @JsonProperty(value="devMode")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public void setDevMode(@Nullable Boolean devMode) {
            this.devMode = devMode;
        }

        @JsonProperty(value="locale")
        public void setLocale(String locale) {
            this.locale = locale;
        }

        @JsonProperty(value="content")
        public void setContent(String content) {
            this.content = content;
        }

        @Override
        public String getArticle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getDevMode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getLocale() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getContent() {
            throw new UnsupportedOperationException();
        }
    }
}

