/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.thestencil.client.api.CreateBuilder;
import io.thestencil.client.api.StencilClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CreateBuilder.CreateWorkflow", generator="Immutables")
@Immutable
public final class ImmutableCreateWorkflow
implements CreateBuilder.CreateWorkflow {
    @Nullable
    private final String id;
    private final String value;
    private final ImmutableList<String> articles;
    private final ImmutableList<StencilClient.LocaleLabel> labels;
    @Nullable
    private final Boolean devMode;

    private ImmutableCreateWorkflow(@Nullable String id, String value, ImmutableList<String> articles, ImmutableList<StencilClient.LocaleLabel> labels, @Nullable Boolean devMode) {
        this.id = id;
        this.value = value;
        this.articles = articles;
        this.labels = labels;
        this.devMode = devMode;
    }

    @Override
    @JsonProperty(value="id")
    @Nullable
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    @JsonProperty(value="articles")
    public ImmutableList<String> getArticles() {
        return this.articles;
    }

    @JsonProperty(value="labels")
    public ImmutableList<StencilClient.LocaleLabel> getLabels() {
        return this.labels;
    }

    @Override
    @JsonProperty(value="devMode")
    @Nullable
    public Boolean getDevMode() {
        return this.devMode;
    }

    public final ImmutableCreateWorkflow withId(@Nullable String value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableCreateWorkflow(value, this.value, this.articles, this.labels, this.devMode);
    }

    public final ImmutableCreateWorkflow withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new ImmutableCreateWorkflow(this.id, newValue, this.articles, this.labels, this.devMode);
    }

    public final ImmutableCreateWorkflow withArticles(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCreateWorkflow(this.id, this.value, (ImmutableList<String>)newValue, this.labels, this.devMode);
    }

    public final ImmutableCreateWorkflow withArticles(Iterable<String> elements) {
        if (this.articles == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCreateWorkflow(this.id, this.value, (ImmutableList<String>)newValue, this.labels, this.devMode);
    }

    public final ImmutableCreateWorkflow withLabels(StencilClient.LocaleLabel ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCreateWorkflow(this.id, this.value, this.articles, (ImmutableList<StencilClient.LocaleLabel>)newValue, this.devMode);
    }

    public final ImmutableCreateWorkflow withLabels(Iterable<? extends StencilClient.LocaleLabel> elements) {
        if (this.labels == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCreateWorkflow(this.id, this.value, this.articles, (ImmutableList<StencilClient.LocaleLabel>)newValue, this.devMode);
    }

    public final ImmutableCreateWorkflow withDevMode(@Nullable Boolean value) {
        if (Objects.equals(this.devMode, value)) {
            return this;
        }
        return new ImmutableCreateWorkflow(this.id, this.value, this.articles, this.labels, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCreateWorkflow && this.equalTo((ImmutableCreateWorkflow)another);
    }

    private boolean equalTo(ImmutableCreateWorkflow another) {
        return Objects.equals(this.id, another.id) && this.value.equals(another.value) && this.articles.equals(another.articles) && this.labels.equals(another.labels) && Objects.equals(this.devMode, another.devMode);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + this.articles.hashCode();
        h += (h << 5) + this.labels.hashCode();
        h += (h << 5) + Objects.hashCode(this.devMode);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CreateWorkflow").omitNullValues().add("id", (Object)this.id).add("value", (Object)this.value).add("articles", this.articles).add("labels", this.labels).add("devMode", (Object)this.devMode).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCreateWorkflow fromJson(Json json) {
        Builder builder = ImmutableCreateWorkflow.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.value != null) {
            builder.value(json.value);
        }
        if (json.articles != null) {
            builder.addAllArticles(json.articles);
        }
        if (json.labels != null) {
            builder.addAllLabels(json.labels);
        }
        if (json.devMode != null) {
            builder.devMode(json.devMode);
        }
        return builder.build();
    }

    public static ImmutableCreateWorkflow copyOf(CreateBuilder.CreateWorkflow instance) {
        if (instance instanceof ImmutableCreateWorkflow) {
            return (ImmutableCreateWorkflow)instance;
        }
        return ImmutableCreateWorkflow.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CreateBuilder.CreateWorkflow", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VALUE = 1L;
        private long initBits = 1L;
        @Nullable
        private String id;
        @Nullable
        private String value;
        private ImmutableList.Builder<String> articles = ImmutableList.builder();
        private ImmutableList.Builder<StencilClient.LocaleLabel> labels = ImmutableList.builder();
        @Nullable
        private Boolean devMode;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CreateBuilder.CreateWorkflow instance) {
            Objects.requireNonNull(instance, "instance");
            String idValue = instance.getId();
            if (idValue != null) {
                this.id(idValue);
            }
            this.value(instance.getValue());
            this.addAllArticles(instance.getArticles());
            this.addAllLabels(instance.getLabels());
            Boolean devModeValue = instance.getDevMode();
            if (devModeValue != null) {
                this.devMode(devModeValue);
            }
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="value")
        @CanIgnoreReturnValue
        public final Builder value(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addArticles(String element) {
            this.articles.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addArticles(String ... elements) {
            this.articles.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="articles")
        @CanIgnoreReturnValue
        public final Builder articles(Iterable<String> elements) {
            this.articles = ImmutableList.builder();
            return this.addAllArticles(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllArticles(Iterable<String> elements) {
            this.articles.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLabels(StencilClient.LocaleLabel element) {
            this.labels.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLabels(StencilClient.LocaleLabel ... elements) {
            this.labels.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="labels")
        @CanIgnoreReturnValue
        public final Builder labels(Iterable<? extends StencilClient.LocaleLabel> elements) {
            this.labels = ImmutableList.builder();
            return this.addAllLabels(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllLabels(Iterable<? extends StencilClient.LocaleLabel> elements) {
            this.labels.addAll(elements);
            return this;
        }

        @JsonProperty(value="devMode")
        @CanIgnoreReturnValue
        public final Builder devMode(@Nullable Boolean devMode) {
            this.devMode = devMode;
            return this;
        }

        public ImmutableCreateWorkflow build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCreateWorkflow(this.id, this.value, (ImmutableList<String>)this.articles.build(), (ImmutableList<StencilClient.LocaleLabel>)this.labels.build(), this.devMode);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build CreateWorkflow, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CreateBuilder.CreateWorkflow", generator="Immutables")
    static final class Json
    implements CreateBuilder.CreateWorkflow {
        @Nullable
        String id;
        @Nullable
        String value;
        @Nullable
        List<String> articles = ImmutableList.of();
        @Nullable
        List<StencilClient.LocaleLabel> labels = ImmutableList.of();
        @Nullable
        Boolean devMode;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(@Nullable String id) {
            this.id = id;
        }

        @JsonProperty(value="value")
        public void setValue(String value) {
            this.value = value;
        }

        @JsonProperty(value="articles")
        public void setArticles(List<String> articles) {
            this.articles = articles;
        }

        @JsonProperty(value="labels")
        public void setLabels(List<StencilClient.LocaleLabel> labels) {
            this.labels = labels;
        }

        @JsonProperty(value="devMode")
        public void setDevMode(@Nullable Boolean devMode) {
            this.devMode = devMode;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getArticles() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<StencilClient.LocaleLabel> getLabels() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getDevMode() {
            throw new UnsupportedOperationException();
        }
    }
}

