/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.thestencil.client.api.CreateBuilder;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CreateBuilder.CreateTemplate", generator="Immutables")
@Immutable
public final class ImmutableCreateTemplate
implements CreateBuilder.CreateTemplate {
    @Nullable
    private final String id;
    private final String name;
    private final String description;
    private final String content;
    private final String type;

    private ImmutableCreateTemplate(@Nullable String id, String name, String description, String content, String type) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.content = content;
        this.type = type;
    }

    @Override
    @JsonProperty(value="id")
    @Nullable
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="content")
    public String getContent() {
        return this.content;
    }

    @Override
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    public final ImmutableCreateTemplate withId(@Nullable String value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableCreateTemplate(value, this.name, this.description, this.content, this.type);
    }

    public final ImmutableCreateTemplate withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableCreateTemplate(this.id, newValue, this.description, this.content, this.type);
    }

    public final ImmutableCreateTemplate withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (this.description.equals(newValue)) {
            return this;
        }
        return new ImmutableCreateTemplate(this.id, this.name, newValue, this.content, this.type);
    }

    public final ImmutableCreateTemplate withContent(String value) {
        String newValue = Objects.requireNonNull(value, "content");
        if (this.content.equals(newValue)) {
            return this;
        }
        return new ImmutableCreateTemplate(this.id, this.name, this.description, newValue, this.type);
    }

    public final ImmutableCreateTemplate withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ImmutableCreateTemplate(this.id, this.name, this.description, this.content, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCreateTemplate && this.equalTo((ImmutableCreateTemplate)another);
    }

    private boolean equalTo(ImmutableCreateTemplate another) {
        return Objects.equals(this.id, another.id) && this.name.equals(another.name) && this.description.equals(another.description) && this.content.equals(another.content) && this.type.equals(another.type);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.description.hashCode();
        h += (h << 5) + this.content.hashCode();
        h += (h << 5) + this.type.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CreateTemplate").omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("description", (Object)this.description).add("content", (Object)this.content).add("type", (Object)this.type).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCreateTemplate fromJson(Json json) {
        Builder builder = ImmutableCreateTemplate.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.content != null) {
            builder.content(json.content);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        return builder.build();
    }

    public static ImmutableCreateTemplate copyOf(CreateBuilder.CreateTemplate instance) {
        if (instance instanceof ImmutableCreateTemplate) {
            return (ImmutableCreateTemplate)instance;
        }
        return ImmutableCreateTemplate.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CreateBuilder.CreateTemplate", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_DESCRIPTION = 2L;
        private static final long INIT_BIT_CONTENT = 4L;
        private static final long INIT_BIT_TYPE = 8L;
        private long initBits = 15L;
        @Nullable
        private String id;
        @Nullable
        private String name;
        @Nullable
        private String description;
        @Nullable
        private String content;
        @Nullable
        private String type;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CreateBuilder.CreateTemplate instance) {
            Objects.requireNonNull(instance, "instance");
            String idValue = instance.getId();
            if (idValue != null) {
                this.id(idValue);
            }
            this.name(instance.getName());
            this.description(instance.getDescription());
            this.content(instance.getContent());
            this.type(instance.getType());
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="description")
        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="content")
        @CanIgnoreReturnValue
        public final Builder content(String content) {
            this.content = Objects.requireNonNull(content, "content");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableCreateTemplate build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCreateTemplate(this.id, this.name, this.description, this.content, this.type);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("description");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("content");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build CreateTemplate, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CreateBuilder.CreateTemplate", generator="Immutables")
    static final class Json
    implements CreateBuilder.CreateTemplate {
        @Nullable
        String id;
        @Nullable
        String name;
        @Nullable
        String description;
        @Nullable
        String content;
        @Nullable
        String type;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(@Nullable String id) {
            this.id = id;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="content")
        public void setContent(String content) {
            this.content = content;
        }

        @JsonProperty(value="type")
        public void setType(String type) {
            this.type = type;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDescription() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getContent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }
    }
}

