/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.api;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.thestencil.client.api.StencilClient;
import io.thestencil.client.api.StencilStore;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="StencilStore.BatchCommand", generator="Immutables")
@Immutable
public final class ImmutableBatchCommand
implements StencilStore.BatchCommand {
    private final ImmutableList<StencilClient.Entity> toBeCreated;
    private final ImmutableList<StencilClient.Entity> toBeSaved;
    private final ImmutableList<StencilClient.Entity> toBeDeleted;

    private ImmutableBatchCommand(ImmutableList<StencilClient.Entity> toBeCreated, ImmutableList<StencilClient.Entity> toBeSaved, ImmutableList<StencilClient.Entity> toBeDeleted) {
        this.toBeCreated = toBeCreated;
        this.toBeSaved = toBeSaved;
        this.toBeDeleted = toBeDeleted;
    }

    public ImmutableList<StencilClient.Entity> getToBeCreated() {
        return this.toBeCreated;
    }

    public ImmutableList<StencilClient.Entity> getToBeSaved() {
        return this.toBeSaved;
    }

    public ImmutableList<StencilClient.Entity> getToBeDeleted() {
        return this.toBeDeleted;
    }

    public final ImmutableBatchCommand withToBeCreated(StencilClient.Entity ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableBatchCommand((ImmutableList<StencilClient.Entity>)newValue, this.toBeSaved, this.toBeDeleted);
    }

    public final ImmutableBatchCommand withToBeCreated(Iterable<? extends StencilClient.Entity> elements) {
        if (this.toBeCreated == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableBatchCommand((ImmutableList<StencilClient.Entity>)newValue, this.toBeSaved, this.toBeDeleted);
    }

    public final ImmutableBatchCommand withToBeSaved(StencilClient.Entity ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableBatchCommand(this.toBeCreated, (ImmutableList<StencilClient.Entity>)newValue, this.toBeDeleted);
    }

    public final ImmutableBatchCommand withToBeSaved(Iterable<? extends StencilClient.Entity> elements) {
        if (this.toBeSaved == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableBatchCommand(this.toBeCreated, (ImmutableList<StencilClient.Entity>)newValue, this.toBeDeleted);
    }

    public final ImmutableBatchCommand withToBeDeleted(StencilClient.Entity ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableBatchCommand(this.toBeCreated, this.toBeSaved, (ImmutableList<StencilClient.Entity>)newValue);
    }

    public final ImmutableBatchCommand withToBeDeleted(Iterable<? extends StencilClient.Entity> elements) {
        if (this.toBeDeleted == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableBatchCommand(this.toBeCreated, this.toBeSaved, (ImmutableList<StencilClient.Entity>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBatchCommand && this.equalTo((ImmutableBatchCommand)another);
    }

    private boolean equalTo(ImmutableBatchCommand another) {
        return this.toBeCreated.equals(another.toBeCreated) && this.toBeSaved.equals(another.toBeSaved) && this.toBeDeleted.equals(another.toBeDeleted);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.toBeCreated.hashCode();
        h += (h << 5) + this.toBeSaved.hashCode();
        h += (h << 5) + this.toBeDeleted.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"BatchCommand").omitNullValues().add("toBeCreated", this.toBeCreated).add("toBeSaved", this.toBeSaved).add("toBeDeleted", this.toBeDeleted).toString();
    }

    public static ImmutableBatchCommand copyOf(StencilStore.BatchCommand instance) {
        if (instance instanceof ImmutableBatchCommand) {
            return (ImmutableBatchCommand)instance;
        }
        return ImmutableBatchCommand.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StencilStore.BatchCommand", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<StencilClient.Entity> toBeCreated = ImmutableList.builder();
        private ImmutableList.Builder<StencilClient.Entity> toBeSaved = ImmutableList.builder();
        private ImmutableList.Builder<StencilClient.Entity> toBeDeleted = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StencilStore.BatchCommand instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllToBeCreated(instance.getToBeCreated());
            this.addAllToBeSaved(instance.getToBeSaved());
            this.addAllToBeDeleted(instance.getToBeDeleted());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addToBeCreated(StencilClient.Entity element) {
            this.toBeCreated.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addToBeCreated(StencilClient.Entity ... elements) {
            this.toBeCreated.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder toBeCreated(Iterable<? extends StencilClient.Entity> elements) {
            this.toBeCreated = ImmutableList.builder();
            return this.addAllToBeCreated(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllToBeCreated(Iterable<? extends StencilClient.Entity> elements) {
            this.toBeCreated.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addToBeSaved(StencilClient.Entity element) {
            this.toBeSaved.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addToBeSaved(StencilClient.Entity ... elements) {
            this.toBeSaved.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder toBeSaved(Iterable<? extends StencilClient.Entity> elements) {
            this.toBeSaved = ImmutableList.builder();
            return this.addAllToBeSaved(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllToBeSaved(Iterable<? extends StencilClient.Entity> elements) {
            this.toBeSaved.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addToBeDeleted(StencilClient.Entity element) {
            this.toBeDeleted.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addToBeDeleted(StencilClient.Entity ... elements) {
            this.toBeDeleted.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder toBeDeleted(Iterable<? extends StencilClient.Entity> elements) {
            this.toBeDeleted = ImmutableList.builder();
            return this.addAllToBeDeleted(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllToBeDeleted(Iterable<? extends StencilClient.Entity> elements) {
            this.toBeDeleted.addAll(elements);
            return this;
        }

        public ImmutableBatchCommand build() {
            return new ImmutableBatchCommand((ImmutableList<StencilClient.Entity>)this.toBeCreated.build(), (ImmutableList<StencilClient.Entity>)this.toBeSaved.build(), (ImmutableList<StencilClient.Entity>)this.toBeDeleted.build());
        }
    }
}

