/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.thestencil.client.api.StencilClient;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="StencilClient.Article", generator="Immutables")
@Immutable
public final class ImmutableArticle
implements StencilClient.Article {
    @Nullable
    private final String parentId;
    @Nullable
    private final Boolean devMode;
    private final String name;
    private final Integer order;

    private ImmutableArticle(@Nullable String parentId, @Nullable Boolean devMode, String name, Integer order) {
        this.parentId = parentId;
        this.devMode = devMode;
        this.name = name;
        this.order = order;
    }

    @Override
    @JsonProperty(value="parentId")
    @Nullable
    public String getParentId() {
        return this.parentId;
    }

    @Override
    @JsonProperty(value="devMode")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public Boolean getDevMode() {
        return this.devMode;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="order")
    public Integer getOrder() {
        return this.order;
    }

    public final ImmutableArticle withParentId(@Nullable String value) {
        if (Objects.equals(this.parentId, value)) {
            return this;
        }
        return new ImmutableArticle(value, this.devMode, this.name, this.order);
    }

    public final ImmutableArticle withDevMode(@Nullable Boolean value) {
        if (Objects.equals(this.devMode, value)) {
            return this;
        }
        return new ImmutableArticle(this.parentId, value, this.name, this.order);
    }

    public final ImmutableArticle withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableArticle(this.parentId, this.devMode, newValue, this.order);
    }

    public final ImmutableArticle withOrder(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "order");
        if (this.order.equals(newValue)) {
            return this;
        }
        return new ImmutableArticle(this.parentId, this.devMode, this.name, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableArticle && this.equalTo((ImmutableArticle)another);
    }

    private boolean equalTo(ImmutableArticle another) {
        return Objects.equals(this.parentId, another.parentId) && Objects.equals(this.devMode, another.devMode) && this.name.equals(another.name) && this.order.equals(another.order);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.parentId);
        h += (h << 5) + Objects.hashCode(this.devMode);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.order.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Article").omitNullValues().add("parentId", (Object)this.parentId).add("devMode", (Object)this.devMode).add("name", (Object)this.name).add("order", (Object)this.order).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableArticle fromJson(Json json) {
        Builder builder = ImmutableArticle.builder();
        if (json.parentId != null) {
            builder.parentId(json.parentId);
        }
        if (json.devMode != null) {
            builder.devMode(json.devMode);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.order != null) {
            builder.order(json.order);
        }
        return builder.build();
    }

    public static ImmutableArticle copyOf(StencilClient.Article instance) {
        if (instance instanceof ImmutableArticle) {
            return (ImmutableArticle)instance;
        }
        return ImmutableArticle.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StencilClient.Article", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_ORDER = 2L;
        private long initBits = 3L;
        @Nullable
        private String parentId;
        @Nullable
        private Boolean devMode;
        @Nullable
        private String name;
        @Nullable
        private Integer order;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StencilClient.Article instance) {
            Boolean devModeValue;
            Objects.requireNonNull(instance, "instance");
            String parentIdValue = instance.getParentId();
            if (parentIdValue != null) {
                this.parentId(parentIdValue);
            }
            if ((devModeValue = instance.getDevMode()) != null) {
                this.devMode(devModeValue);
            }
            this.name(instance.getName());
            this.order(instance.getOrder());
            return this;
        }

        @JsonProperty(value="parentId")
        @CanIgnoreReturnValue
        public final Builder parentId(@Nullable String parentId) {
            this.parentId = parentId;
            return this;
        }

        @JsonProperty(value="devMode")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @CanIgnoreReturnValue
        public final Builder devMode(@Nullable Boolean devMode) {
            this.devMode = devMode;
            return this;
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="order")
        @CanIgnoreReturnValue
        public final Builder order(Integer order) {
            this.order = Objects.requireNonNull(order, "order");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableArticle build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableArticle(this.parentId, this.devMode, this.name, this.order);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("order");
            }
            return "Cannot build Article, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="StencilClient.Article", generator="Immutables")
    static final class Json
    implements StencilClient.Article {
        @Nullable
        String parentId;
        @Nullable
        Boolean devMode;
        @Nullable
        String name;
        @Nullable
        Integer order;

        Json() {
        }

        @JsonProperty(value="parentId")
        public void setParentId(@Nullable String parentId) {
            this.parentId = parentId;
        }

        @JsonProperty(value="devMode")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public void setDevMode(@Nullable Boolean devMode) {
            this.devMode = devMode;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="order")
        public void setOrder(Integer order) {
            this.order = order;
        }

        @Override
        public String getParentId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getDevMode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getOrder() {
            throw new UnsupportedOperationException();
        }
    }
}

