package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link StencilClient.Release}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRelease.builder()}.
 */
@Generated(from = "StencilClient.Release", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableRelease implements StencilClient.Release {
  private final String parentCommit;
  private final String name;
  private final String note;
  private final LocalDateTime created;
  private final ImmutableList<StencilClient.LocaleReleaseItem> locales;
  private final ImmutableList<StencilClient.ArticleReleaseItem> articles;
  private final ImmutableList<StencilClient.LinkReleaseItem> links;
  private final ImmutableList<StencilClient.WorkflowReleaseItem> workflows;
  private final ImmutableList<StencilClient.PageReleaseItem> pages;
  private final ImmutableList<StencilClient.TemplateReleaseItem> templates;

  private ImmutableRelease(
      String parentCommit,
      String name,
      String note,
      LocalDateTime created,
      ImmutableList<StencilClient.LocaleReleaseItem> locales,
      ImmutableList<StencilClient.ArticleReleaseItem> articles,
      ImmutableList<StencilClient.LinkReleaseItem> links,
      ImmutableList<StencilClient.WorkflowReleaseItem> workflows,
      ImmutableList<StencilClient.PageReleaseItem> pages,
      ImmutableList<StencilClient.TemplateReleaseItem> templates) {
    this.parentCommit = parentCommit;
    this.name = name;
    this.note = note;
    this.created = created;
    this.locales = locales;
    this.articles = articles;
    this.links = links;
    this.workflows = workflows;
    this.pages = pages;
    this.templates = templates;
  }

  /**
   * @return The value of the {@code parentCommit} attribute
   */
  @JsonProperty("parentCommit")
  @Override
  public String getParentCommit() {
    return parentCommit;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code note} attribute
   */
  @JsonProperty("note")
  @Override
  public String getNote() {
    return note;
  }

  /**
   * @return The value of the {@code created} attribute
   */
  @JsonProperty("created")
  @Override
  public LocalDateTime getCreated() {
    return created;
  }

  /**
   * @return The value of the {@code locales} attribute
   */
  @JsonProperty("locales")
  @Override
  public ImmutableList<StencilClient.LocaleReleaseItem> getLocales() {
    return locales;
  }

  /**
   * @return The value of the {@code articles} attribute
   */
  @JsonProperty("articles")
  @Override
  public ImmutableList<StencilClient.ArticleReleaseItem> getArticles() {
    return articles;
  }

  /**
   * @return The value of the {@code links} attribute
   */
  @JsonProperty("links")
  @Override
  public ImmutableList<StencilClient.LinkReleaseItem> getLinks() {
    return links;
  }

  /**
   * @return The value of the {@code workflows} attribute
   */
  @JsonProperty("workflows")
  @Override
  public ImmutableList<StencilClient.WorkflowReleaseItem> getWorkflows() {
    return workflows;
  }

  /**
   * @return The value of the {@code pages} attribute
   */
  @JsonProperty("pages")
  @Override
  public ImmutableList<StencilClient.PageReleaseItem> getPages() {
    return pages;
  }

  /**
   * @return The value of the {@code templates} attribute
   */
  @JsonProperty("templates")
  @Override
  public ImmutableList<StencilClient.TemplateReleaseItem> getTemplates() {
    return templates;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.Release#getParentCommit() parentCommit} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for parentCommit
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRelease withParentCommit(String value) {
    String newValue = Objects.requireNonNull(value, "parentCommit");
    if (this.parentCommit.equals(newValue)) return this;
    return new ImmutableRelease(
        newValue,
        this.name,
        this.note,
        this.created,
        this.locales,
        this.articles,
        this.links,
        this.workflows,
        this.pages,
        this.templates);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.Release#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRelease withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableRelease(
        this.parentCommit,
        newValue,
        this.note,
        this.created,
        this.locales,
        this.articles,
        this.links,
        this.workflows,
        this.pages,
        this.templates);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.Release#getNote() note} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for note
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRelease withNote(String value) {
    String newValue = Objects.requireNonNull(value, "note");
    if (this.note.equals(newValue)) return this;
    return new ImmutableRelease(
        this.parentCommit,
        this.name,
        newValue,
        this.created,
        this.locales,
        this.articles,
        this.links,
        this.workflows,
        this.pages,
        this.templates);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.Release#getCreated() created} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for created
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRelease withCreated(LocalDateTime value) {
    if (this.created == value) return this;
    LocalDateTime newValue = Objects.requireNonNull(value, "created");
    return new ImmutableRelease(
        this.parentCommit,
        this.name,
        this.note,
        newValue,
        this.locales,
        this.articles,
        this.links,
        this.workflows,
        this.pages,
        this.templates);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StencilClient.Release#getLocales() locales}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRelease withLocales(StencilClient.LocaleReleaseItem... elements) {
    ImmutableList<StencilClient.LocaleReleaseItem> newValue = ImmutableList.copyOf(elements);
    return new ImmutableRelease(
        this.parentCommit,
        this.name,
        this.note,
        this.created,
        newValue,
        this.articles,
        this.links,
        this.workflows,
        this.pages,
        this.templates);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StencilClient.Release#getLocales() locales}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of locales elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRelease withLocales(Iterable<? extends StencilClient.LocaleReleaseItem> elements) {
    if (this.locales == elements) return this;
    ImmutableList<StencilClient.LocaleReleaseItem> newValue = ImmutableList.copyOf(elements);
    return new ImmutableRelease(
        this.parentCommit,
        this.name,
        this.note,
        this.created,
        newValue,
        this.articles,
        this.links,
        this.workflows,
        this.pages,
        this.templates);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StencilClient.Release#getArticles() articles}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRelease withArticles(StencilClient.ArticleReleaseItem... elements) {
    ImmutableList<StencilClient.ArticleReleaseItem> newValue = ImmutableList.copyOf(elements);
    return new ImmutableRelease(
        this.parentCommit,
        this.name,
        this.note,
        this.created,
        this.locales,
        newValue,
        this.links,
        this.workflows,
        this.pages,
        this.templates);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StencilClient.Release#getArticles() articles}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of articles elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRelease withArticles(Iterable<? extends StencilClient.ArticleReleaseItem> elements) {
    if (this.articles == elements) return this;
    ImmutableList<StencilClient.ArticleReleaseItem> newValue = ImmutableList.copyOf(elements);
    return new ImmutableRelease(
        this.parentCommit,
        this.name,
        this.note,
        this.created,
        this.locales,
        newValue,
        this.links,
        this.workflows,
        this.pages,
        this.templates);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StencilClient.Release#getLinks() links}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRelease withLinks(StencilClient.LinkReleaseItem... elements) {
    ImmutableList<StencilClient.LinkReleaseItem> newValue = ImmutableList.copyOf(elements);
    return new ImmutableRelease(
        this.parentCommit,
        this.name,
        this.note,
        this.created,
        this.locales,
        this.articles,
        newValue,
        this.workflows,
        this.pages,
        this.templates);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StencilClient.Release#getLinks() links}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of links elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRelease withLinks(Iterable<? extends StencilClient.LinkReleaseItem> elements) {
    if (this.links == elements) return this;
    ImmutableList<StencilClient.LinkReleaseItem> newValue = ImmutableList.copyOf(elements);
    return new ImmutableRelease(
        this.parentCommit,
        this.name,
        this.note,
        this.created,
        this.locales,
        this.articles,
        newValue,
        this.workflows,
        this.pages,
        this.templates);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StencilClient.Release#getWorkflows() workflows}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRelease withWorkflows(StencilClient.WorkflowReleaseItem... elements) {
    ImmutableList<StencilClient.WorkflowReleaseItem> newValue = ImmutableList.copyOf(elements);
    return new ImmutableRelease(
        this.parentCommit,
        this.name,
        this.note,
        this.created,
        this.locales,
        this.articles,
        this.links,
        newValue,
        this.pages,
        this.templates);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StencilClient.Release#getWorkflows() workflows}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of workflows elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRelease withWorkflows(Iterable<? extends StencilClient.WorkflowReleaseItem> elements) {
    if (this.workflows == elements) return this;
    ImmutableList<StencilClient.WorkflowReleaseItem> newValue = ImmutableList.copyOf(elements);
    return new ImmutableRelease(
        this.parentCommit,
        this.name,
        this.note,
        this.created,
        this.locales,
        this.articles,
        this.links,
        newValue,
        this.pages,
        this.templates);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StencilClient.Release#getPages() pages}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRelease withPages(StencilClient.PageReleaseItem... elements) {
    ImmutableList<StencilClient.PageReleaseItem> newValue = ImmutableList.copyOf(elements);
    return new ImmutableRelease(
        this.parentCommit,
        this.name,
        this.note,
        this.created,
        this.locales,
        this.articles,
        this.links,
        this.workflows,
        newValue,
        this.templates);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StencilClient.Release#getPages() pages}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of pages elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRelease withPages(Iterable<? extends StencilClient.PageReleaseItem> elements) {
    if (this.pages == elements) return this;
    ImmutableList<StencilClient.PageReleaseItem> newValue = ImmutableList.copyOf(elements);
    return new ImmutableRelease(
        this.parentCommit,
        this.name,
        this.note,
        this.created,
        this.locales,
        this.articles,
        this.links,
        this.workflows,
        newValue,
        this.templates);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StencilClient.Release#getTemplates() templates}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRelease withTemplates(StencilClient.TemplateReleaseItem... elements) {
    ImmutableList<StencilClient.TemplateReleaseItem> newValue = ImmutableList.copyOf(elements);
    return new ImmutableRelease(
        this.parentCommit,
        this.name,
        this.note,
        this.created,
        this.locales,
        this.articles,
        this.links,
        this.workflows,
        this.pages,
        newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StencilClient.Release#getTemplates() templates}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of templates elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRelease withTemplates(Iterable<? extends StencilClient.TemplateReleaseItem> elements) {
    if (this.templates == elements) return this;
    ImmutableList<StencilClient.TemplateReleaseItem> newValue = ImmutableList.copyOf(elements);
    return new ImmutableRelease(
        this.parentCommit,
        this.name,
        this.note,
        this.created,
        this.locales,
        this.articles,
        this.links,
        this.workflows,
        this.pages,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRelease} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRelease
        && equalTo((ImmutableRelease) another);
  }

  private boolean equalTo(ImmutableRelease another) {
    return parentCommit.equals(another.parentCommit)
        && name.equals(another.name)
        && note.equals(another.note)
        && created.equals(another.created)
        && locales.equals(another.locales)
        && articles.equals(another.articles)
        && links.equals(another.links)
        && workflows.equals(another.workflows)
        && pages.equals(another.pages)
        && templates.equals(another.templates);
  }

  /**
   * Computes a hash code from attributes: {@code parentCommit}, {@code name}, {@code note}, {@code created}, {@code locales}, {@code articles}, {@code links}, {@code workflows}, {@code pages}, {@code templates}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + parentCommit.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + note.hashCode();
    h += (h << 5) + created.hashCode();
    h += (h << 5) + locales.hashCode();
    h += (h << 5) + articles.hashCode();
    h += (h << 5) + links.hashCode();
    h += (h << 5) + workflows.hashCode();
    h += (h << 5) + pages.hashCode();
    h += (h << 5) + templates.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Release} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Release")
        .omitNullValues()
        .add("parentCommit", parentCommit)
        .add("name", name)
        .add("note", note)
        .add("created", created)
        .add("locales", locales)
        .add("articles", articles)
        .add("links", links)
        .add("workflows", workflows)
        .add("pages", pages)
        .add("templates", templates)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "StencilClient.Release", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements StencilClient.Release {
    @Nullable String parentCommit;
    @Nullable String name;
    @Nullable String note;
    @Nullable LocalDateTime created;
    @Nullable List<StencilClient.LocaleReleaseItem> locales = ImmutableList.of();
    @Nullable List<StencilClient.ArticleReleaseItem> articles = ImmutableList.of();
    @Nullable List<StencilClient.LinkReleaseItem> links = ImmutableList.of();
    @Nullable List<StencilClient.WorkflowReleaseItem> workflows = ImmutableList.of();
    @Nullable List<StencilClient.PageReleaseItem> pages = ImmutableList.of();
    @Nullable List<StencilClient.TemplateReleaseItem> templates = ImmutableList.of();
    @JsonProperty("parentCommit")
    public void setParentCommit(String parentCommit) {
      this.parentCommit = parentCommit;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("note")
    public void setNote(String note) {
      this.note = note;
    }
    @JsonProperty("created")
    public void setCreated(LocalDateTime created) {
      this.created = created;
    }
    @JsonProperty("locales")
    public void setLocales(List<StencilClient.LocaleReleaseItem> locales) {
      this.locales = locales;
    }
    @JsonProperty("articles")
    public void setArticles(List<StencilClient.ArticleReleaseItem> articles) {
      this.articles = articles;
    }
    @JsonProperty("links")
    public void setLinks(List<StencilClient.LinkReleaseItem> links) {
      this.links = links;
    }
    @JsonProperty("workflows")
    public void setWorkflows(List<StencilClient.WorkflowReleaseItem> workflows) {
      this.workflows = workflows;
    }
    @JsonProperty("pages")
    public void setPages(List<StencilClient.PageReleaseItem> pages) {
      this.pages = pages;
    }
    @JsonProperty("templates")
    public void setTemplates(List<StencilClient.TemplateReleaseItem> templates) {
      this.templates = templates;
    }
    @Override
    public String getParentCommit() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getNote() { throw new UnsupportedOperationException(); }
    @Override
    public LocalDateTime getCreated() { throw new UnsupportedOperationException(); }
    @Override
    public List<StencilClient.LocaleReleaseItem> getLocales() { throw new UnsupportedOperationException(); }
    @Override
    public List<StencilClient.ArticleReleaseItem> getArticles() { throw new UnsupportedOperationException(); }
    @Override
    public List<StencilClient.LinkReleaseItem> getLinks() { throw new UnsupportedOperationException(); }
    @Override
    public List<StencilClient.WorkflowReleaseItem> getWorkflows() { throw new UnsupportedOperationException(); }
    @Override
    public List<StencilClient.PageReleaseItem> getPages() { throw new UnsupportedOperationException(); }
    @Override
    public List<StencilClient.TemplateReleaseItem> getTemplates() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableRelease fromJson(Json json) {
    ImmutableRelease.Builder builder = ImmutableRelease.builder();
    if (json.parentCommit != null) {
      builder.parentCommit(json.parentCommit);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.note != null) {
      builder.note(json.note);
    }
    if (json.created != null) {
      builder.created(json.created);
    }
    if (json.locales != null) {
      builder.addAllLocales(json.locales);
    }
    if (json.articles != null) {
      builder.addAllArticles(json.articles);
    }
    if (json.links != null) {
      builder.addAllLinks(json.links);
    }
    if (json.workflows != null) {
      builder.addAllWorkflows(json.workflows);
    }
    if (json.pages != null) {
      builder.addAllPages(json.pages);
    }
    if (json.templates != null) {
      builder.addAllTemplates(json.templates);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link StencilClient.Release} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Release instance
   */
  public static ImmutableRelease copyOf(StencilClient.Release instance) {
    if (instance instanceof ImmutableRelease) {
      return (ImmutableRelease) instance;
    }
    return ImmutableRelease.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRelease ImmutableRelease}.
   * <pre>
   * ImmutableRelease.builder()
   *    .parentCommit(String) // required {@link StencilClient.Release#getParentCommit() parentCommit}
   *    .name(String) // required {@link StencilClient.Release#getName() name}
   *    .note(String) // required {@link StencilClient.Release#getNote() note}
   *    .created(java.time.LocalDateTime) // required {@link StencilClient.Release#getCreated() created}
   *    .addLocales|addAllLocales(io.thestencil.client.api.StencilClient.LocaleReleaseItem) // {@link StencilClient.Release#getLocales() locales} elements
   *    .addArticles|addAllArticles(io.thestencil.client.api.StencilClient.ArticleReleaseItem) // {@link StencilClient.Release#getArticles() articles} elements
   *    .addLinks|addAllLinks(io.thestencil.client.api.StencilClient.LinkReleaseItem) // {@link StencilClient.Release#getLinks() links} elements
   *    .addWorkflows|addAllWorkflows(io.thestencil.client.api.StencilClient.WorkflowReleaseItem) // {@link StencilClient.Release#getWorkflows() workflows} elements
   *    .addPages|addAllPages(io.thestencil.client.api.StencilClient.PageReleaseItem) // {@link StencilClient.Release#getPages() pages} elements
   *    .addTemplates|addAllTemplates(io.thestencil.client.api.StencilClient.TemplateReleaseItem) // {@link StencilClient.Release#getTemplates() templates} elements
   *    .build();
   * </pre>
   * @return A new ImmutableRelease builder
   */
  public static ImmutableRelease.Builder builder() {
    return new ImmutableRelease.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRelease ImmutableRelease}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "StencilClient.Release", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_PARENT_COMMIT = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_NOTE = 0x4L;
    private static final long INIT_BIT_CREATED = 0x8L;
    private long initBits = 0xfL;

    private @Nullable String parentCommit;
    private @Nullable String name;
    private @Nullable String note;
    private @Nullable LocalDateTime created;
    private ImmutableList.Builder<StencilClient.LocaleReleaseItem> locales = ImmutableList.builder();
    private ImmutableList.Builder<StencilClient.ArticleReleaseItem> articles = ImmutableList.builder();
    private ImmutableList.Builder<StencilClient.LinkReleaseItem> links = ImmutableList.builder();
    private ImmutableList.Builder<StencilClient.WorkflowReleaseItem> workflows = ImmutableList.builder();
    private ImmutableList.Builder<StencilClient.PageReleaseItem> pages = ImmutableList.builder();
    private ImmutableList.Builder<StencilClient.TemplateReleaseItem> templates = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Release} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StencilClient.Release instance) {
      Objects.requireNonNull(instance, "instance");
      parentCommit(instance.getParentCommit());
      name(instance.getName());
      note(instance.getNote());
      created(instance.getCreated());
      addAllLocales(instance.getLocales());
      addAllArticles(instance.getArticles());
      addAllLinks(instance.getLinks());
      addAllWorkflows(instance.getWorkflows());
      addAllPages(instance.getPages());
      addAllTemplates(instance.getTemplates());
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.Release#getParentCommit() parentCommit} attribute.
     * @param parentCommit The value for parentCommit 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("parentCommit")
    public final Builder parentCommit(String parentCommit) {
      this.parentCommit = Objects.requireNonNull(parentCommit, "parentCommit");
      initBits &= ~INIT_BIT_PARENT_COMMIT;
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.Release#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.Release#getNote() note} attribute.
     * @param note The value for note 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("note")
    public final Builder note(String note) {
      this.note = Objects.requireNonNull(note, "note");
      initBits &= ~INIT_BIT_NOTE;
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.Release#getCreated() created} attribute.
     * @param created The value for created 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("created")
    public final Builder created(LocalDateTime created) {
      this.created = Objects.requireNonNull(created, "created");
      initBits &= ~INIT_BIT_CREATED;
      return this;
    }

    /**
     * Adds one element to {@link StencilClient.Release#getLocales() locales} list.
     * @param element A locales element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLocales(StencilClient.LocaleReleaseItem element) {
      this.locales.add(element);
      return this;
    }

    /**
     * Adds elements to {@link StencilClient.Release#getLocales() locales} list.
     * @param elements An array of locales elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLocales(StencilClient.LocaleReleaseItem... elements) {
      this.locales.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link StencilClient.Release#getLocales() locales} list.
     * @param elements An iterable of locales elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("locales")
    public final Builder locales(Iterable<? extends StencilClient.LocaleReleaseItem> elements) {
      this.locales = ImmutableList.builder();
      return addAllLocales(elements);
    }

    /**
     * Adds elements to {@link StencilClient.Release#getLocales() locales} list.
     * @param elements An iterable of locales elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllLocales(Iterable<? extends StencilClient.LocaleReleaseItem> elements) {
      this.locales.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link StencilClient.Release#getArticles() articles} list.
     * @param element A articles element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addArticles(StencilClient.ArticleReleaseItem element) {
      this.articles.add(element);
      return this;
    }

    /**
     * Adds elements to {@link StencilClient.Release#getArticles() articles} list.
     * @param elements An array of articles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addArticles(StencilClient.ArticleReleaseItem... elements) {
      this.articles.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link StencilClient.Release#getArticles() articles} list.
     * @param elements An iterable of articles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("articles")
    public final Builder articles(Iterable<? extends StencilClient.ArticleReleaseItem> elements) {
      this.articles = ImmutableList.builder();
      return addAllArticles(elements);
    }

    /**
     * Adds elements to {@link StencilClient.Release#getArticles() articles} list.
     * @param elements An iterable of articles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllArticles(Iterable<? extends StencilClient.ArticleReleaseItem> elements) {
      this.articles.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link StencilClient.Release#getLinks() links} list.
     * @param element A links element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLinks(StencilClient.LinkReleaseItem element) {
      this.links.add(element);
      return this;
    }

    /**
     * Adds elements to {@link StencilClient.Release#getLinks() links} list.
     * @param elements An array of links elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLinks(StencilClient.LinkReleaseItem... elements) {
      this.links.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link StencilClient.Release#getLinks() links} list.
     * @param elements An iterable of links elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("links")
    public final Builder links(Iterable<? extends StencilClient.LinkReleaseItem> elements) {
      this.links = ImmutableList.builder();
      return addAllLinks(elements);
    }

    /**
     * Adds elements to {@link StencilClient.Release#getLinks() links} list.
     * @param elements An iterable of links elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllLinks(Iterable<? extends StencilClient.LinkReleaseItem> elements) {
      this.links.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link StencilClient.Release#getWorkflows() workflows} list.
     * @param element A workflows element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addWorkflows(StencilClient.WorkflowReleaseItem element) {
      this.workflows.add(element);
      return this;
    }

    /**
     * Adds elements to {@link StencilClient.Release#getWorkflows() workflows} list.
     * @param elements An array of workflows elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addWorkflows(StencilClient.WorkflowReleaseItem... elements) {
      this.workflows.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link StencilClient.Release#getWorkflows() workflows} list.
     * @param elements An iterable of workflows elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("workflows")
    public final Builder workflows(Iterable<? extends StencilClient.WorkflowReleaseItem> elements) {
      this.workflows = ImmutableList.builder();
      return addAllWorkflows(elements);
    }

    /**
     * Adds elements to {@link StencilClient.Release#getWorkflows() workflows} list.
     * @param elements An iterable of workflows elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllWorkflows(Iterable<? extends StencilClient.WorkflowReleaseItem> elements) {
      this.workflows.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link StencilClient.Release#getPages() pages} list.
     * @param element A pages element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addPages(StencilClient.PageReleaseItem element) {
      this.pages.add(element);
      return this;
    }

    /**
     * Adds elements to {@link StencilClient.Release#getPages() pages} list.
     * @param elements An array of pages elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addPages(StencilClient.PageReleaseItem... elements) {
      this.pages.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link StencilClient.Release#getPages() pages} list.
     * @param elements An iterable of pages elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("pages")
    public final Builder pages(Iterable<? extends StencilClient.PageReleaseItem> elements) {
      this.pages = ImmutableList.builder();
      return addAllPages(elements);
    }

    /**
     * Adds elements to {@link StencilClient.Release#getPages() pages} list.
     * @param elements An iterable of pages elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllPages(Iterable<? extends StencilClient.PageReleaseItem> elements) {
      this.pages.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link StencilClient.Release#getTemplates() templates} list.
     * @param element A templates element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTemplates(StencilClient.TemplateReleaseItem element) {
      this.templates.add(element);
      return this;
    }

    /**
     * Adds elements to {@link StencilClient.Release#getTemplates() templates} list.
     * @param elements An array of templates elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTemplates(StencilClient.TemplateReleaseItem... elements) {
      this.templates.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link StencilClient.Release#getTemplates() templates} list.
     * @param elements An iterable of templates elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("templates")
    public final Builder templates(Iterable<? extends StencilClient.TemplateReleaseItem> elements) {
      this.templates = ImmutableList.builder();
      return addAllTemplates(elements);
    }

    /**
     * Adds elements to {@link StencilClient.Release#getTemplates() templates} list.
     * @param elements An iterable of templates elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllTemplates(Iterable<? extends StencilClient.TemplateReleaseItem> elements) {
      this.templates.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableRelease ImmutableRelease}.
     * @return An immutable instance of Release
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRelease build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRelease(
          parentCommit,
          name,
          note,
          created,
          locales.build(),
          articles.build(),
          links.build(),
          workflows.build(),
          pages.build(),
          templates.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PARENT_COMMIT) != 0) attributes.add("parentCommit");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_NOTE) != 0) attributes.add("note");
      if ((initBits & INIT_BIT_CREATED) != 0) attributes.add("created");
      return "Cannot build Release, some of required attributes are not set " + attributes;
    }
  }
}
