package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CreateBuilder.CreateRelease}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCreateRelease.builder()}.
 */
@Generated(from = "CreateBuilder.CreateRelease", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCreateRelease implements CreateBuilder.CreateRelease {
  private final @Nullable String id;
  private final String name;
  private final @Nullable String note;

  private ImmutableCreateRelease(
      @Nullable String id,
      String name,
      @Nullable String note) {
    this.id = id;
    this.name = name;
    this.note = note;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public @Nullable String getId() {
    return id;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code note} attribute
   */
  @JsonProperty("note")
  @Override
  public @Nullable String getNote() {
    return note;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CreateBuilder.CreateRelease#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCreateRelease withId(@Nullable String value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableCreateRelease(value, this.name, this.note);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CreateBuilder.CreateRelease#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCreateRelease withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableCreateRelease(this.id, newValue, this.note);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CreateBuilder.CreateRelease#getNote() note} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for note (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCreateRelease withNote(@Nullable String value) {
    if (Objects.equals(this.note, value)) return this;
    return new ImmutableCreateRelease(this.id, this.name, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCreateRelease} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCreateRelease
        && equalTo((ImmutableCreateRelease) another);
  }

  private boolean equalTo(ImmutableCreateRelease another) {
    return Objects.equals(id, another.id)
        && name.equals(another.name)
        && Objects.equals(note, another.note);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code name}, {@code note}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(note);
    return h;
  }

  /**
   * Prints the immutable value {@code CreateRelease} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CreateRelease")
        .omitNullValues()
        .add("id", id)
        .add("name", name)
        .add("note", note)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "CreateBuilder.CreateRelease", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements CreateBuilder.CreateRelease {
    @Nullable String id;
    @Nullable String name;
    @Nullable String note;
    @JsonProperty("id")
    public void setId(@Nullable String id) {
      this.id = id;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("note")
    public void setNote(@Nullable String note) {
      this.note = note;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getNote() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableCreateRelease fromJson(Json json) {
    ImmutableCreateRelease.Builder builder = ImmutableCreateRelease.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.note != null) {
      builder.note(json.note);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link CreateBuilder.CreateRelease} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CreateRelease instance
   */
  public static ImmutableCreateRelease copyOf(CreateBuilder.CreateRelease instance) {
    if (instance instanceof ImmutableCreateRelease) {
      return (ImmutableCreateRelease) instance;
    }
    return ImmutableCreateRelease.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCreateRelease ImmutableCreateRelease}.
   * <pre>
   * ImmutableCreateRelease.builder()
   *    .id(String | null) // nullable {@link CreateBuilder.CreateRelease#getId() id}
   *    .name(String) // required {@link CreateBuilder.CreateRelease#getName() name}
   *    .note(String | null) // nullable {@link CreateBuilder.CreateRelease#getNote() note}
   *    .build();
   * </pre>
   * @return A new ImmutableCreateRelease builder
   */
  public static ImmutableCreateRelease.Builder builder() {
    return new ImmutableCreateRelease.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCreateRelease ImmutableCreateRelease}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CreateBuilder.CreateRelease", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String id;
    private @Nullable String name;
    private @Nullable String note;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateRelease} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CreateBuilder.CreateRelease instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String idValue = instance.getId();
      if (idValue != null) {
        id(idValue);
      }
      name(instance.getName());
      @Nullable String noteValue = instance.getNote();
      if (noteValue != null) {
        note(noteValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CreateBuilder.CreateRelease#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateBuilder.CreateRelease#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateBuilder.CreateRelease#getNote() note} attribute.
     * @param note The value for note (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("note")
    public final Builder note(@Nullable String note) {
      this.note = note;
      return this;
    }

    /**
     * Builds a new {@link ImmutableCreateRelease ImmutableCreateRelease}.
     * @return An immutable instance of CreateRelease
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCreateRelease build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCreateRelease(id, name, note);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build CreateRelease, some of required attributes are not set " + attributes;
    }
  }
}
