package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CreateBuilder.CreatePage}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCreatePage.builder()}.
 */
@Generated(from = "CreateBuilder.CreatePage", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCreatePage implements CreateBuilder.CreatePage {
  private final String articleId;
  private final String locale;
  private final @Nullable String content;

  private ImmutableCreatePage(
      String articleId,
      String locale,
      @Nullable String content) {
    this.articleId = articleId;
    this.locale = locale;
    this.content = content;
  }

  /**
   * @return The value of the {@code articleId} attribute
   */
  @JsonProperty("articleId")
  @Override
  public String getArticleId() {
    return articleId;
  }

  /**
   * @return The value of the {@code locale} attribute
   */
  @JsonProperty("locale")
  @Override
  public String getLocale() {
    return locale;
  }

  /**
   * @return The value of the {@code content} attribute
   */
  @JsonProperty("content")
  @Override
  public @Nullable String getContent() {
    return content;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CreateBuilder.CreatePage#getArticleId() articleId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for articleId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCreatePage withArticleId(String value) {
    String newValue = Objects.requireNonNull(value, "articleId");
    if (this.articleId.equals(newValue)) return this;
    return new ImmutableCreatePage(newValue, this.locale, this.content);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CreateBuilder.CreatePage#getLocale() locale} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for locale
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCreatePage withLocale(String value) {
    String newValue = Objects.requireNonNull(value, "locale");
    if (this.locale.equals(newValue)) return this;
    return new ImmutableCreatePage(this.articleId, newValue, this.content);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CreateBuilder.CreatePage#getContent() content} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for content (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCreatePage withContent(@Nullable String value) {
    if (Objects.equals(this.content, value)) return this;
    return new ImmutableCreatePage(this.articleId, this.locale, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCreatePage} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCreatePage
        && equalTo((ImmutableCreatePage) another);
  }

  private boolean equalTo(ImmutableCreatePage another) {
    return articleId.equals(another.articleId)
        && locale.equals(another.locale)
        && Objects.equals(content, another.content);
  }

  /**
   * Computes a hash code from attributes: {@code articleId}, {@code locale}, {@code content}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + articleId.hashCode();
    h += (h << 5) + locale.hashCode();
    h += (h << 5) + Objects.hashCode(content);
    return h;
  }

  /**
   * Prints the immutable value {@code CreatePage} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CreatePage")
        .omitNullValues()
        .add("articleId", articleId)
        .add("locale", locale)
        .add("content", content)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "CreateBuilder.CreatePage", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements CreateBuilder.CreatePage {
    @Nullable String articleId;
    @Nullable String locale;
    @Nullable String content;
    @JsonProperty("articleId")
    public void setArticleId(String articleId) {
      this.articleId = articleId;
    }
    @JsonProperty("locale")
    public void setLocale(String locale) {
      this.locale = locale;
    }
    @JsonProperty("content")
    public void setContent(@Nullable String content) {
      this.content = content;
    }
    @Override
    public String getArticleId() { throw new UnsupportedOperationException(); }
    @Override
    public String getLocale() { throw new UnsupportedOperationException(); }
    @Override
    public String getContent() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableCreatePage fromJson(Json json) {
    ImmutableCreatePage.Builder builder = ImmutableCreatePage.builder();
    if (json.articleId != null) {
      builder.articleId(json.articleId);
    }
    if (json.locale != null) {
      builder.locale(json.locale);
    }
    if (json.content != null) {
      builder.content(json.content);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link CreateBuilder.CreatePage} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CreatePage instance
   */
  public static ImmutableCreatePage copyOf(CreateBuilder.CreatePage instance) {
    if (instance instanceof ImmutableCreatePage) {
      return (ImmutableCreatePage) instance;
    }
    return ImmutableCreatePage.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCreatePage ImmutableCreatePage}.
   * <pre>
   * ImmutableCreatePage.builder()
   *    .articleId(String) // required {@link CreateBuilder.CreatePage#getArticleId() articleId}
   *    .locale(String) // required {@link CreateBuilder.CreatePage#getLocale() locale}
   *    .content(String | null) // nullable {@link CreateBuilder.CreatePage#getContent() content}
   *    .build();
   * </pre>
   * @return A new ImmutableCreatePage builder
   */
  public static ImmutableCreatePage.Builder builder() {
    return new ImmutableCreatePage.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCreatePage ImmutableCreatePage}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CreateBuilder.CreatePage", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ARTICLE_ID = 0x1L;
    private static final long INIT_BIT_LOCALE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String articleId;
    private @Nullable String locale;
    private @Nullable String content;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreatePage} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CreateBuilder.CreatePage instance) {
      Objects.requireNonNull(instance, "instance");
      articleId(instance.getArticleId());
      locale(instance.getLocale());
      @Nullable String contentValue = instance.getContent();
      if (contentValue != null) {
        content(contentValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CreateBuilder.CreatePage#getArticleId() articleId} attribute.
     * @param articleId The value for articleId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("articleId")
    public final Builder articleId(String articleId) {
      this.articleId = Objects.requireNonNull(articleId, "articleId");
      initBits &= ~INIT_BIT_ARTICLE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateBuilder.CreatePage#getLocale() locale} attribute.
     * @param locale The value for locale 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("locale")
    public final Builder locale(String locale) {
      this.locale = Objects.requireNonNull(locale, "locale");
      initBits &= ~INIT_BIT_LOCALE;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateBuilder.CreatePage#getContent() content} attribute.
     * @param content The value for content (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("content")
    public final Builder content(@Nullable String content) {
      this.content = content;
      return this;
    }

    /**
     * Builds a new {@link ImmutableCreatePage ImmutableCreatePage}.
     * @return An immutable instance of CreatePage
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCreatePage build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCreatePage(articleId, locale, content);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ARTICLE_ID) != 0) attributes.add("articleId");
      if ((initBits & INIT_BIT_LOCALE) != 0) attributes.add("locale");
      return "Cannot build CreatePage, some of required attributes are not set " + attributes;
    }
  }
}
