/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.spi.staticontent.visitors;

import io.thestencil.client.api.ImmutableLinkResource;
import io.thestencil.client.api.ImmutableMarkdown;
import io.thestencil.client.api.ImmutableMarkdowns;
import io.thestencil.client.api.Markdowns;
import io.thestencil.client.api.StencilClient;
import io.thestencil.client.api.StencilComposer;
import io.thestencil.client.spi.staticontent.visitors.MarkdownVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteStateVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SiteStateVisitor.class);
    public static String LINK_TYPE_WORKFLOW = "workflow";
    private final List<StencilClient.Entity<StencilClient.Locale>> locales = new ArrayList<StencilClient.Entity<StencilClient.Locale>>();
    private final Map<String, StencilClient.Entity<StencilClient.Locale>> enablesLocales = new HashMap<String, StencilClient.Entity<StencilClient.Locale>>();
    private StencilComposer.SiteState entity;
    private final boolean dev;

    public SiteStateVisitor(boolean dev) {
        this.dev = dev;
    }

    public Markdowns visit(StencilComposer.SiteState entity) {
        this.entity = entity;
        ImmutableMarkdowns.Builder result = ImmutableMarkdowns.builder().addAllLocales(this.visitLocales(entity).stream().map(e -> ((StencilClient.Locale)e.getBody()).getValue()).collect(Collectors.toList()));
        for (StencilClient.Entity<StencilClient.Article> entity2 : entity.getArticles().values()) {
            result.addAllValues(this.visitArticle(entity2));
        }
        for (StencilClient.Entity<StencilClient.EntityBody> entity3 : entity.getLinks().values()) {
            result.addAllLinks(this.visitLinks(entity3));
        }
        for (StencilClient.Entity<StencilClient.EntityBody> entity4 : entity.getWorkflows().values()) {
            result.addAllLinks(this.visitWorkflows(entity4));
        }
        return result.build();
    }

    private List<Markdowns.LinkResource> visitWorkflows(StencilClient.Entity<StencilClient.Workflow> link) {
        ArrayList<Markdowns.LinkResource> result = new ArrayList<Markdowns.LinkResource>();
        if (!this.dev && Boolean.TRUE.equals(link.getBody().getDevMode())) {
            return result;
        }
        List usedLocales = link.getBody().getLabels().stream().map(label -> label.getLocale()).collect(Collectors.toList());
        if (this.locales.stream().filter(l -> usedLocales.contains(l.getId())).findFirst().isEmpty()) {
            return result;
        }
        for (String string : link.getBody().getArticles()) {
            StencilClient.Entity<StencilClient.Article> article = this.entity.getArticles().get(string);
            for (StencilClient.LocaleLabel label2 : link.getBody().getLabels()) {
                if (!this.enablesLocales.keySet().contains(label2.getLocale())) continue;
                StencilClient.Entity<StencilClient.Locale> locale = this.enablesLocales.get(label2.getLocale());
                ImmutableLinkResource resource = ImmutableLinkResource.builder().id(link.getId() + "-" + locale.getBody().getValue()).addLocale(locale.getBody().getValue()).desc(label2.getLabelValue()).path(this.visitArticlePath(article)).value(link.getBody().getValue()).workflow(true).global(false).type(LINK_TYPE_WORKFLOW).build();
                result.add(resource);
            }
        }
        if (link.getBody().getArticles().isEmpty()) {
            for (StencilClient.Entity entity : this.entity.getArticles().values()) {
                for (StencilClient.LocaleLabel label3 : link.getBody().getLabels()) {
                    if (!this.enablesLocales.keySet().contains(label3.getLocale())) continue;
                    StencilClient.Entity<StencilClient.Locale> locale = this.enablesLocales.get(label3.getLocale());
                    ImmutableLinkResource resource = ImmutableLinkResource.builder().id(link.getId() + "-" + locale.getBody().getValue()).addLocale(locale.getBody().getValue()).desc(label3.getLabelValue()).path(this.visitArticlePath(entity)).value(link.getBody().getValue()).workflow(true).global(true).type(LINK_TYPE_WORKFLOW).build();
                    result.add(resource);
                }
            }
        }
        return result;
    }

    private List<Markdowns.LinkResource> visitLinks(StencilClient.Entity<StencilClient.Link> link) {
        ArrayList<Markdowns.LinkResource> result = new ArrayList<Markdowns.LinkResource>();
        if (!this.dev && Boolean.TRUE.equals(link.getBody().getDevMode())) {
            return result;
        }
        List usedLocales = link.getBody().getLabels().stream().map(label -> label.getLocale()).collect(Collectors.toList());
        if (this.locales.stream().filter(l -> usedLocales.contains(l.getId())).findFirst().isEmpty()) {
            return result;
        }
        for (String string : link.getBody().getArticles()) {
            StencilClient.Entity<StencilClient.Article> article = this.entity.getArticles().get(string);
            for (StencilClient.LocaleLabel label2 : link.getBody().getLabels()) {
                if (!this.enablesLocales.keySet().contains(label2.getLocale())) continue;
                StencilClient.Entity<StencilClient.Locale> locale = this.enablesLocales.get(label2.getLocale());
                ImmutableLinkResource resource = ImmutableLinkResource.builder().id(link.getId() + "-" + locale.getBody().getValue()).addLocale(locale.getBody().getValue()).desc(label2.getLabelValue()).path(this.visitArticlePath(article)).value(link.getBody().getValue()).workflow(false).global(false).type(link.getBody().getContentType()).build();
                result.add(resource);
            }
        }
        if (link.getBody().getArticles().isEmpty()) {
            for (StencilClient.Entity entity : this.entity.getArticles().values()) {
                for (StencilClient.LocaleLabel label3 : link.getBody().getLabels()) {
                    if (!this.enablesLocales.keySet().contains(label3.getLocale())) continue;
                    StencilClient.Entity<StencilClient.Locale> locale = this.enablesLocales.get(label3.getLocale());
                    ImmutableLinkResource resource = ImmutableLinkResource.builder().id(link.getId() + "-" + locale.getBody().getValue()).addLocale(locale.getBody().getValue()).desc(label3.getLabelValue()).path(this.visitArticlePath(entity)).value(link.getBody().getValue()).workflow(false).global(true).type(link.getBody().getContentType()).build();
                    result.add(resource);
                }
            }
        }
        return result;
    }

    private List<Markdowns.Markdown> visitArticle(StencilClient.Entity<StencilClient.Article> article) {
        String path = this.visitArticlePath(article);
        ArrayList<Markdowns.Markdown> result = new ArrayList<Markdowns.Markdown>();
        if (!this.dev && Boolean.TRUE.equals(article.getBody().getDevMode())) {
            return result;
        }
        for (StencilClient.Entity<StencilClient.Page> page : this.entity.getPages().values()) {
            Optional<StencilClient.Entity> locale;
            if (!page.getBody().getArticle().equals(article.getId()) || (locale = this.locales.stream().filter(l -> ((StencilClient.Page)page.getBody()).getLocale().equals(l.getId())).findFirst()).isEmpty() || !this.dev && Boolean.TRUE.equals(page.getBody().getDevMode())) continue;
            String content = page.getBody().getContent();
            MarkdownVisitor.MarkdownAst ast = new MarkdownVisitor().visit(content);
            if (ast.getHeadings().stream().filter(entity -> entity.getLevel() == 1).findFirst().isEmpty()) {
                LOGGER.error("Failed to parse article '" + article.getBody().getName() + "', markdown must have atleast one h1(line starting with one # my super menu)");
            }
            result.add(ImmutableMarkdown.builder().path(path).locale(((StencilClient.Locale)locale.get().getBody()).getValue()).value(content).addAllHeadings(ast.getHeadings()).build());
        }
        return result;
    }

    private String visitArticlePath(StencilClient.Entity<StencilClient.Article> src) {
        String parentId;
        ArrayList<String> visited = new ArrayList<String>();
        StringBuilder path = new StringBuilder();
        StencilClient.Entity<StencilClient.Article> article = src;
        do {
            if (path.length() > 0) {
                path.insert(0, "/");
            }
            path.insert(0, String.format("%03d", article.getBody().getOrder()) + "_" + article.getBody().getName());
            parentId = article.getBody().getParentId();
            if (visited.contains(parentId)) {
                LOGGER.error("Article broken, infinite loop near: '" + parentId + "'!");
                break;
            }
            visited.add(parentId);
        } while ((article = parentId == null ? null : this.entity.getArticles().get(parentId)) != null);
        return path.toString();
    }

    private List<StencilClient.Entity<StencilClient.Locale>> visitLocales(StencilComposer.SiteState site) {
        this.locales.addAll(site.getLocales().values().stream().filter(l -> ((StencilClient.Locale)l.getBody()).getEnabled()).collect(Collectors.toList()));
        this.enablesLocales.putAll(this.locales.stream().collect(Collectors.toMap(e -> e.getId(), e -> e)));
        return this.locales;
    }
}

