/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.spi.serializers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.thestencil.client.api.StencilClient;
import io.thestencil.client.api.StencilConfig;
import java.io.IOException;
import java.time.LocalDateTime;

public class ZoeDeserializer
implements StencilConfig.Deserializer {
    private ObjectMapper objectMapper;

    public ZoeDeserializer(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public <T extends StencilClient.EntityBody> StencilClient.Entity<T> fromString(StencilClient.EntityType entityType, String value) {
        try {
            switch (entityType) {
                case ARTICLE: {
                    return (StencilClient.Entity)this.objectMapper.readValue(value, (TypeReference)new TypeReference<StencilClient.Entity<StencilClient.Article>>(){});
                }
                case LINK: {
                    return (StencilClient.Entity)this.objectMapper.readValue(value, (TypeReference)new TypeReference<StencilClient.Entity<StencilClient.Link>>(){});
                }
                case LOCALE: {
                    return (StencilClient.Entity)this.objectMapper.readValue(value, (TypeReference)new TypeReference<StencilClient.Entity<StencilClient.Locale>>(){});
                }
                case PAGE: {
                    return (StencilClient.Entity)this.objectMapper.readValue(value, (TypeReference)new TypeReference<StencilClient.Entity<StencilClient.Page>>(){});
                }
                case RELEASE: {
                    try {
                        return (StencilClient.Entity)this.objectMapper.readValue(value, (TypeReference)new TypeReference<StencilClient.Entity<StencilClient.Release>>(){});
                    }
                    catch (Exception e) {
                        return this.fromString(value);
                    }
                }
                case WORKFLOW: {
                    return (StencilClient.Entity)this.objectMapper.readValue(value, (TypeReference)new TypeReference<StencilClient.Entity<StencilClient.Workflow>>(){});
                }
                case TEMPLATE: {
                    return (StencilClient.Entity)this.objectMapper.readValue(value, (TypeReference)new TypeReference<StencilClient.Entity<StencilClient.Template>>(){});
                }
            }
            throw new RuntimeException("can't map: " + entityType);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public StencilClient.Entity<?> fromString(String value) {
        try {
            ObjectNode node = (ObjectNode)this.objectMapper.readValue(value, ObjectNode.class);
            StencilClient.EntityType type = StencilClient.EntityType.valueOf(node.get("type").textValue());
            switch (type) {
                case ARTICLE: {
                    return (StencilClient.Entity)this.objectMapper.convertValue((Object)node, (TypeReference)new TypeReference<StencilClient.Entity<StencilClient.Article>>(){});
                }
                case LINK: {
                    return (StencilClient.Entity)this.objectMapper.convertValue((Object)node, (TypeReference)new TypeReference<StencilClient.Entity<StencilClient.Link>>(){});
                }
                case LOCALE: {
                    return (StencilClient.Entity)this.objectMapper.convertValue((Object)node, (TypeReference)new TypeReference<StencilClient.Entity<StencilClient.Locale>>(){});
                }
                case PAGE: {
                    return (StencilClient.Entity)this.objectMapper.convertValue((Object)node, (TypeReference)new TypeReference<StencilClient.Entity<StencilClient.Page>>(){});
                }
                case RELEASE: {
                    boolean created = node.get("body").has("created");
                    if (!created) {
                        ((ObjectNode)node.get("body")).set("created", (JsonNode)TextNode.valueOf((String)LocalDateTime.now().toString()));
                    }
                    return (StencilClient.Entity)this.objectMapper.convertValue((Object)node, (TypeReference)new TypeReference<StencilClient.Entity<StencilClient.Release>>(){});
                }
                case WORKFLOW: {
                    return (StencilClient.Entity)this.objectMapper.convertValue((Object)node, (TypeReference)new TypeReference<StencilClient.Entity<StencilClient.Workflow>>(){});
                }
                case TEMPLATE: {
                    return (StencilClient.Entity)this.objectMapper.convertValue((Object)node, (TypeReference)new TypeReference<StencilClient.Entity<StencilClient.Template>>(){});
                }
            }
            throw new RuntimeException("can't map: " + node);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage() + System.lineSeparator() + value, e);
        }
    }
}

