/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.spi.exceptions;

import io.resys.thena.docdb.api.actions.CommitActions;
import io.resys.thena.docdb.api.models.Message;
import io.thestencil.client.api.StencilClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SaveException
extends RuntimeException {
    private static final long serialVersionUID = 7190168525508589141L;
    private final List<StencilClient.Entity<?>> entity = new ArrayList();
    private final CommitActions.CommitResult commit;

    public SaveException(StencilClient.Entity<?> entity, CommitActions.CommitResult commit) {
        super(SaveException.msg(Arrays.asList(entity), commit));
        this.entity.add(entity);
        this.commit = commit;
    }

    public SaveException(List<StencilClient.Entity<?>> entity, CommitActions.CommitResult commit) {
        super(SaveException.msg(entity, commit));
        this.entity.addAll(entity);
        this.commit = commit;
    }

    public List<StencilClient.Entity<?>> getEntity() {
        return this.entity;
    }

    public CommitActions.CommitResult getCommit() {
        return this.commit;
    }

    private static String msg(List<StencilClient.Entity<?>> entity, CommitActions.CommitResult commit) {
        StringBuilder messages = new StringBuilder();
        for (Message msg : commit.getMessages()) {
            messages.append(System.lineSeparator()).append("  - ").append(msg.getText());
        }
        return "Can't save entity: " + (Object)((Object)entity.get(0).getType()) + ", because of: " + messages;
    }
}

