/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.spi.builders;

import io.smallrye.mutiny.Uni;
import io.thestencil.client.api.ImmutableArticle;
import io.thestencil.client.api.ImmutableEntity;
import io.thestencil.client.api.ImmutableLink;
import io.thestencil.client.api.ImmutableLocale;
import io.thestencil.client.api.ImmutablePage;
import io.thestencil.client.api.ImmutableTemplate;
import io.thestencil.client.api.ImmutableWorkflow;
import io.thestencil.client.api.StencilClient;
import io.thestencil.client.api.StencilComposer;
import io.thestencil.client.api.StencilConfig;
import io.thestencil.client.api.UpdateBuilder;
import io.thestencil.client.spi.exceptions.ConstraintException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class UpdateBuilderImpl
implements UpdateBuilder {
    private final StencilClient client;

    @Override
    public Uni<StencilClient.Entity<StencilClient.Article>> article(UpdateBuilder.ArticleMutator changes) {
        Uni<StencilComposer.SiteState> query = this.client.getStore().query().head();
        return query.onItem().transformToUni(state -> this.changeArticle((StencilComposer.SiteState)state, changes));
    }

    private Uni<StencilClient.Entity<StencilClient.Article>> changeArticle(StencilComposer.SiteState site, UpdateBuilder.ArticleMutator changes) {
        ArrayList<String> articles;
        StencilClient.Entity<StencilClient.Article> start = site.getArticles().get(changes.getArticleId());
        ArrayList<ImmutableEntity<StencilClient.EntityBody>> additionalChanges = new ArrayList<ImmutableEntity<StencilClient.EntityBody>>();
        if (changes.getArticleId().equals(changes.getParentId())) {
            throw new ConstraintException(start, "Article: '" + changes.getName() + "' parent can't be itself!");
        }
        Optional<StencilClient.Entity> duplicate = site.getArticles().values().stream().filter(p -> !p.getId().equals(changes.getArticleId())).filter(p -> ((StencilClient.Article)p.getBody()).getName().equals(changes.getName())).findFirst();
        if (duplicate.isPresent()) {
            throw new ConstraintException(start, "Article: '" + changes.getName() + "' already exists!");
        }
        if (changes.getLinks() != null) {
            for (StencilClient.Entity<StencilClient.EntityBody> entity : site.getLinks().values()) {
                boolean isArticleInLink = ((StencilClient.Link)entity.getBody()).getArticles().contains(changes.getArticleId());
                boolean isLinkInChanges = changes.getLinks().contains(entity.getId());
                if (isArticleInLink && isLinkInChanges) continue;
                if (isLinkInChanges && !isArticleInLink) {
                    ImmutableEntity<StencilClient.EntityBody> newLink = ImmutableEntity.builder().from(entity).body(ImmutableLink.builder().from((StencilClient.Link)entity.getBody()).addArticles(changes.getArticleId()).build()).build();
                    additionalChanges.add(newLink);
                }
                if (!isArticleInLink || isLinkInChanges) continue;
                articles = new ArrayList<String>(((StencilClient.Link)entity.getBody()).getArticles());
                articles.remove(changes.getArticleId());
                ImmutableEntity<StencilClient.EntityBody> newLink = ImmutableEntity.builder().from(entity).body(ImmutableLink.builder().from((StencilClient.Link)entity.getBody()).articles(articles).build()).build();
                additionalChanges.add(newLink);
            }
        }
        if (changes.getWorkflows() != null) {
            for (StencilClient.Entity<StencilClient.EntityBody> entity : site.getWorkflows().values()) {
                boolean isArticleInWorkflow = ((StencilClient.Workflow)entity.getBody()).getArticles().contains(changes.getArticleId());
                boolean isWorkflowInChanges = changes.getWorkflows().contains(entity.getId());
                if (isArticleInWorkflow && isWorkflowInChanges) continue;
                if (isWorkflowInChanges && !isArticleInWorkflow) {
                    ImmutableEntity<StencilClient.EntityBody> newWorkflow = ImmutableEntity.builder().from(entity).body(ImmutableWorkflow.builder().from((StencilClient.Workflow)entity.getBody()).addArticles(changes.getArticleId()).build()).build();
                    additionalChanges.add(newWorkflow);
                }
                if (!isArticleInWorkflow || isWorkflowInChanges) continue;
                articles = new ArrayList<String>(((StencilClient.Workflow)entity.getBody()).getArticles());
                articles.remove(changes.getArticleId());
                ImmutableEntity<StencilClient.EntityBody> newWorkflow = ImmutableEntity.builder().from(entity).body(ImmutableWorkflow.builder().from((StencilClient.Workflow)entity.getBody()).articles(articles).build()).build();
                additionalChanges.add(newWorkflow);
            }
        }
        ImmutableEntity<StencilClient.Article> result = ImmutableEntity.builder().from(start).body(ImmutableArticle.builder().from(start.getBody()).devMode(changes.getDevMode()).name(changes.getName()).order(changes.getOrder()).parentId(changes.getParentId()).build()).build();
        ArrayList arrayList = new ArrayList();
        arrayList.add(result);
        arrayList.addAll(additionalChanges);
        return this.client.getStore().saveAll(arrayList).onItem().transform(e -> result);
    }

    @Override
    public Uni<StencilClient.Entity<StencilClient.Locale>> locale(UpdateBuilder.LocaleMutator changes) {
        Uni<StencilComposer.SiteState> query = this.client.getStore().query().head();
        return query.onItem().transformToUni(state -> this.client.getStore().save(this.changeLocale((StencilComposer.SiteState)state, changes)));
    }

    private StencilClient.Entity<StencilClient.Locale> changeLocale(StencilComposer.SiteState site, UpdateBuilder.LocaleMutator changes) {
        StencilClient.Entity<StencilClient.Locale> start = site.getLocales().get(changes.getLocaleId());
        Optional<StencilClient.Entity> duplicate = site.getLocales().values().stream().filter(p -> !p.getId().equals(changes.getLocaleId())).filter(p -> ((StencilClient.Locale)p.getBody()).getValue().equals(changes.getValue())).findFirst();
        if (duplicate.isPresent()) {
            throw new ConstraintException(start, "Locale: '" + changes.getValue() + "' already exists!");
        }
        return ImmutableEntity.builder().from(start).body(ImmutableLocale.builder().from(start.getBody()).value(changes.getValue()).enabled(changes.getEnabled()).build()).build();
    }

    @Override
    public Uni<StencilClient.Entity<StencilClient.Template>> template(UpdateBuilder.TemplateMutator changes) {
        Uni<StencilComposer.SiteState> query = this.client.getStore().query().head();
        return query.onItem().transformToUni(state -> this.client.getStore().save(this.changeTemplate((StencilComposer.SiteState)state, changes)));
    }

    private StencilClient.Entity<StencilClient.Template> changeTemplate(StencilComposer.SiteState site, UpdateBuilder.TemplateMutator changes) {
        StencilClient.Entity<StencilClient.Template> start = site.getTemplates().get(changes.getTemplateId());
        Optional<StencilClient.Entity> duplicate = site.getTemplates().values().stream().filter(p -> !p.getId().equals(changes.getTemplateId())).filter(p -> ((StencilClient.Template)p.getBody()).getName().equals(changes.getName())).findFirst();
        if (duplicate.isPresent()) {
            throw new ConstraintException(start, "Template: '" + changes.getName() + "' already exists!");
        }
        return ImmutableEntity.builder().from(start).body(ImmutableTemplate.builder().from(start.getBody()).name(changes.getName()).content(changes.getContent()).type(changes.getType()).description(changes.getDescription()).build()).build();
    }

    @Override
    public Uni<StencilClient.Entity<StencilClient.Page>> page(UpdateBuilder.PageMutator changes) {
        Uni query = this.client.getStore().get(changes.getPageId(), StencilClient.EntityType.PAGE);
        return query.onItem().transformToUni(state -> this.client.getStore().save(this.changePage((StencilConfig.EntityState<StencilClient.Page>)state, changes)));
    }

    @Override
    public Uni<List<StencilClient.Entity<StencilClient.Page>>> pages(List<UpdateBuilder.PageMutator> mutators) {
        ArrayList<String> ids = new ArrayList<String>();
        HashMap<String, UpdateBuilder.PageMutator> changes = new HashMap<String, UpdateBuilder.PageMutator>();
        for (UpdateBuilder.PageMutator m : mutators) {
            changes.put(m.getPageId(), m);
            ids.add(m.getPageId());
        }
        Uni query = this.client.getStore().query().head(ids, StencilClient.EntityType.PAGE);
        return query.onItem().transformToUni(state -> {
            List toBeSaved = state.stream().map(start -> {
                UpdateBuilder.PageMutator mutator = (UpdateBuilder.PageMutator)changes.get(start.getId());
                ImmutableEntity<ImmutablePage> end = ImmutableEntity.builder().from(start).body(ImmutablePage.builder().from((StencilClient.Page)start.getBody()).content(mutator.getContent()).locale(mutator.getLocale()).devMode(mutator.getDevMode()).build()).build();
                return end;
            }).collect(Collectors.toList());
            return this.client.getStore().saveAll(new ArrayList(toBeSaved)).onItem().transform(e -> new ArrayList(toBeSaved));
        });
    }

    private StencilClient.Entity<StencilClient.Page> changePage(StencilConfig.EntityState<StencilClient.Page> state, UpdateBuilder.PageMutator changes) {
        StencilClient.Entity<StencilClient.Page> start = state.getEntity();
        return ImmutableEntity.builder().from(start).body(ImmutablePage.builder().from(start.getBody()).content(changes.getContent()).devMode(changes.getDevMode()).locale(changes.getLocale()).build()).build();
    }

    @Override
    public Uni<StencilClient.Entity<StencilClient.Link>> link(UpdateBuilder.LinkMutator changes) {
        Uni<StencilComposer.SiteState> query = this.client.getStore().query().head();
        return query.onItem().transformToUni(state -> this.client.getStore().save(this.changeLink((StencilComposer.SiteState)state, changes)));
    }

    private StencilClient.Entity<StencilClient.Link> changeLink(StencilComposer.SiteState site, UpdateBuilder.LinkMutator changes) {
        StencilClient.Entity<StencilClient.Link> start = site.getLinks().get(changes.getLinkId());
        if (changes.getLabels() != null) {
            for (StencilClient.LocaleLabel label : changes.getLabels()) {
                String localeId = label.getLocale();
                if (site.getLocales().containsKey(localeId)) continue;
                throw new ConstraintException(start, "Locale with id: '" + localeId + "' does not exist in: '" + String.join((CharSequence)",", site.getLocales().keySet()) + "'!");
            }
        }
        return ImmutableEntity.builder().from(start).body(ImmutableLink.builder().from(start.getBody()).value(changes.getValue()).devMode(changes.getDevMode()).labels(changes.getLabels() == null ? start.getBody().getLabels() : changes.getLabels()).contentType(changes.getType()).articles(changes.getArticles() == null ? start.getBody().getArticles() : changes.getArticles()).build()).build();
    }

    @Override
    public Uni<StencilClient.Entity<StencilClient.Workflow>> workflow(UpdateBuilder.WorkflowMutator changes) {
        Uni<StencilComposer.SiteState> query = this.client.getStore().query().head();
        return query.onItem().transformToUni(state -> this.client.getStore().save(this.changeWorkflow((StencilComposer.SiteState)state, changes)));
    }

    private StencilClient.Entity<StencilClient.Workflow> changeWorkflow(StencilComposer.SiteState site, UpdateBuilder.WorkflowMutator changes) {
        StencilClient.Entity<StencilClient.Workflow> start = site.getWorkflows().get(changes.getWorkflowId());
        if (changes.getLabels() != null) {
            for (StencilClient.LocaleLabel label : changes.getLabels()) {
                String localeId = label.getLocale();
                if (site.getLocales().containsKey(localeId)) continue;
                throw new ConstraintException(start, "Locale with id: '" + localeId + "' does not exist in: '" + String.join((CharSequence)",", site.getLocales().keySet()) + "'!");
            }
        }
        return ImmutableEntity.builder().from(start).body(ImmutableWorkflow.builder().from(start.getBody()).devMode(changes.getDevMode()).value(changes.getValue()).labels(changes.getLabels() == null ? start.getBody().getLabels() : changes.getLabels()).articles(changes.getArticles() == null ? start.getBody().getArticles() : changes.getArticles()).build()).build();
    }

    public UpdateBuilderImpl(StencilClient client) {
        this.client = client;
    }
}

