/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.spi.builders;

import io.resys.thena.docdb.api.actions.ObjectsActions;
import io.resys.thena.docdb.api.models.Objects;
import io.smallrye.mutiny.Uni;
import io.thestencil.client.api.ImmutableSiteState;
import io.thestencil.client.api.StencilClient;
import io.thestencil.client.api.StencilComposer;
import io.thestencil.client.api.StencilConfig;
import io.thestencil.client.api.StencilStore;
import io.thestencil.client.spi.PersistenceCommands;
import io.thestencil.client.spi.exceptions.QueryException;
import io.thestencil.client.spi.exceptions.RefException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class QueryBuilderImpl
extends PersistenceCommands
implements StencilStore.QueryBuilder {
    public QueryBuilderImpl(StencilConfig config) {
        super(config);
    }

    @Override
    public Uni<StencilComposer.SiteState> head() {
        String siteName = this.config.getRepoName() + ":" + this.config.getHeadName();
        return this.config.getClient().repo().query().id(this.config.getRepoName()).get().onItem().transformToUni(repo -> {
            if (repo == null) {
                return Uni.createFrom().item((Object)ImmutableSiteState.builder().name(siteName).contentType(StencilComposer.SiteContentType.NOT_CREATED).build());
            }
            return this.config.getClient().objects().refState().repo(this.config.getRepoName()).ref(this.config.getHeadName()).blobs(true).build().onItem().transform(state -> {
                if (state.getStatus() == ObjectsActions.ObjectsStatus.ERROR) {
                    throw new RefException(siteName, (ObjectsActions.ObjectsResult<ObjectsActions.RefObjects>)state);
                }
                if (state.getObjects() == null) {
                    return ImmutableSiteState.builder().name(siteName).contentType(StencilComposer.SiteContentType.EMPTY).build();
                }
                Objects.Commit commit = ((ObjectsActions.RefObjects)state.getObjects()).getCommit();
                Objects.Tree tree = ((ObjectsActions.RefObjects)state.getObjects()).getTree();
                Map blobs = ((ObjectsActions.RefObjects)state.getObjects()).getBlobs();
                ImmutableSiteState.Builder builder = QueryBuilderImpl.mapTree(tree, blobs, this.config);
                return builder.commit(commit.getId()).name(siteName).contentType(StencilComposer.SiteContentType.OK).build();
            });
        });
    }

    public static ImmutableSiteState.Builder mapTree(Objects.Tree tree, Map<String, Objects.Blob> blobs, StencilConfig config) {
        ImmutableSiteState.Builder builder = ImmutableSiteState.builder();
        block9: for (Objects.TreeValue treeValue : tree.getValues().values()) {
            Objects.Blob blob = blobs.get(treeValue.getBlob());
            StencilClient.Entity<StencilClient.Article> entity = config.getDeserializer().fromString(blob.getValue());
            String id = entity.getId();
            switch (entity.getType()) {
                case ARTICLE: {
                    builder.putArticles(id, entity);
                    continue block9;
                }
                case LINK: {
                    builder.putLinks(id, entity);
                    continue block9;
                }
                case LOCALE: {
                    builder.putLocales(id, entity);
                    continue block9;
                }
                case PAGE: {
                    builder.putPages(id, entity);
                    continue block9;
                }
                case RELEASE: {
                    builder.putReleases(id, entity);
                    continue block9;
                }
                case WORKFLOW: {
                    builder.putWorkflows(id, entity);
                    continue block9;
                }
                case TEMPLATE: {
                    builder.putTemplates(id, entity);
                    continue block9;
                }
            }
            throw new RuntimeException("Don't know how to convert entity: " + entity.toString() + "!");
        }
        return builder;
    }

    @Override
    public Uni<StencilComposer.SiteState> release(String releaseId) {
        Uni query = this.get(releaseId, StencilClient.EntityType.RELEASE);
        return query.onItem().transformToUni(this::getCommitState);
    }

    private Uni<StencilComposer.SiteState> getCommitState(StencilConfig.EntityState<StencilClient.Release> release) {
        return this.config.getClient().objects().commitState().repo(this.config.getRepoName()).anyId(release.getEntity().getBody().getParentCommit()).blobs(true).build().onItem().transform(state -> {
            if (state.getStatus() == ObjectsActions.ObjectsStatus.ERROR) {
                throw new QueryException("Can't find release commit: '" + ((StencilClient.Release)release.getEntity().getBody()).getParentCommit() + "'!", StencilClient.EntityType.RELEASE, (ObjectsActions.ObjectsResult<?>)state);
            }
            Objects.Tree tree = ((ObjectsActions.CommitObjects)state.getObjects()).getTree();
            Map blobs = ((ObjectsActions.CommitObjects)state.getObjects()).getBlobs();
            ImmutableSiteState.Builder builder = QueryBuilderImpl.mapTree(tree, blobs, this.config).putReleases(release.getEntity().getId(), release.getEntity());
            return builder.name(this.config.getRepoName() + ":" + this.config.getHeadName() + ":" + ((StencilClient.Release)release.getEntity().getBody()).getName()).contentType(StencilComposer.SiteContentType.RELEASE).build();
        });
    }

    @Override
    public <T extends StencilClient.EntityBody> Uni<List<StencilClient.Entity<T>>> head(List<String> ids, StencilClient.EntityType type) {
        return this.config.getClient().objects().blobState().repo(this.config.getRepoName()).anyId(this.config.getHeadName()).blobNames(ids).list().onItem().transform(state -> {
            if (state.getStatus() != ObjectsActions.ObjectsStatus.OK) {
                throw new QueryException(String.join((CharSequence)",", ids), type, (ObjectsActions.ObjectsResult<?>)state);
            }
            return ((ObjectsActions.BlobObjects)state.getObjects()).getBlob().stream().map(blob -> this.config.getDeserializer().fromString(type, blob.getValue())).collect(Collectors.toList());
        });
    }
}

