/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.spi.builders;

import io.resys.thena.docdb.spi.commits.Sha2;
import io.thestencil.client.api.ImmutableArticleReleaseItem;
import io.thestencil.client.api.ImmutableLinkReleaseItem;
import io.thestencil.client.api.ImmutableLocaleReleaseItem;
import io.thestencil.client.api.ImmutablePageReleaseItem;
import io.thestencil.client.api.ImmutableRelease;
import io.thestencil.client.api.ImmutableWorkflowReleaseItem;
import io.thestencil.client.api.StencilClient;
import io.thestencil.client.api.StencilComposer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class CreateReleaseVisitor {
    private final StencilComposer.SiteState state;
    private final Set<String> enabledLocales = new HashSet<String>();
    private final Set<String> enabledArticles = new HashSet<String>();

    public ImmutableRelease.Builder visit(ImmutableRelease.Builder releaseBuilder) {
        return releaseBuilder.addAllLocales(this.visitLocale()).addAllPages(this.visitPage()).addAllArticles(this.visitArticle()).addAllWorkflows(this.visitWorkflow()).addAllLinks(this.visitLink());
    }

    private List<StencilClient.LocaleReleaseItem> visitLocale() {
        ArrayList<StencilClient.LocaleReleaseItem> result = new ArrayList<StencilClient.LocaleReleaseItem>();
        for (StencilClient.Entity<StencilClient.Locale> locale : this.state.getLocales().values()) {
            if (!locale.getBody().getEnabled().booleanValue()) continue;
            this.enabledLocales.add(locale.getId());
            result.add(ImmutableLocaleReleaseItem.builder().id(locale.getId()).value(locale.getBody().getValue()).hash(Sha2.blobId((String)locale.getBody().getValue().toString())).build());
        }
        return result;
    }

    private List<StencilClient.PageReleaseItem> visitPage() {
        ArrayList<StencilClient.PageReleaseItem> result = new ArrayList<StencilClient.PageReleaseItem>();
        for (StencilClient.Entity<StencilClient.Page> page : this.state.getPages().values()) {
            if (!this.enabledLocales.contains(page.getBody().getLocale())) continue;
            this.enabledArticles.add(page.getBody().getArticle());
            result.add(ImmutablePageReleaseItem.builder().id(page.getId()).hash(Sha2.blobId((String)page.getBody().toString())).locale(page.getBody().getLocale()).h1(this.visitH1(page)).build());
        }
        return result;
    }

    private String visitH1(StencilClient.Entity<StencilClient.Page> page) {
        int h1Start = page.getBody().getContent().indexOf("# ");
        if (h1Start < 0) {
            return "";
        }
        int lineEnd = page.getBody().getContent().indexOf("\r\n", h1Start);
        if (lineEnd < 0) {
            lineEnd = page.getBody().getContent().indexOf("\n", h1Start);
        }
        if (lineEnd < 0) {
            return page.getBody().getContent().substring(2).trim();
        }
        return page.getBody().getContent().substring(2, lineEnd).trim();
    }

    private List<StencilClient.ArticleReleaseItem> visitArticle() {
        ArrayList<StencilClient.ArticleReleaseItem> result = new ArrayList<StencilClient.ArticleReleaseItem>();
        for (StencilClient.Entity<StencilClient.Article> article : this.state.getArticles().values()) {
            if (!this.enabledArticles.contains(article.getId())) continue;
            ImmutableArticleReleaseItem item = ImmutableArticleReleaseItem.builder().id(article.getId()).hash("").parentId(article.getBody().getParentId()).name(article.getBody().getName()).build();
            result.add(ImmutableArticleReleaseItem.builder().from(item).hash(Sha2.blobId((String)item.toString())).build());
        }
        return result;
    }

    private List<StencilClient.LinkReleaseItem> visitLink() {
        ArrayList<StencilClient.LinkReleaseItem> result = new ArrayList<StencilClient.LinkReleaseItem>();
        for (StencilClient.Entity<StencilClient.Link> link : this.state.getLinks().values()) {
            List labels = link.getBody().getLabels().stream().filter(label -> this.enabledLocales.contains(label.getLocale())).collect(Collectors.toList());
            List<String> articles = link.getBody().getArticles().stream().filter(article -> this.enabledArticles.contains(article)).collect(Collectors.toList());
            if (articles.isEmpty() || labels.isEmpty()) continue;
            ImmutableLinkReleaseItem item = ImmutableLinkReleaseItem.builder().id(link.getId()).hash("").contentType(link.getBody().getContentType()).value(link.getBody().getValue()).addAllLabels(labels).addAllArticles(articles).build();
            result.add(ImmutableLinkReleaseItem.builder().from(item).hash(Sha2.blobId((String)item.toString())).build());
        }
        return result;
    }

    private List<StencilClient.WorkflowReleaseItem> visitWorkflow() {
        ArrayList<StencilClient.WorkflowReleaseItem> result = new ArrayList<StencilClient.WorkflowReleaseItem>();
        for (StencilClient.Entity<StencilClient.Workflow> workflow : this.state.getWorkflows().values()) {
            List labels = workflow.getBody().getLabels().stream().filter(label -> this.enabledLocales.contains(label.getLocale())).collect(Collectors.toList());
            List<String> articles = workflow.getBody().getArticles().stream().filter(article -> this.enabledArticles.contains(article)).collect(Collectors.toList());
            if (articles.isEmpty() || labels.isEmpty()) continue;
            ImmutableWorkflowReleaseItem item = ImmutableWorkflowReleaseItem.builder().id(workflow.getId()).hash("").value(workflow.getBody().getValue()).addAllLabels(labels).addAllArticles(articles).build();
            result.add(ImmutableWorkflowReleaseItem.builder().from(item).hash(Sha2.blobId((String)item.toString())).build());
        }
        return result;
    }

    public CreateReleaseVisitor(StencilComposer.SiteState state) {
        this.state = state;
    }
}

