/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.spi;

import io.resys.thena.docdb.api.DocDB;
import io.resys.thena.docdb.api.actions.RepoActions;
import io.smallrye.mutiny.Uni;
import io.thestencil.client.api.ImmutableStencilConfig;
import io.thestencil.client.api.StencilClient;
import io.thestencil.client.api.StencilConfig;
import io.thestencil.client.api.StencilStore;
import io.thestencil.client.spi.PersistenceCommands;
import io.thestencil.client.spi.StencilAssert;
import io.thestencil.client.spi.builders.QueryBuilderImpl;
import io.thestencil.client.spi.exceptions.RepoException;
import java.util.function.Consumer;

public class StencilStoreImpl
extends PersistenceCommands
implements StencilStore {
    public StencilStoreImpl(StencilConfig config) {
        super(config);
    }

    @Override
    public StencilConfig getConfig() {
        return this.config;
    }

    @Override
    public StencilStore.QueryBuilder query() {
        return new QueryBuilderImpl(this.config);
    }

    @Override
    public StencilStore.StoreRepoBuilder repo() {
        return new StencilStore.StoreRepoBuilder(){
            private String repoName;
            private String headName;
            {
                this.repoName = StencilStoreImpl.this.config.getRepoName();
                this.headName = StencilStoreImpl.this.config.getHeadName();
            }

            @Override
            public StencilStore.StoreRepoBuilder repoName(String repoName) {
                this.repoName = repoName;
                return this;
            }

            @Override
            public StencilStore.StoreRepoBuilder headName(String headName) {
                this.headName = headName;
                return this;
            }

            @Override
            public Uni<StencilStore> create() {
                StencilAssert.notNull(this.repoName, () -> "repoName must be defined!");
                DocDB client = StencilStoreImpl.this.config.getClient();
                Uni newRepo = client.repo().create().name(this.repoName).build();
                return newRepo.onItem().transform(repoResult -> {
                    if (repoResult.getStatus() != RepoActions.RepoStatus.OK) {
                        throw new RepoException("Can't create repository with name: '" + this.repoName + "'!", (RepoActions.RepoResult)repoResult);
                    }
                    return this.build();
                });
            }

            @Override
            public StencilStore build() {
                StencilAssert.notNull(this.repoName, () -> "repoName must be defined!");
                return StencilStoreImpl.this.createWithNewConfig(ImmutableStencilConfig.builder().from(StencilStoreImpl.this.config).repoName(this.repoName).headName(this.headName == null ? StencilStoreImpl.this.config.getHeadName() : this.headName).build());
            }

            @Override
            public Uni<Boolean> createIfNot() {
                DocDB client = StencilStoreImpl.this.config.getClient();
                return client.repo().query().id(StencilStoreImpl.this.config.getRepoName()).get().onItem().transformToUni(repo -> {
                    if (repo == null) {
                        return client.repo().create().name(StencilStoreImpl.this.config.getRepoName()).build().onItem().transform(newRepo -> true);
                    }
                    return Uni.createFrom().item((Object)false);
                });
            }
        };
    }

    @Override
    public String gid(StencilClient.EntityType type) {
        return this.config.getGidProvider().getNextId(type);
    }

    @Override
    public String getRepoName() {
        return this.config.getRepoName();
    }

    @Override
    public String getHeadName() {
        return this.config.getHeadName();
    }

    protected StencilStoreImpl createWithNewConfig(StencilConfig config) {
        return new StencilStoreImpl(config);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ImmutableStencilConfig.Builder config = ImmutableStencilConfig.builder();

        public Builder config(Consumer<ImmutableStencilConfig.Builder> config) {
            config.accept(this.config);
            return this;
        }

        public StencilStoreImpl build() {
            return new StencilStoreImpl(this.config.build());
        }
    }
}

