/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.spi;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.smallrye.mutiny.Uni;
import io.thestencil.client.api.ImmutableImageResource;
import io.thestencil.client.api.ImmutableMarkdown;
import io.thestencil.client.api.ImmutableMarkdowns;
import io.thestencil.client.api.ImmutableStencilConfig;
import io.thestencil.client.api.Markdowns;
import io.thestencil.client.api.MigrationBuilder;
import io.thestencil.client.api.StencilClient;
import io.thestencil.client.api.StencilComposer;
import io.thestencil.client.api.StencilStore;
import io.thestencil.client.spi.StencilAssert;
import io.thestencil.client.spi.StencilStoreImpl;
import io.thestencil.client.spi.StencilStoreInMemory;
import io.thestencil.client.spi.beans.SitesBean;
import io.thestencil.client.spi.staticontent.support.ParserAssert;
import io.thestencil.client.spi.staticontent.visitors.CSVLinksVisitor;
import io.thestencil.client.spi.staticontent.visitors.ImmutableLinkData;
import io.thestencil.client.spi.staticontent.visitors.ImmutableTopicData;
import io.thestencil.client.spi.staticontent.visitors.MarkdownException;
import io.thestencil.client.spi.staticontent.visitors.MarkdownVisitor;
import io.thestencil.client.spi.staticontent.visitors.SiteStateVisitor;
import io.thestencil.client.spi.staticontent.visitors.SiteVisitor;
import io.thestencil.client.spi.staticontent.visitors.SiteVisitorDefault;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class StencilClientImpl
implements StencilClient {
    private final StencilStore store;

    @Override
    public StencilClient.MarkdownBuilder markdown() {
        return new StencilClient.MarkdownBuilder(){
            private Markdowns jsonOfSiteState;
            private ImmutableMarkdowns.Builder fromFiles;

            @Override
            public StencilClient.MarkdownBuilder md(String path, byte[] value) {
                if (this.fromFiles == null) {
                    this.fromFiles = ImmutableMarkdowns.builder();
                }
                if (!path.toLowerCase().endsWith(".md")) {
                    String cleanName = path.toLowerCase();
                    if (cleanName.equals("links.csv")) {
                        this.fromFiles.addAllLinks(new CSVLinksVisitor(path).visit(value));
                    } else if (cleanName.startsWith("images/")) {
                        this.fromFiles.addImages((Markdowns.ImageResource)ImmutableImageResource.builder().path(path).value(value).build());
                    }
                    return this;
                }
                String[] fragments = path.split("\\/");
                if (fragments.length != 2 && fragments.length != 3) {
                    throw new MarkdownException("Markdown: '" + path + "' must have [2..3] (level2/level2/en.md) levels but was: '" + fragments.length + "'!");
                }
                String fileName = fragments[fragments.length - 1];
                if (fileName.length() != 5) {
                    throw new MarkdownException("Markdown: '" + path + "' must be name as <path>/<locale>.md but was: '" + path + "'!");
                }
                String locale = fileName.substring(0, 2);
                try {
                    String content = new String(value, StandardCharsets.UTF_8);
                    Object cleanPath = fragments.length == 2 ? fragments[0] : fragments[0] + "/" + fragments[1];
                    MarkdownVisitor.MarkdownAst ast = new MarkdownVisitor().visit(content);
                    if (ast.getHeadings().stream().filter(entity -> entity.getLevel() == 1).findFirst().isEmpty()) {
                        throw new MarkdownException("markdown must have atleast one h1(line starting with one # my super menu)");
                    }
                    this.fromFiles.addValues((Markdowns.Markdown)ImmutableMarkdown.builder().path((String)cleanPath).locale(locale).value(content).addAllHeadings(ast.getHeadings()).addAllImages(ast.getImages()).build());
                    return this;
                }
                catch (Exception e) {
                    throw new MarkdownException("Failed to parse markdown: '" + path + "', error: " + e.getMessage(), e);
                }
            }

            @Override
            public StencilClient.MarkdownBuilder json(String jsonOfSiteState, boolean dev) {
                try {
                    StencilComposer.SiteState site = (StencilComposer.SiteState)StencilClientImpl.this.store.getConfig().getObjectMapper().readValue(jsonOfSiteState, StencilComposer.SiteState.class);
                    this.jsonOfSiteState = new SiteStateVisitor(dev).visit(site);
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                return this;
            }

            @Override
            public StencilClient.MarkdownBuilder json(StencilComposer.SiteState jsonOfSiteState, boolean dev) {
                this.jsonOfSiteState = new SiteStateVisitor(dev).visit(jsonOfSiteState);
                return this;
            }

            @Override
            public Markdowns build() {
                ParserAssert.isTrue(this.jsonOfSiteState != null || this.fromFiles != null, () -> "json or md files must be provided!");
                ParserAssert.isTrue(this.jsonOfSiteState == null || this.fromFiles == null, () -> "json or md files both can't be provided!");
                if (this.fromFiles != null) {
                    return this.fromFiles.build();
                }
                return this.jsonOfSiteState;
            }
        };
    }

    @Override
    public StencilClient.SitesBuilder sites() {
        return new StencilClient.SitesBuilder(){
            private final SiteVisitor visitor = new SiteVisitorDefault(obj -> StencilClientImpl.writeAsString(obj, StencilClientImpl.this.store.getConfig().getObjectMapper()));
            private String imageUrl;
            private Long created;
            private Markdowns markdowns;

            @Override
            public StencilClient.SitesBuilder source(Markdowns markdowns) {
                this.markdowns = markdowns;
                return this;
            }

            @Override
            public StencilClient.SitesBuilder imagePath(String imagePath) {
                this.imageUrl = imagePath;
                return this;
            }

            @Override
            public StencilClient.SitesBuilder created(long created) {
                this.created = created;
                return this;
            }

            private StencilClient.SitesBuilder topic(Function<ImmutableTopicData.Builder, SiteVisitor.TopicData> newTopic) {
                this.visitor.visitTopicData(newTopic.apply(ImmutableTopicData.builder()));
                return this;
            }

            private StencilClient.SitesBuilder link(Function<ImmutableLinkData.Builder, SiteVisitor.LinkData> newLink) {
                this.visitor.visitLinkData(newLink.apply(ImmutableLinkData.builder()));
                return this;
            }

            @Override
            public MigrationBuilder.Sites build() {
                ParserAssert.notEmpty(this.imageUrl, () -> "imageUrl can't be empty!");
                ParserAssert.notNull(this.created, () -> "created can't be empty!");
                ParserAssert.notNull(this.markdowns, () -> "markdowns can't be empty!");
                this.markdowns.getValues().forEach(value -> this.topic(builder -> builder.path(value.getPath()).locale(value.getLocale()).headings(value.getHeadings()).images(value.getImages()).value(value.getValue()).build()));
                this.markdowns.getLinks().forEach(link -> link.getLocale().forEach(locale -> this.link(builder -> builder.id(link.getId()).path(link.getPath()).locale((String)locale).type(link.getType()).name(link.getDesc()).global(link.getGlobal()).value(link.getValue()).workflow(link.getType().equals(SiteStateVisitor.LINK_TYPE_WORKFLOW)).build())));
                SiteVisitor.SiteVisitorOutput visited = this.visitor.visit(this.imageUrl);
                Map<String, MigrationBuilder.LocalizedSite> content = visited.getSites().stream().collect(Collectors.toMap(e -> e.getLocale(), e -> e));
                return SitesBean.builder().created(this.created).sites(content).build();
            }
        };
    }

    @Override
    public StencilClient.ClientRepoBuilder repo() {
        return new StencilClient.ClientRepoBuilder(){
            private String repoName;
            private String headName;

            @Override
            public StencilClient.ClientRepoBuilder repoName(String repoName) {
                this.repoName = repoName;
                return this;
            }

            @Override
            public StencilClient.ClientRepoBuilder headName(String headName) {
                this.headName = headName;
                return this;
            }

            @Override
            public Uni<StencilClient> create() {
                StencilAssert.notNull(this.repoName, () -> "repoName must be defined!");
                return StencilClientImpl.this.store.repo().repoName(this.repoName).headName(this.headName).create().onItem().transform(newConfig -> new StencilClientImpl((StencilStore)newConfig));
            }

            @Override
            public StencilClient build() {
                StencilAssert.notNull(this.repoName, () -> "repoName must be defined!");
                StencilStore newConfig = StencilClientImpl.this.store.repo().repoName(this.repoName).headName(this.headName).build();
                return new StencilClientImpl(newConfig);
            }
        };
    }

    @Override
    public StencilStore getStore() {
        return this.store;
    }

    private static String writeAsString(Object anyObject, ObjectMapper objectMapper) {
        try {
            return objectMapper.writeValueAsString(anyObject);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public StencilClientImpl(StencilStore store) {
        this.store = store;
    }

    public static class Builder {
        private ImmutableStencilConfig.Builder config = ImmutableStencilConfig.builder();
        private boolean inmemory = false;

        public Builder inmemory() {
            this.inmemory = true;
            return this;
        }

        public Builder config(Consumer<ImmutableStencilConfig.Builder> config) {
            config.accept(this.config);
            return this;
        }

        public Builder defaultObjectMapper() {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.registerModule((Module)new GuavaModule());
            objectMapper.registerModule((Module)new JavaTimeModule());
            objectMapper.registerModule((Module)new Jdk8Module());
            this.config.objectMapper(objectMapper);
            return this;
        }

        public StencilClientImpl build() {
            StencilStore store = this.inmemory ? new StencilStoreInMemory(this.config) : new StencilStoreImpl(this.config.build());
            return new StencilClientImpl(store);
        }
    }
}

