/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.spi;

import io.resys.thena.docdb.api.actions.CommitActions;
import io.resys.thena.docdb.api.actions.ObjectsActions;
import io.smallrye.mutiny.Uni;
import io.thestencil.client.api.ImmutableEntityState;
import io.thestencil.client.api.StencilClient;
import io.thestencil.client.api.StencilConfig;
import io.thestencil.client.api.StencilStore;
import io.thestencil.client.spi.exceptions.DeleteException;
import io.thestencil.client.spi.exceptions.QueryException;
import io.thestencil.client.spi.exceptions.SaveException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class PersistenceCommands
implements StencilConfig.Commands {
    protected final StencilConfig config;

    public PersistenceCommands(StencilConfig config) {
        this.config = config;
    }

    @Override
    public <T extends StencilClient.EntityBody> Uni<StencilClient.Entity<T>> delete(StencilClient.Entity<T> toBeDeleted) {
        return this.config.getClient().commit().head().head(this.config.getRepoName(), this.config.getHeadName()).message("delete type: '" + toBeDeleted.getType() + "', with id: '" + toBeDeleted.getId() + "'").parentIsLatest().author(this.config.getAuthorProvider().getAuthor()).remove(toBeDeleted.getId()).build().onItem().transform(commit -> {
            if (commit.getStatus() == CommitActions.CommitStatus.OK) {
                return toBeDeleted;
            }
            throw new DeleteException(toBeDeleted, (CommitActions.CommitResult)commit);
        });
    }

    @Override
    public <T extends StencilClient.EntityBody> Uni<StencilConfig.EntityState<T>> get(String blobId, StencilClient.EntityType type) {
        return this.config.getClient().objects().blobState().repo(this.config.getRepoName()).anyId(this.config.getHeadName()).blobName(blobId).get().onItem().transform(state -> {
            if (state.getStatus() != ObjectsActions.ObjectsStatus.OK) {
                throw new QueryException(blobId, type, (ObjectsActions.ObjectsResult<?>)state);
            }
            StencilClient.Entity start = this.config.getDeserializer().fromString(type, ((ObjectsActions.BlobObject)state.getObjects()).getBlob().getValue());
            return ImmutableEntityState.builder().src((ObjectsActions.ObjectsResult<ObjectsActions.BlobObject>)state).entity(start).build();
        });
    }

    @Override
    public <T extends StencilClient.EntityBody> Uni<StencilClient.Entity<T>> save(StencilClient.Entity<T> toBeSaved) {
        return this.config.getClient().commit().head().head(this.config.getRepoName(), this.config.getHeadName()).message("update type: '" + toBeSaved.getType() + "', with id: '" + toBeSaved.getId() + "'").parentIsLatest().author(this.config.getAuthorProvider().getAuthor()).append(toBeSaved.getId(), this.config.getSerializer().toString(toBeSaved)).build().onItem().transform(commit -> {
            if (commit.getStatus() == CommitActions.CommitStatus.OK) {
                return toBeSaved;
            }
            throw new SaveException(toBeSaved, (CommitActions.CommitResult)commit);
        });
    }

    @Override
    public <T extends StencilClient.EntityBody> Uni<StencilClient.Entity<T>> create(StencilClient.Entity<T> toBeSaved) {
        return this.config.getClient().commit().head().head(this.config.getRepoName(), this.config.getHeadName()).message("create type: '" + toBeSaved.getType() + "', with id: '" + toBeSaved.getId() + "'").parentIsLatest().author(this.config.getAuthorProvider().getAuthor()).append(toBeSaved.getId(), this.config.getSerializer().toString(toBeSaved)).build().onItem().transform(commit -> {
            if (commit.getStatus() == CommitActions.CommitStatus.OK) {
                return toBeSaved;
            }
            throw new SaveException(toBeSaved, (CommitActions.CommitResult)commit);
        });
    }

    @Override
    public Uni<List<StencilClient.Entity<?>>> saveAll(List<StencilClient.Entity<?>> entities) {
        CommitActions.HeadCommitBuilder commitBuilder = this.config.getClient().commit().head().head(this.config.getRepoName(), this.config.getHeadName());
        StencilClient.Entity<?> first = entities.iterator().next();
        for (StencilClient.Entity<?> target : entities) {
            commitBuilder.append(target.getId(), this.config.getSerializer().toString(target));
        }
        return commitBuilder.message("update type: '" + first.getType() + "', with id: '" + first.getId() + "'").parentIsLatest().author(this.config.getAuthorProvider().getAuthor()).build().onItem().transform(commit -> {
            if (commit.getStatus() == CommitActions.CommitStatus.OK) {
                return entities;
            }
            throw new SaveException(first, (CommitActions.CommitResult)commit);
        });
    }

    @Override
    public Uni<List<StencilClient.Entity<?>>> batch(StencilStore.BatchCommand batch) {
        if (batch.getToBeDeleted().isEmpty() && batch.getToBeDeleted().isEmpty() && batch.getToBeCreated().isEmpty()) {
            return Uni.createFrom().item(Collections.emptyList());
        }
        ArrayList<StencilClient.Entity> all = new ArrayList<StencilClient.Entity>();
        CommitActions.HeadCommitBuilder commitBuilder = this.config.getClient().commit().head().head(this.config.getRepoName(), this.config.getHeadName());
        for (StencilClient.Entity target : batch.getToBeDeleted()) {
            commitBuilder.remove(target.getId());
            all.add(target);
        }
        for (StencilClient.Entity target : batch.getToBeSaved()) {
            commitBuilder.append(target.getId(), this.config.getSerializer().toString(target));
            all.add(target);
        }
        for (StencilClient.Entity target : batch.getToBeCreated()) {
            commitBuilder.append(target.getId(), this.config.getSerializer().toString(target));
            all.add(target);
        }
        return commitBuilder.message("batch created: '" + batch.getToBeCreated().size() + "', updated: '" + batch.getToBeSaved().size() + "', deleted: '" + batch.getToBeDeleted().size() + "'").parentIsLatest().author(this.config.getAuthorProvider().getAuthor()).build().onItem().transform(commit -> {
            if (commit.getStatus() == CommitActions.CommitStatus.OK) {
                return Collections.unmodifiableList(all);
            }
            throw new SaveException((List<StencilClient.Entity<?>>)all, (CommitActions.CommitResult)commit);
        });
    }
}

