/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.docdb.api.DocDB;
import io.thestencil.client.api.StencilConfig;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="StencilConfig", generator="Immutables")
@Immutable
public final class ImmutableStencilConfig
implements StencilConfig {
    private final DocDB client;
    private final String repoName;
    private final String headName;
    private final StencilConfig.AuthorProvider authorProvider;
    private final ObjectMapper objectMapper;
    private final StencilConfig.Serializer serializer;
    private final StencilConfig.Deserializer deserializer;
    private final StencilConfig.GidProvider gidProvider;

    private ImmutableStencilConfig(DocDB client, String repoName, String headName, StencilConfig.AuthorProvider authorProvider, ObjectMapper objectMapper, StencilConfig.Serializer serializer, StencilConfig.Deserializer deserializer, StencilConfig.GidProvider gidProvider) {
        this.client = client;
        this.repoName = repoName;
        this.headName = headName;
        this.authorProvider = authorProvider;
        this.objectMapper = objectMapper;
        this.serializer = serializer;
        this.deserializer = deserializer;
        this.gidProvider = gidProvider;
    }

    @Override
    public DocDB getClient() {
        return this.client;
    }

    @Override
    public String getRepoName() {
        return this.repoName;
    }

    @Override
    public String getHeadName() {
        return this.headName;
    }

    @Override
    public StencilConfig.AuthorProvider getAuthorProvider() {
        return this.authorProvider;
    }

    @Override
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Override
    public StencilConfig.Serializer getSerializer() {
        return this.serializer;
    }

    @Override
    public StencilConfig.Deserializer getDeserializer() {
        return this.deserializer;
    }

    @Override
    public StencilConfig.GidProvider getGidProvider() {
        return this.gidProvider;
    }

    public final ImmutableStencilConfig withClient(DocDB value) {
        if (this.client == value) {
            return this;
        }
        DocDB newValue = Objects.requireNonNull(value, "client");
        return new ImmutableStencilConfig(newValue, this.repoName, this.headName, this.authorProvider, this.objectMapper, this.serializer, this.deserializer, this.gidProvider);
    }

    public final ImmutableStencilConfig withRepoName(String value) {
        String newValue = Objects.requireNonNull(value, "repoName");
        if (this.repoName.equals(newValue)) {
            return this;
        }
        return new ImmutableStencilConfig(this.client, newValue, this.headName, this.authorProvider, this.objectMapper, this.serializer, this.deserializer, this.gidProvider);
    }

    public final ImmutableStencilConfig withHeadName(String value) {
        String newValue = Objects.requireNonNull(value, "headName");
        if (this.headName.equals(newValue)) {
            return this;
        }
        return new ImmutableStencilConfig(this.client, this.repoName, newValue, this.authorProvider, this.objectMapper, this.serializer, this.deserializer, this.gidProvider);
    }

    public final ImmutableStencilConfig withAuthorProvider(StencilConfig.AuthorProvider value) {
        if (this.authorProvider == value) {
            return this;
        }
        StencilConfig.AuthorProvider newValue = Objects.requireNonNull(value, "authorProvider");
        return new ImmutableStencilConfig(this.client, this.repoName, this.headName, newValue, this.objectMapper, this.serializer, this.deserializer, this.gidProvider);
    }

    public final ImmutableStencilConfig withObjectMapper(ObjectMapper value) {
        if (this.objectMapper == value) {
            return this;
        }
        ObjectMapper newValue = Objects.requireNonNull(value, "objectMapper");
        return new ImmutableStencilConfig(this.client, this.repoName, this.headName, this.authorProvider, newValue, this.serializer, this.deserializer, this.gidProvider);
    }

    public final ImmutableStencilConfig withSerializer(StencilConfig.Serializer value) {
        if (this.serializer == value) {
            return this;
        }
        StencilConfig.Serializer newValue = Objects.requireNonNull(value, "serializer");
        return new ImmutableStencilConfig(this.client, this.repoName, this.headName, this.authorProvider, this.objectMapper, newValue, this.deserializer, this.gidProvider);
    }

    public final ImmutableStencilConfig withDeserializer(StencilConfig.Deserializer value) {
        if (this.deserializer == value) {
            return this;
        }
        StencilConfig.Deserializer newValue = Objects.requireNonNull(value, "deserializer");
        return new ImmutableStencilConfig(this.client, this.repoName, this.headName, this.authorProvider, this.objectMapper, this.serializer, newValue, this.gidProvider);
    }

    public final ImmutableStencilConfig withGidProvider(StencilConfig.GidProvider value) {
        if (this.gidProvider == value) {
            return this;
        }
        StencilConfig.GidProvider newValue = Objects.requireNonNull(value, "gidProvider");
        return new ImmutableStencilConfig(this.client, this.repoName, this.headName, this.authorProvider, this.objectMapper, this.serializer, this.deserializer, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStencilConfig && this.equalTo((ImmutableStencilConfig)another);
    }

    private boolean equalTo(ImmutableStencilConfig another) {
        return this.client.equals(another.client) && this.repoName.equals(another.repoName) && this.headName.equals(another.headName) && this.authorProvider.equals(another.authorProvider) && this.objectMapper.equals(another.objectMapper) && this.serializer.equals(another.serializer) && this.deserializer.equals(another.deserializer) && this.gidProvider.equals(another.gidProvider);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.client.hashCode();
        h += (h << 5) + this.repoName.hashCode();
        h += (h << 5) + this.headName.hashCode();
        h += (h << 5) + this.authorProvider.hashCode();
        h += (h << 5) + this.objectMapper.hashCode();
        h += (h << 5) + this.serializer.hashCode();
        h += (h << 5) + this.deserializer.hashCode();
        h += (h << 5) + this.gidProvider.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"StencilConfig").omitNullValues().add("client", (Object)this.client).add("repoName", (Object)this.repoName).add("headName", (Object)this.headName).add("authorProvider", (Object)this.authorProvider).add("objectMapper", (Object)this.objectMapper).add("serializer", (Object)this.serializer).add("deserializer", (Object)this.deserializer).add("gidProvider", (Object)this.gidProvider).toString();
    }

    public static ImmutableStencilConfig copyOf(StencilConfig instance) {
        if (instance instanceof ImmutableStencilConfig) {
            return (ImmutableStencilConfig)instance;
        }
        return ImmutableStencilConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StencilConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CLIENT = 1L;
        private static final long INIT_BIT_REPO_NAME = 2L;
        private static final long INIT_BIT_HEAD_NAME = 4L;
        private static final long INIT_BIT_AUTHOR_PROVIDER = 8L;
        private static final long INIT_BIT_OBJECT_MAPPER = 16L;
        private static final long INIT_BIT_SERIALIZER = 32L;
        private static final long INIT_BIT_DESERIALIZER = 64L;
        private static final long INIT_BIT_GID_PROVIDER = 128L;
        private long initBits = 255L;
        @Nullable
        private DocDB client;
        @Nullable
        private String repoName;
        @Nullable
        private String headName;
        @Nullable
        private StencilConfig.AuthorProvider authorProvider;
        @Nullable
        private ObjectMapper objectMapper;
        @Nullable
        private StencilConfig.Serializer serializer;
        @Nullable
        private StencilConfig.Deserializer deserializer;
        @Nullable
        private StencilConfig.GidProvider gidProvider;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StencilConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.client(instance.getClient());
            this.repoName(instance.getRepoName());
            this.headName(instance.getHeadName());
            this.authorProvider(instance.getAuthorProvider());
            this.objectMapper(instance.getObjectMapper());
            this.serializer(instance.getSerializer());
            this.deserializer(instance.getDeserializer());
            this.gidProvider(instance.getGidProvider());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder client(DocDB client) {
            this.client = Objects.requireNonNull(client, "client");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder repoName(String repoName) {
            this.repoName = Objects.requireNonNull(repoName, "repoName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder headName(String headName) {
            this.headName = Objects.requireNonNull(headName, "headName");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder authorProvider(StencilConfig.AuthorProvider authorProvider) {
            this.authorProvider = Objects.requireNonNull(authorProvider, "authorProvider");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder serializer(StencilConfig.Serializer serializer) {
            this.serializer = Objects.requireNonNull(serializer, "serializer");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder deserializer(StencilConfig.Deserializer deserializer) {
            this.deserializer = Objects.requireNonNull(deserializer, "deserializer");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder gidProvider(StencilConfig.GidProvider gidProvider) {
            this.gidProvider = Objects.requireNonNull(gidProvider, "gidProvider");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public ImmutableStencilConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStencilConfig(this.client, this.repoName, this.headName, this.authorProvider, this.objectMapper, this.serializer, this.deserializer, this.gidProvider);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("client");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("repoName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("headName");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("authorProvider");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("objectMapper");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("serializer");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("deserializer");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("gidProvider");
            }
            return "Cannot build StencilConfig, some of required attributes are not set " + attributes;
        }
    }
}

