/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.api;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.thestencil.client.api.Markdowns;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Markdowns.LinkResource", generator="Immutables")
@Immutable
public final class ImmutableLinkResource
implements Markdowns.LinkResource {
    private final String id;
    private final String type;
    private final String path;
    private final String value;
    private final ImmutableList<String> locale;
    private final Boolean workflow;
    private final Boolean global;
    @Nullable
    private final String desc;

    private ImmutableLinkResource(String id, String type, String path, String value, ImmutableList<String> locale, Boolean workflow, Boolean global, @Nullable String desc) {
        this.id = id;
        this.type = type;
        this.path = path;
        this.value = value;
        this.locale = locale;
        this.workflow = workflow;
        this.global = global;
        this.desc = desc;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public ImmutableList<String> getLocale() {
        return this.locale;
    }

    @Override
    public Boolean getWorkflow() {
        return this.workflow;
    }

    @Override
    public Boolean getGlobal() {
        return this.global;
    }

    @Override
    @Nullable
    public String getDesc() {
        return this.desc;
    }

    public final ImmutableLinkResource withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableLinkResource(newValue, this.type, this.path, this.value, this.locale, this.workflow, this.global, this.desc);
    }

    public final ImmutableLinkResource withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ImmutableLinkResource(this.id, newValue, this.path, this.value, this.locale, this.workflow, this.global, this.desc);
    }

    public final ImmutableLinkResource withPath(String value) {
        String newValue = Objects.requireNonNull(value, "path");
        if (this.path.equals(newValue)) {
            return this;
        }
        return new ImmutableLinkResource(this.id, this.type, newValue, this.value, this.locale, this.workflow, this.global, this.desc);
    }

    public final ImmutableLinkResource withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new ImmutableLinkResource(this.id, this.type, this.path, newValue, this.locale, this.workflow, this.global, this.desc);
    }

    public final ImmutableLinkResource withLocale(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableLinkResource(this.id, this.type, this.path, this.value, (ImmutableList<String>)newValue, this.workflow, this.global, this.desc);
    }

    public final ImmutableLinkResource withLocale(Iterable<String> elements) {
        if (this.locale == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableLinkResource(this.id, this.type, this.path, this.value, (ImmutableList<String>)newValue, this.workflow, this.global, this.desc);
    }

    public final ImmutableLinkResource withWorkflow(Boolean value) {
        Boolean newValue = Objects.requireNonNull(value, "workflow");
        if (this.workflow.equals(newValue)) {
            return this;
        }
        return new ImmutableLinkResource(this.id, this.type, this.path, this.value, this.locale, newValue, this.global, this.desc);
    }

    public final ImmutableLinkResource withGlobal(Boolean value) {
        Boolean newValue = Objects.requireNonNull(value, "global");
        if (this.global.equals(newValue)) {
            return this;
        }
        return new ImmutableLinkResource(this.id, this.type, this.path, this.value, this.locale, this.workflow, newValue, this.desc);
    }

    public final ImmutableLinkResource withDesc(@Nullable String value) {
        if (Objects.equals(this.desc, value)) {
            return this;
        }
        return new ImmutableLinkResource(this.id, this.type, this.path, this.value, this.locale, this.workflow, this.global, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLinkResource && this.equalTo((ImmutableLinkResource)another);
    }

    private boolean equalTo(ImmutableLinkResource another) {
        return this.id.equals(another.id) && this.type.equals(another.type) && this.path.equals(another.path) && this.value.equals(another.value) && this.locale.equals(another.locale) && this.workflow.equals(another.workflow) && this.global.equals(another.global) && Objects.equals(this.desc, another.desc);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.path.hashCode();
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + this.locale.hashCode();
        h += (h << 5) + this.workflow.hashCode();
        h += (h << 5) + this.global.hashCode();
        h += (h << 5) + Objects.hashCode(this.desc);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"LinkResource").omitNullValues().add("id", (Object)this.id).add("type", (Object)this.type).add("path", (Object)this.path).add("value", (Object)this.value).add("locale", this.locale).add("workflow", (Object)this.workflow).add("global", (Object)this.global).add("desc", (Object)this.desc).toString();
    }

    public static ImmutableLinkResource copyOf(Markdowns.LinkResource instance) {
        if (instance instanceof ImmutableLinkResource) {
            return (ImmutableLinkResource)instance;
        }
        return ImmutableLinkResource.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Markdowns.LinkResource", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private static final long INIT_BIT_PATH = 4L;
        private static final long INIT_BIT_VALUE = 8L;
        private static final long INIT_BIT_WORKFLOW = 16L;
        private static final long INIT_BIT_GLOBAL = 32L;
        private long initBits = 63L;
        @Nullable
        private String id;
        @Nullable
        private String type;
        @Nullable
        private String path;
        @Nullable
        private String value;
        private ImmutableList.Builder<String> locale = ImmutableList.builder();
        @Nullable
        private Boolean workflow;
        @Nullable
        private Boolean global;
        @Nullable
        private String desc;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Markdowns.LinkResource instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            this.type(instance.getType());
            this.path(instance.getPath());
            this.value(instance.getValue());
            this.addAllLocale(instance.getLocale());
            this.workflow(instance.getWorkflow());
            this.global(instance.getGlobal());
            String descValue = instance.getDesc();
            if (descValue != null) {
                this.desc(descValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder path(String path) {
            this.path = Objects.requireNonNull(path, "path");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLocale(String element) {
            this.locale.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLocale(String ... elements) {
            this.locale.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder locale(Iterable<String> elements) {
            this.locale = ImmutableList.builder();
            return this.addAllLocale(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllLocale(Iterable<String> elements) {
            this.locale.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder workflow(Boolean workflow) {
            this.workflow = Objects.requireNonNull(workflow, "workflow");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder global(Boolean global) {
            this.global = Objects.requireNonNull(global, "global");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder desc(@Nullable String desc) {
            this.desc = desc;
            return this;
        }

        public ImmutableLinkResource build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLinkResource(this.id, this.type, this.path, this.value, (ImmutableList<String>)this.locale.build(), this.workflow, this.global, this.desc);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("path");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("value");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("workflow");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("global");
            }
            return "Cannot build LinkResource, some of required attributes are not set " + attributes;
        }
    }
}

