/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.spi.builders;

import io.smallrye.mutiny.Uni;
import io.thestencil.client.api.ImmutableBatchCommand;
import io.thestencil.client.api.MigrationBuilder;
import io.thestencil.client.api.StencilClient;
import io.thestencil.client.api.StencilComposer;
import io.thestencil.client.api.StencilStore;
import io.thestencil.client.spi.builders.MigrationImportVisitorForSiteState;
import io.thestencil.client.spi.builders.MigrationImportVisitorForStaticContent;

public class MigrationBuilderImpl
implements MigrationBuilder {
    private final StencilClient client;

    @Override
    public Uni<StencilComposer.SiteState> importData(MigrationBuilder.Sites sites) {
        Uni<StencilComposer.SiteState> query = this.client.getStore().query().head();
        return query.onItem().transformToUni(site -> {
            ImmutableBatchCommand builder = new MigrationImportVisitorForStaticContent((StencilComposer.SiteState)site, this.client).visit(sites);
            return this.client.getStore().batch(builder).onItem().transformToUni(s -> this.client.getStore().query().head());
        });
    }

    @Override
    public Uni<StencilComposer.SiteState> importData(StencilComposer.SiteState sites) {
        Uni<StencilComposer.SiteState> query = this.client.getStore().query().head();
        return query.onItem().transformToUni(site -> {
            StencilStore.BatchCommand builder = new MigrationImportVisitorForSiteState((StencilComposer.SiteState)site).visit(sites);
            return this.client.getStore().batch(builder).onItem().transformToUni(s -> this.client.getStore().query().head());
        });
    }

    public MigrationBuilderImpl(StencilClient client) {
        this.client = client;
    }
}

