/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.spi.builders;

import io.smallrye.mutiny.Uni;
import io.thestencil.client.api.DeleteBuilder;
import io.thestencil.client.api.ImmutableEntity;
import io.thestencil.client.api.ImmutableLink;
import io.thestencil.client.api.ImmutableWorkflow;
import io.thestencil.client.api.StencilClient;
import io.thestencil.client.spi.builders.ArticleDeleteVisitor;
import java.util.List;
import java.util.stream.Collectors;

public class DeleteBuilderImpl
implements DeleteBuilder {
    private final StencilClient client;

    @Override
    public Uni<StencilClient.Entity<StencilClient.Article>> article(String articleId) {
        return new ArticleDeleteVisitor(this.client, articleId).visit();
    }

    @Override
    public Uni<StencilClient.Entity<StencilClient.Locale>> locale(String localeId) {
        Uni query = this.client.getStore().get(localeId, StencilClient.EntityType.LOCALE);
        return query.onItem().transformToUni(state -> this.client.getStore().delete(state.getEntity()));
    }

    @Override
    public Uni<StencilClient.Entity<StencilClient.Template>> template(String templateId) {
        Uni query = this.client.getStore().get(templateId, StencilClient.EntityType.TEMPLATE);
        return query.onItem().transformToUni(state -> this.client.getStore().delete(state.getEntity()));
    }

    @Override
    public Uni<StencilClient.Entity<StencilClient.Page>> page(String pageId) {
        Uni query = this.client.getStore().get(pageId, StencilClient.EntityType.PAGE);
        return query.onItem().transformToUni(state -> this.client.getStore().delete(state.getEntity()));
    }

    @Override
    public Uni<StencilClient.Entity<StencilClient.Link>> link(String linkId) {
        Uni query = this.client.getStore().get(linkId, StencilClient.EntityType.LINK);
        return query.onItem().transformToUni(state -> this.client.getStore().delete(state.getEntity()));
    }

    @Override
    public Uni<StencilClient.Entity<StencilClient.Workflow>> workflow(String workflowId) {
        Uni query = this.client.getStore().get(workflowId, StencilClient.EntityType.WORKFLOW);
        return query.onItem().transformToUni(state -> this.client.getStore().delete(state.getEntity()));
    }

    @Override
    public Uni<StencilClient.Entity<StencilClient.Link>> linkArticlePage(DeleteBuilder.LinkArticlePage linkArticlePage) {
        Uni query = this.client.getStore().get(linkArticlePage.getLinkId(), StencilClient.EntityType.LINK);
        return query.onItem().transformToUni(state -> {
            StencilClient.Entity start = state.getEntity();
            List<String> newArticles = ((StencilClient.Link)start.getBody()).getArticles().stream().filter(a -> !a.equals(linkArticlePage.getArticleId())).collect(Collectors.toList());
            if (newArticles.size() == ((StencilClient.Link)start.getBody()).getArticles().size()) {
                return Uni.createFrom().item(start);
            }
            ImmutableEntity<ImmutableLink> end = ImmutableEntity.builder().id(start.getId()).type(start.getType()).body(ImmutableLink.builder().from((StencilClient.Link)start.getBody()).articles(newArticles).build()).build();
            return this.client.getStore().save(end);
        });
    }

    @Override
    public Uni<StencilClient.Entity<StencilClient.Workflow>> workflowArticlePage(DeleteBuilder.WorkflowArticlePage workflowArticlePage) {
        Uni query = this.client.getStore().get(workflowArticlePage.getWorkflowId(), StencilClient.EntityType.WORKFLOW);
        return query.onItem().transformToUni(state -> {
            StencilClient.Entity start = state.getEntity();
            List<String> newArticles = ((StencilClient.Workflow)start.getBody()).getArticles().stream().filter(a -> !a.equals(workflowArticlePage.getArticleId())).collect(Collectors.toList());
            if (newArticles.size() == ((StencilClient.Workflow)start.getBody()).getArticles().size()) {
                return Uni.createFrom().item(start);
            }
            ImmutableEntity<ImmutableWorkflow> end = ImmutableEntity.builder().id(start.getId()).type(start.getType()).body(ImmutableWorkflow.builder().from((StencilClient.Workflow)start.getBody()).articles(newArticles).build()).build();
            return this.client.getStore().save(end);
        });
    }

    @Override
    public Uni<StencilClient.Entity<StencilClient.Release>> release(String releaseId) {
        Uni query = this.client.getStore().get(releaseId, StencilClient.EntityType.RELEASE);
        return query.onItem().transformToUni(state -> this.client.getStore().delete(state.getEntity()));
    }

    public DeleteBuilderImpl(StencilClient client) {
        this.client = client;
    }
}

