/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.spi.builders;

import io.smallrye.mutiny.Uni;
import io.thestencil.client.api.CreateBuilder;
import io.thestencil.client.api.ImmutableArticle;
import io.thestencil.client.api.ImmutableEntity;
import io.thestencil.client.api.ImmutableLink;
import io.thestencil.client.api.ImmutableLocale;
import io.thestencil.client.api.ImmutableLocaleLabel;
import io.thestencil.client.api.ImmutablePage;
import io.thestencil.client.api.ImmutableRelease;
import io.thestencil.client.api.ImmutableTemplate;
import io.thestencil.client.api.ImmutableWorkflow;
import io.thestencil.client.api.StencilClient;
import io.thestencil.client.api.StencilComposer;
import io.thestencil.client.spi.StencilAssert;
import io.thestencil.client.spi.builders.BatchSiteCommandVisitor;
import io.thestencil.client.spi.builders.CreateReleaseVisitor;
import io.thestencil.client.spi.exceptions.ConstraintException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class CreateBuilderImpl
implements CreateBuilder {
    private final StencilClient client;

    @Override
    public Uni<List<StencilClient.Entity<?>>> batch(CreateBuilder.BatchSite batch) {
        Uni<StencilComposer.SiteState> query = this.client.getStore().query().head();
        return query.onItem().transformToUni(state -> this.client.getStore().batch(new BatchSiteCommandVisitor((StencilComposer.SiteState)state, this.client).visit(batch)));
    }

    @Override
    public Uni<StencilClient.Entity<StencilClient.Article>> article(CreateBuilder.CreateArticle init) {
        Uni<StencilComposer.SiteState> query = this.client.getStore().query().head();
        return query.onItem().transformToUni(state -> this.client.getStore().create(CreateBuilderImpl.article(init, state, this.client)));
    }

    @Override
    public Uni<StencilClient.Entity<StencilClient.Template>> template(CreateBuilder.CreateTemplate init) {
        Uni<StencilComposer.SiteState> query = this.client.getStore().query().head();
        return query.onItem().transformToUni(state -> this.client.getStore().create(CreateBuilderImpl.template(init, state, this.client)));
    }

    @Override
    public Uni<StencilClient.Entity<StencilClient.Release>> release(CreateBuilder.CreateRelease init) {
        Uni<StencilComposer.SiteState> query = this.client.getStore().query().head();
        return query.onItem().transformToUni(state -> this.client.getStore().create(CreateBuilderImpl.release(init, state, this.client)));
    }

    @Override
    public Uni<StencilClient.Entity<StencilClient.Locale>> locale(CreateBuilder.CreateLocale init) {
        Uni<StencilComposer.SiteState> query = this.client.getStore().query().head();
        return query.onItem().transformToUni(state -> this.client.getStore().create(CreateBuilderImpl.locale(init, state, this.client)));
    }

    @Override
    public Uni<StencilClient.Entity<StencilClient.Page>> page(CreateBuilder.CreatePage init) {
        Uni<StencilComposer.SiteState> query = this.client.getStore().query().head();
        return query.onItem().transformToUni(state -> this.client.getStore().create(CreateBuilderImpl.page(init, state, this.client)));
    }

    @Override
    public Uni<StencilClient.Entity<StencilClient.Link>> link(CreateBuilder.CreateLink init) {
        Uni<StencilComposer.SiteState> query = this.client.getStore().query().head();
        return query.onItem().transformToUni(state -> this.client.getStore().create(CreateBuilderImpl.link(init, state, this.client)));
    }

    @Override
    public Uni<StencilClient.Entity<StencilClient.Workflow>> workflow(CreateBuilder.CreateWorkflow init) {
        Uni<StencilComposer.SiteState> query = this.client.getStore().query().head();
        return query.onItem().transformToUni(state -> this.client.getStore().create(CreateBuilderImpl.workflow(init, state, this.client)));
    }

    public static StencilClient.Entity<StencilClient.Release> release(CreateBuilder.CreateRelease init, StencilComposer.SiteState state, StencilClient client) {
        StencilAssert.isTrue(state.getContentType() != StencilComposer.SiteContentType.NOT_CREATED, () -> "Can't create release because ref state query failed!");
        String gid = client.getStore().gid(StencilClient.EntityType.RELEASE);
        ImmutableRelease release = new CreateReleaseVisitor(state).visit(ImmutableRelease.builder().name(init.getName()).created(LocalDateTime.now()).note(Optional.ofNullable(init.getNote()).orElse("")).parentCommit(state.getCommit())).build();
        ImmutableEntity<ImmutableRelease> entity = ImmutableEntity.builder().id(gid).type(StencilClient.EntityType.RELEASE).body(release).build();
        return CreateBuilderImpl.assertUniqueId(entity, state);
    }

    public static StencilClient.Entity<StencilClient.Template> template(CreateBuilder.CreateTemplate init, StencilComposer.SiteState state, StencilClient client) {
        String gid = client.getStore().gid(StencilClient.EntityType.TEMPLATE);
        ImmutableTemplate template = ImmutableTemplate.builder().name(init.getName()).description(init.getDescription()).type(init.getType()).content(init.getContent()).build();
        ImmutableEntity<ImmutableTemplate> entity = ImmutableEntity.builder().id(gid).type(StencilClient.EntityType.TEMPLATE).body(template).build();
        Optional<StencilClient.Entity> duplicate = state.getTemplates().values().stream().filter(p -> ((StencilClient.Template)p.getBody()).getName().equals(init.getName())).findFirst();
        if (duplicate.isPresent()) {
            throw new ConstraintException(entity, "Template: '" + init.getName() + "' already exists!");
        }
        return CreateBuilderImpl.assertUniqueId(entity, state);
    }

    public static StencilClient.Entity<StencilClient.Article> article(CreateBuilder.CreateArticle init, StencilComposer.SiteState state, StencilClient client) {
        String gid = client.getStore().gid(StencilClient.EntityType.ARTICLE);
        ImmutableArticle article = ImmutableArticle.builder().devMode(init.getDevMode()).name(init.getName()).parentId(init.getParentId()).order(Optional.ofNullable(init.getOrder()).orElse(0)).build();
        ImmutableEntity<ImmutableArticle> entity = ImmutableEntity.builder().id(gid).type(StencilClient.EntityType.ARTICLE).body(article).build();
        Optional<StencilClient.Entity> duplicate = state.getArticles().values().stream().filter(p -> ((StencilClient.Article)p.getBody()).getName().equals(init.getName())).findFirst();
        if (duplicate.isPresent()) {
            throw new ConstraintException(entity, "Article: '" + init.getName() + "' already exists!");
        }
        if (init.getParentId() != null && !state.getArticles().containsKey(init.getParentId())) {
            throw new ConstraintException(entity, "Article: '" + init.getName() + "', parent: '" + init.getParentId() + "' does not exist!");
        }
        return CreateBuilderImpl.assertUniqueId(entity, state);
    }

    public static StencilClient.Entity<StencilClient.Locale> locale(CreateBuilder.CreateLocale init, StencilComposer.SiteState state, StencilClient client) {
        String gid = client.getStore().gid(StencilClient.EntityType.LOCALE);
        ImmutableLocale locale = ImmutableLocale.builder().value(init.getLocale()).enabled(true).build();
        ImmutableEntity<ImmutableLocale> entity = ImmutableEntity.builder().id(gid).type(StencilClient.EntityType.LOCALE).body(locale).build();
        Optional<StencilClient.Entity> duplicate = state.getLocales().values().stream().filter(p -> ((StencilClient.Locale)p.getBody()).getValue().equals(init.getLocale())).findFirst();
        if (duplicate.isPresent()) {
            throw new ConstraintException(entity, "Locale: '" + init.getLocale() + "' already exists!");
        }
        return CreateBuilderImpl.assertUniqueId(entity, state);
    }

    public static StencilClient.Entity<StencilClient.Page> page(CreateBuilder.CreatePage init, StencilComposer.SiteState state, StencilClient client) {
        String gid = client.getStore().gid(StencilClient.EntityType.PAGE);
        String localeRef = init.getLocale();
        Optional<StencilClient.Entity<StencilClient.Locale>> locale = CreateBuilderImpl.resolveLocale(localeRef, state);
        String articleRef = init.getArticleId();
        Optional<StencilClient.Entity<StencilClient.Article>> article = state.getArticles().containsKey(articleRef) ? Optional.of(state.getArticles().get(articleRef)) : state.getArticles().values().stream().filter(l -> ((StencilClient.Article)l.getBody()).getName().equalsIgnoreCase(articleRef)).findFirst();
        ImmutablePage page = ImmutablePage.builder().devMode(init.getDevMode()).article(article.map(e -> e.getId()).orElse(articleRef)).locale(locale.map(e -> e.getId()).orElse(localeRef)).content(Optional.ofNullable(init.getContent()).orElse("")).build();
        ImmutableEntity<ImmutablePage> entity = ImmutableEntity.builder().id(gid).type(StencilClient.EntityType.PAGE).body(page).build();
        if (locale.isEmpty()) {
            throw new ConstraintException(entity, "Locale with id: '" + localeRef + "' does not exist in: '" + String.join((CharSequence)",", state.getLocales().keySet()) + "'!");
        }
        if (article.isEmpty()) {
            throw new ConstraintException(entity, "Article with id: '" + articleRef + "' does not exist in: '" + String.join((CharSequence)",", state.getArticles().keySet()) + "'!");
        }
        Optional<StencilClient.Entity> duplicate = state.getPages().values().stream().filter(p -> ((StencilClient.Page)p.getBody()).getArticle().equals(init.getArticleId())).filter(p -> ((StencilClient.Page)p.getBody()).getLocale().equals(init.getLocale())).findFirst();
        if (duplicate.isPresent()) {
            throw new ConstraintException(entity, "Page locale with id: '" + locale.get().getId() + "' already exists!");
        }
        return CreateBuilderImpl.assertUniqueId(entity, state);
    }

    public static StencilClient.Entity<StencilClient.Link> link(CreateBuilder.CreateLink init, StencilComposer.SiteState state, StencilClient client) {
        String gid = client.getStore().gid(StencilClient.EntityType.LINK);
        ImmutableLink.Builder link = ImmutableLink.builder().devMode(init.getDevMode()).contentType(init.getType()).value(init.getValue());
        ArrayList<String> articles = new ArrayList<String>();
        for (String articleRef : init.getArticles()) {
            Optional<StencilClient.Entity<StencilClient.Article>> article;
            Optional<StencilClient.Entity<StencilClient.Article>> optional = article = state.getArticles().containsKey(articleRef) ? Optional.of(state.getArticles().get(articleRef)) : state.getArticles().values().stream().filter(l -> ((StencilClient.Article)l.getBody()).getName().equalsIgnoreCase(articleRef)).findFirst();
            if (article.isEmpty()) {
                throw new ConstraintException(ImmutableEntity.builder().id(gid).type(StencilClient.EntityType.LINK).body(link.articles(init.getArticles()).build()).build(), "Article with id: '" + articleRef + "' does not exist in: '" + String.join((CharSequence)",", state.getArticles().keySet()) + "'!");
            }
            articles.add(article.get().getId());
        }
        link.articles(articles);
        for (StencilClient.LocaleLabel label : init.getLabels()) {
            String localeRef = label.getLocale();
            Optional<StencilClient.Entity<StencilClient.Locale>> locale = CreateBuilderImpl.resolveLocale(localeRef, state);
            link.addLabels((StencilClient.LocaleLabel)ImmutableLocaleLabel.builder().locale(locale.map(e -> e.getId()).orElse(localeRef)).labelValue(label.getLabelValue()).build());
            if (!locale.isEmpty()) continue;
            throw new ConstraintException(ImmutableEntity.builder().id(gid).type(StencilClient.EntityType.LINK).body(link.build()).build(), "Locale with id: '" + label.getLocale() + "' does not exist in: '" + String.join((CharSequence)",", state.getLocales().keySet()) + "'!");
        }
        return CreateBuilderImpl.assertUniqueId(ImmutableEntity.builder().id(gid).type(StencilClient.EntityType.LINK).body(link.build()).build(), state);
    }

    public static StencilClient.Entity<StencilClient.Workflow> workflow(CreateBuilder.CreateWorkflow init, StencilComposer.SiteState state, StencilClient client) {
        String gid = client.getStore().gid(StencilClient.EntityType.WORKFLOW);
        ImmutableWorkflow.Builder workflow = ImmutableWorkflow.builder().devMode(init.getDevMode()).value(init.getValue());
        ArrayList<String> articles = new ArrayList<String>();
        for (String articleRef : init.getArticles()) {
            Optional<StencilClient.Entity<StencilClient.Article>> article;
            Optional<StencilClient.Entity<StencilClient.Article>> optional = article = state.getArticles().containsKey(articleRef) ? Optional.of(state.getArticles().get(articleRef)) : state.getArticles().values().stream().filter(l -> ((StencilClient.Article)l.getBody()).getName().equalsIgnoreCase(articleRef)).findFirst();
            if (article.isEmpty()) {
                throw new ConstraintException(ImmutableEntity.builder().id(gid).type(StencilClient.EntityType.WORKFLOW).body(workflow.articles(init.getArticles()).build()).build(), "Article with id: '" + articleRef + "' does not exist in: '" + String.join((CharSequence)",", state.getArticles().keySet()) + "'!");
            }
            articles.add(article.get().getId());
        }
        workflow.articles(articles);
        for (StencilClient.LocaleLabel label : init.getLabels()) {
            String localeRef = label.getLocale();
            Optional<StencilClient.Entity<StencilClient.Locale>> locale = CreateBuilderImpl.resolveLocale(localeRef, state);
            workflow.addLabels((StencilClient.LocaleLabel)ImmutableLocaleLabel.builder().locale(locale.map(e -> e.getId()).orElse(localeRef)).labelValue(label.getLabelValue()).build());
            if (!locale.isEmpty()) continue;
            throw new ConstraintException(ImmutableEntity.builder().id(gid).type(StencilClient.EntityType.WORKFLOW).body(workflow.build()).build(), "Locale with id: '" + label.getLocale() + "' does not exist in: '" + String.join((CharSequence)",", state.getLocales().keySet()) + "'!");
        }
        return CreateBuilderImpl.assertUniqueId(ImmutableEntity.builder().id(gid).type(StencilClient.EntityType.WORKFLOW).body(workflow.build()).build(), state);
    }

    public static Optional<StencilClient.Entity<StencilClient.Locale>> resolveLocale(String idOrValue, StencilComposer.SiteState state) {
        String localeRef = idOrValue;
        Optional<StencilClient.Entity<StencilClient.Locale>> locale = state.getLocales().containsKey(localeRef) ? Optional.of(state.getLocales().get(localeRef)) : state.getLocales().values().stream().filter(l -> ((StencilClient.Locale)l.getBody()).getValue().equalsIgnoreCase(localeRef)).findFirst();
        return locale;
    }

    @Override
    public Uni<StencilComposer.SiteState> repo() {
        return this.client.getStore().repo().create().onItem().transformToUni(e -> e.query().head());
    }

    private static <T extends StencilClient.EntityBody> StencilClient.Entity<T> assertUniqueId(StencilClient.Entity<T> entity, StencilComposer.SiteState state) {
        if (state.getReleases().containsKey(entity.getId()) || state.getLocales().containsKey(entity.getId()) || state.getPages().containsKey(entity.getId()) || state.getLinks().containsKey(entity.getId()) || state.getArticles().containsKey(entity.getId()) || state.getWorkflows().containsKey(entity.getId()) || state.getTemplates().containsKey(entity.getId())) {
            throw new ConstraintException(entity, "Entity with id: '" + entity.getId() + "' already exist!");
        }
        return entity;
    }

    public CreateBuilderImpl(StencilClient client) {
        this.client = client;
    }
}

