/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.spi.builders;

import io.thestencil.client.api.CreateBuilder;
import io.thestencil.client.api.ImmutableBatchCommand;
import io.thestencil.client.api.ImmutableSiteState;
import io.thestencil.client.api.StencilClient;
import io.thestencil.client.api.StencilComposer;
import io.thestencil.client.api.StencilStore;
import io.thestencil.client.spi.builders.CreateBuilderImpl;
import java.util.List;
import java.util.stream.Collectors;

public class BatchSiteCommandVisitor {
    private final StencilClient client;
    private final ImmutableSiteState.Builder next;

    public BatchSiteCommandVisitor(StencilComposer.SiteState start, StencilClient client) {
        this.client = client;
        this.next = ImmutableSiteState.builder().from(start);
    }

    public StencilStore.BatchCommand visit(CreateBuilder.BatchSite command) {
        List locales = command.getLocales().stream().map(this::visitLocale).collect(Collectors.toList());
        List articles = command.getArticles().stream().map(this::visitArticle).collect(Collectors.toList());
        List pages = command.getPages().stream().map(this::visitPage).collect(Collectors.toList());
        List workflows = command.getWorkflows().stream().map(this::visitWorkflow).collect(Collectors.toList());
        List links = command.getLinks().stream().map(this::visitLink).collect(Collectors.toList());
        return ImmutableBatchCommand.builder().addAllToBeCreated(locales).addAllToBeCreated(articles).addAllToBeCreated(pages).addAllToBeCreated(workflows).addAllToBeCreated(links).build();
    }

    private StencilClient.Entity<StencilClient.Locale> visitLocale(CreateBuilder.CreateLocale init) {
        StencilClient.Entity<StencilClient.Locale> created = CreateBuilderImpl.locale(init, this.next.build(), this.client);
        this.next.putLocales(created.getId(), created);
        return created;
    }

    private StencilClient.Entity<StencilClient.Article> visitArticle(CreateBuilder.CreateArticle init) {
        StencilClient.Entity<StencilClient.Article> created = CreateBuilderImpl.article(init, this.next.build(), this.client);
        this.next.putArticles(created.getId(), created);
        return created;
    }

    private StencilClient.Entity<StencilClient.Page> visitPage(CreateBuilder.CreatePage init) {
        StencilClient.Entity<StencilClient.Page> created = CreateBuilderImpl.page(init, this.next.build(), this.client);
        this.next.putPages(created.getId(), created);
        return created;
    }

    private StencilClient.Entity<StencilClient.Workflow> visitWorkflow(CreateBuilder.CreateWorkflow init) {
        StencilClient.Entity<StencilClient.Workflow> created = CreateBuilderImpl.workflow(init, this.next.build(), this.client);
        this.next.putWorkflows(created.getId(), created);
        return created;
    }

    private StencilClient.Entity<StencilClient.Link> visitLink(CreateBuilder.CreateLink init) {
        StencilClient.Entity<StencilClient.Link> created = CreateBuilderImpl.link(init, this.next.build(), this.client);
        this.next.putLinks(created.getId(), created);
        return created;
    }
}

