/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.thestencil.client.api.StencilClient;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="StencilClient.LocaleLabel", generator="Immutables")
@Immutable
public final class ImmutableLocaleLabel
implements StencilClient.LocaleLabel {
    private final String locale;
    private final String labelValue;

    private ImmutableLocaleLabel(String locale, String labelValue) {
        this.locale = locale;
        this.labelValue = labelValue;
    }

    @Override
    @JsonProperty(value="locale")
    public String getLocale() {
        return this.locale;
    }

    @Override
    @JsonProperty(value="labelValue")
    public String getLabelValue() {
        return this.labelValue;
    }

    public final ImmutableLocaleLabel withLocale(String value) {
        String newValue = Objects.requireNonNull(value, "locale");
        if (this.locale.equals(newValue)) {
            return this;
        }
        return new ImmutableLocaleLabel(newValue, this.labelValue);
    }

    public final ImmutableLocaleLabel withLabelValue(String value) {
        String newValue = Objects.requireNonNull(value, "labelValue");
        if (this.labelValue.equals(newValue)) {
            return this;
        }
        return new ImmutableLocaleLabel(this.locale, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLocaleLabel && this.equalTo((ImmutableLocaleLabel)another);
    }

    private boolean equalTo(ImmutableLocaleLabel another) {
        return this.locale.equals(another.locale) && this.labelValue.equals(another.labelValue);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.locale.hashCode();
        h += (h << 5) + this.labelValue.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"LocaleLabel").omitNullValues().add("locale", (Object)this.locale).add("labelValue", (Object)this.labelValue).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableLocaleLabel fromJson(Json json) {
        Builder builder = ImmutableLocaleLabel.builder();
        if (json.locale != null) {
            builder.locale(json.locale);
        }
        if (json.labelValue != null) {
            builder.labelValue(json.labelValue);
        }
        return builder.build();
    }

    public static ImmutableLocaleLabel copyOf(StencilClient.LocaleLabel instance) {
        if (instance instanceof ImmutableLocaleLabel) {
            return (ImmutableLocaleLabel)instance;
        }
        return ImmutableLocaleLabel.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StencilClient.LocaleLabel", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_LOCALE = 1L;
        private static final long INIT_BIT_LABEL_VALUE = 2L;
        private long initBits = 3L;
        @Nullable
        private String locale;
        @Nullable
        private String labelValue;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StencilClient.LocaleLabel instance) {
            Objects.requireNonNull(instance, "instance");
            this.locale(instance.getLocale());
            this.labelValue(instance.getLabelValue());
            return this;
        }

        @JsonProperty(value="locale")
        @CanIgnoreReturnValue
        public final Builder locale(String locale) {
            this.locale = Objects.requireNonNull(locale, "locale");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="labelValue")
        @CanIgnoreReturnValue
        public final Builder labelValue(String labelValue) {
            this.labelValue = Objects.requireNonNull(labelValue, "labelValue");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableLocaleLabel build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLocaleLabel(this.locale, this.labelValue);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("locale");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("labelValue");
            }
            return "Cannot build LocaleLabel, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="StencilClient.LocaleLabel", generator="Immutables")
    static final class Json
    implements StencilClient.LocaleLabel {
        @Nullable
        String locale;
        @Nullable
        String labelValue;

        Json() {
        }

        @JsonProperty(value="locale")
        public void setLocale(String locale) {
            this.locale = locale;
        }

        @JsonProperty(value="labelValue")
        public void setLabelValue(String labelValue) {
            this.labelValue = labelValue;
        }

        @Override
        public String getLocale() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getLabelValue() {
            throw new UnsupportedOperationException();
        }
    }
}

