/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.thestencil.client.api.StencilClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="StencilClient.Link", generator="Immutables")
@Immutable
public final class ImmutableLink
implements StencilClient.Link {
    private final String value;
    @Nullable
    private final Boolean devMode;
    private final String contentType;
    private final ImmutableList<String> articles;
    private final ImmutableList<StencilClient.LocaleLabel> labels;

    private ImmutableLink(String value, @Nullable Boolean devMode, String contentType, ImmutableList<String> articles, ImmutableList<StencilClient.LocaleLabel> labels) {
        this.value = value;
        this.devMode = devMode;
        this.contentType = contentType;
        this.articles = articles;
        this.labels = labels;
    }

    @Override
    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    @Override
    @JsonProperty(value="devMode")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public Boolean getDevMode() {
        return this.devMode;
    }

    @Override
    @JsonProperty(value="contentType")
    public String getContentType() {
        return this.contentType;
    }

    @JsonProperty(value="articles")
    public ImmutableList<String> getArticles() {
        return this.articles;
    }

    @JsonProperty(value="labels")
    public ImmutableList<StencilClient.LocaleLabel> getLabels() {
        return this.labels;
    }

    public final ImmutableLink withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new ImmutableLink(newValue, this.devMode, this.contentType, this.articles, this.labels);
    }

    public final ImmutableLink withDevMode(@Nullable Boolean value) {
        if (Objects.equals(this.devMode, value)) {
            return this;
        }
        return new ImmutableLink(this.value, value, this.contentType, this.articles, this.labels);
    }

    public final ImmutableLink withContentType(String value) {
        String newValue = Objects.requireNonNull(value, "contentType");
        if (this.contentType.equals(newValue)) {
            return this;
        }
        return new ImmutableLink(this.value, this.devMode, newValue, this.articles, this.labels);
    }

    public final ImmutableLink withArticles(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableLink(this.value, this.devMode, this.contentType, (ImmutableList<String>)newValue, this.labels);
    }

    public final ImmutableLink withArticles(Iterable<String> elements) {
        if (this.articles == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableLink(this.value, this.devMode, this.contentType, (ImmutableList<String>)newValue, this.labels);
    }

    public final ImmutableLink withLabels(StencilClient.LocaleLabel ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableLink(this.value, this.devMode, this.contentType, this.articles, (ImmutableList<StencilClient.LocaleLabel>)newValue);
    }

    public final ImmutableLink withLabels(Iterable<? extends StencilClient.LocaleLabel> elements) {
        if (this.labels == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableLink(this.value, this.devMode, this.contentType, this.articles, (ImmutableList<StencilClient.LocaleLabel>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLink && this.equalTo((ImmutableLink)another);
    }

    private boolean equalTo(ImmutableLink another) {
        return this.value.equals(another.value) && Objects.equals(this.devMode, another.devMode) && this.contentType.equals(another.contentType) && this.articles.equals(another.articles) && this.labels.equals(another.labels);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + Objects.hashCode(this.devMode);
        h += (h << 5) + this.contentType.hashCode();
        h += (h << 5) + this.articles.hashCode();
        h += (h << 5) + this.labels.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Link").omitNullValues().add("value", (Object)this.value).add("devMode", (Object)this.devMode).add("contentType", (Object)this.contentType).add("articles", this.articles).add("labels", this.labels).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableLink fromJson(Json json) {
        Builder builder = ImmutableLink.builder();
        if (json.value != null) {
            builder.value(json.value);
        }
        if (json.devMode != null) {
            builder.devMode(json.devMode);
        }
        if (json.contentType != null) {
            builder.contentType(json.contentType);
        }
        if (json.articles != null) {
            builder.addAllArticles(json.articles);
        }
        if (json.labels != null) {
            builder.addAllLabels(json.labels);
        }
        return builder.build();
    }

    public static ImmutableLink copyOf(StencilClient.Link instance) {
        if (instance instanceof ImmutableLink) {
            return (ImmutableLink)instance;
        }
        return ImmutableLink.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StencilClient.Link", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VALUE = 1L;
        private static final long INIT_BIT_CONTENT_TYPE = 2L;
        private long initBits = 3L;
        @Nullable
        private String value;
        @Nullable
        private Boolean devMode;
        @Nullable
        private String contentType;
        private ImmutableList.Builder<String> articles = ImmutableList.builder();
        private ImmutableList.Builder<StencilClient.LocaleLabel> labels = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StencilClient.Link instance) {
            Objects.requireNonNull(instance, "instance");
            this.value(instance.getValue());
            Boolean devModeValue = instance.getDevMode();
            if (devModeValue != null) {
                this.devMode(devModeValue);
            }
            this.contentType(instance.getContentType());
            this.addAllArticles(instance.getArticles());
            this.addAllLabels(instance.getLabels());
            return this;
        }

        @JsonProperty(value="value")
        @CanIgnoreReturnValue
        public final Builder value(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="devMode")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @CanIgnoreReturnValue
        public final Builder devMode(@Nullable Boolean devMode) {
            this.devMode = devMode;
            return this;
        }

        @JsonProperty(value="contentType")
        @CanIgnoreReturnValue
        public final Builder contentType(String contentType) {
            this.contentType = Objects.requireNonNull(contentType, "contentType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addArticles(String element) {
            this.articles.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addArticles(String ... elements) {
            this.articles.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="articles")
        @CanIgnoreReturnValue
        public final Builder articles(Iterable<String> elements) {
            this.articles = ImmutableList.builder();
            return this.addAllArticles(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllArticles(Iterable<String> elements) {
            this.articles.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLabels(StencilClient.LocaleLabel element) {
            this.labels.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLabels(StencilClient.LocaleLabel ... elements) {
            this.labels.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="labels")
        @CanIgnoreReturnValue
        public final Builder labels(Iterable<? extends StencilClient.LocaleLabel> elements) {
            this.labels = ImmutableList.builder();
            return this.addAllLabels(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllLabels(Iterable<? extends StencilClient.LocaleLabel> elements) {
            this.labels.addAll(elements);
            return this;
        }

        public ImmutableLink build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLink(this.value, this.devMode, this.contentType, (ImmutableList<String>)this.articles.build(), (ImmutableList<StencilClient.LocaleLabel>)this.labels.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("contentType");
            }
            return "Cannot build Link, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="StencilClient.Link", generator="Immutables")
    static final class Json
    implements StencilClient.Link {
        @Nullable
        String value;
        @Nullable
        Boolean devMode;
        @Nullable
        String contentType;
        @Nullable
        List<String> articles = ImmutableList.of();
        @Nullable
        List<StencilClient.LocaleLabel> labels = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="value")
        public void setValue(String value) {
            this.value = value;
        }

        @JsonProperty(value="devMode")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public void setDevMode(@Nullable Boolean devMode) {
            this.devMode = devMode;
        }

        @JsonProperty(value="contentType")
        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @JsonProperty(value="articles")
        public void setArticles(List<String> articles) {
            this.articles = articles;
        }

        @JsonProperty(value="labels")
        public void setLabels(List<StencilClient.LocaleLabel> labels) {
            this.labels = labels;
        }

        @Override
        public String getValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getDevMode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getContentType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getArticles() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<StencilClient.LocaleLabel> getLabels() {
            throw new UnsupportedOperationException();
        }
    }
}

