package io.thestencil.client.spi.staticontent.visitors;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SiteVisitor.ImageData}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableImageData.builder()}.
 */
@Generated(from = "SiteVisitor.ImageData", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableImageData
    implements SiteVisitor.ImageData {
  private final String path;
  private final byte[] value;

  private ImmutableImageData(String path, byte[] value) {
    this.path = path;
    this.value = value;
  }

  /**
   * @return The value of the {@code path} attribute
   */
  @Override
  public String getPath() {
    return path;
  }

  /**
   * @return A cloned {@code value} array
   */
  @Override
  public byte[] getValue() {
    return value.clone();
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SiteVisitor.ImageData#getPath() path} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for path
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableImageData withPath(String value) {
    String newValue = Objects.requireNonNull(value, "path");
    if (this.path.equals(newValue)) return this;
    return new ImmutableImageData(newValue, this.value);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SiteVisitor.ImageData#getValue() value}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for value
   * @return A modified copy of {@code this} object
   */
  public final ImmutableImageData withValue(byte... elements) {
    byte[] newValue = elements.clone();
    return new ImmutableImageData(this.path, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableImageData} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableImageData
        && equalTo((ImmutableImageData) another);
  }

  private boolean equalTo(ImmutableImageData another) {
    return path.equals(another.path)
        && Arrays.equals(value, another.value);
  }

  /**
   * Computes a hash code from attributes: {@code path}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + path.hashCode();
    h += (h << 5) + Arrays.hashCode(value);
    return h;
  }

  /**
   * Prints the immutable value {@code ImageData} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ImageData")
        .omitNullValues()
        .add("path", path)
        .add("value", Arrays.toString(value))
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link SiteVisitor.ImageData} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ImageData instance
   */
  public static ImmutableImageData copyOf(SiteVisitor.ImageData instance) {
    if (instance instanceof ImmutableImageData) {
      return (ImmutableImageData) instance;
    }
    return ImmutableImageData.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableImageData ImmutableImageData}.
   * <pre>
   * ImmutableImageData.builder()
   *    .path(String) // required {@link SiteVisitor.ImageData#getPath() path}
   *    .value(byte) // required {@link SiteVisitor.ImageData#getValue() value}
   *    .build();
   * </pre>
   * @return A new ImmutableImageData builder
   */
  public static ImmutableImageData.Builder builder() {
    return new ImmutableImageData.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableImageData ImmutableImageData}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SiteVisitor.ImageData", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_PATH = 0x1L;
    private static final long INIT_BIT_VALUE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String path;
    private @Nullable byte[] value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ImageData} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SiteVisitor.ImageData instance) {
      Objects.requireNonNull(instance, "instance");
      path(instance.getPath());
      value(instance.getValue());
      return this;
    }

    /**
     * Initializes the value for the {@link SiteVisitor.ImageData#getPath() path} attribute.
     * @param path The value for path 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder path(String path) {
      this.path = Objects.requireNonNull(path, "path");
      initBits &= ~INIT_BIT_PATH;
      return this;
    }

    /**
     * Initializes the value for the {@link SiteVisitor.ImageData#getValue() value} attribute.
     * @param value The elements for value
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder value(byte... value) {
      this.value = value.clone();
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableImageData ImmutableImageData}.
     * @return An immutable instance of ImageData
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableImageData build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableImageData(path, value);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PATH) != 0) attributes.add("path");
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build ImageData, some of required attributes are not set " + attributes;
    }
  }
}
