package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link StencilClient.VersionInfo}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableVersionInfo.builder()}.
 */
@Generated(from = "StencilClient.VersionInfo", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableVersionInfo implements StencilClient.VersionInfo {
  private final String version;
  private final String date;

  private ImmutableVersionInfo(String version, String date) {
    this.version = version;
    this.date = date;
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @JsonProperty("version")
  @Override
  public String getVersion() {
    return version;
  }

  /**
   * @return The value of the {@code date} attribute
   */
  @JsonProperty("date")
  @Override
  public String getDate() {
    return date;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.VersionInfo#getVersion() version} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for version
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableVersionInfo withVersion(String value) {
    String newValue = Objects.requireNonNull(value, "version");
    if (this.version.equals(newValue)) return this;
    return new ImmutableVersionInfo(newValue, this.date);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.VersionInfo#getDate() date} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for date
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableVersionInfo withDate(String value) {
    String newValue = Objects.requireNonNull(value, "date");
    if (this.date.equals(newValue)) return this;
    return new ImmutableVersionInfo(this.version, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableVersionInfo} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableVersionInfo
        && equalTo((ImmutableVersionInfo) another);
  }

  private boolean equalTo(ImmutableVersionInfo another) {
    return version.equals(another.version)
        && date.equals(another.date);
  }

  /**
   * Computes a hash code from attributes: {@code version}, {@code date}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + version.hashCode();
    h += (h << 5) + date.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code VersionInfo} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("VersionInfo")
        .omitNullValues()
        .add("version", version)
        .add("date", date)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "StencilClient.VersionInfo", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements StencilClient.VersionInfo {
    @Nullable String version;
    @Nullable String date;
    @JsonProperty("version")
    public void setVersion(String version) {
      this.version = version;
    }
    @JsonProperty("date")
    public void setDate(String date) {
      this.date = date;
    }
    @Override
    public String getVersion() { throw new UnsupportedOperationException(); }
    @Override
    public String getDate() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableVersionInfo fromJson(Json json) {
    ImmutableVersionInfo.Builder builder = ImmutableVersionInfo.builder();
    if (json.version != null) {
      builder.version(json.version);
    }
    if (json.date != null) {
      builder.date(json.date);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link StencilClient.VersionInfo} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable VersionInfo instance
   */
  public static ImmutableVersionInfo copyOf(StencilClient.VersionInfo instance) {
    if (instance instanceof ImmutableVersionInfo) {
      return (ImmutableVersionInfo) instance;
    }
    return ImmutableVersionInfo.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableVersionInfo ImmutableVersionInfo}.
   * <pre>
   * ImmutableVersionInfo.builder()
   *    .version(String) // required {@link StencilClient.VersionInfo#getVersion() version}
   *    .date(String) // required {@link StencilClient.VersionInfo#getDate() date}
   *    .build();
   * </pre>
   * @return A new ImmutableVersionInfo builder
   */
  public static ImmutableVersionInfo.Builder builder() {
    return new ImmutableVersionInfo.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableVersionInfo ImmutableVersionInfo}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "StencilClient.VersionInfo", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_VERSION = 0x1L;
    private static final long INIT_BIT_DATE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String version;
    private @Nullable String date;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code VersionInfo} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StencilClient.VersionInfo instance) {
      Objects.requireNonNull(instance, "instance");
      version(instance.getVersion());
      date(instance.getDate());
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.VersionInfo#getVersion() version} attribute.
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("version")
    public final Builder version(String version) {
      this.version = Objects.requireNonNull(version, "version");
      initBits &= ~INIT_BIT_VERSION;
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.VersionInfo#getDate() date} attribute.
     * @param date The value for date 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("date")
    public final Builder date(String date) {
      this.date = Objects.requireNonNull(date, "date");
      initBits &= ~INIT_BIT_DATE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableVersionInfo ImmutableVersionInfo}.
     * @return An immutable instance of VersionInfo
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableVersionInfo build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableVersionInfo(version, date);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VERSION) != 0) attributes.add("version");
      if ((initBits & INIT_BIT_DATE) != 0) attributes.add("date");
      return "Cannot build VersionInfo, some of required attributes are not set " + attributes;
    }
  }
}
