package io.thestencil.client.api;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Markdowns}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMarkdowns.builder()}.
 */
@Generated(from = "Markdowns", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableMarkdowns implements Markdowns {
  private final ImmutableList<Markdowns.Markdown> values;
  private final ImmutableList<Markdowns.ImageResource> images;
  private final ImmutableList<Markdowns.LinkResource> links;
  private final ImmutableList<String> locales;

  private ImmutableMarkdowns(
      ImmutableList<Markdowns.Markdown> values,
      ImmutableList<Markdowns.ImageResource> images,
      ImmutableList<Markdowns.LinkResource> links,
      ImmutableList<String> locales) {
    this.values = values;
    this.images = images;
    this.links = links;
    this.locales = locales;
  }

  /**
   * @return The value of the {@code values} attribute
   */
  @Override
  public ImmutableList<Markdowns.Markdown> getValues() {
    return values;
  }

  /**
   * @return The value of the {@code images} attribute
   */
  @Override
  public ImmutableList<Markdowns.ImageResource> getImages() {
    return images;
  }

  /**
   * @return The value of the {@code links} attribute
   */
  @Override
  public ImmutableList<Markdowns.LinkResource> getLinks() {
    return links;
  }

  /**
   * @return The value of the {@code locales} attribute
   */
  @Override
  public ImmutableList<String> getLocales() {
    return locales;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Markdowns#getValues() values}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMarkdowns withValues(Markdowns.Markdown... elements) {
    ImmutableList<Markdowns.Markdown> newValue = ImmutableList.copyOf(elements);
    return new ImmutableMarkdowns(newValue, this.images, this.links, this.locales);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Markdowns#getValues() values}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of values elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMarkdowns withValues(Iterable<? extends Markdowns.Markdown> elements) {
    if (this.values == elements) return this;
    ImmutableList<Markdowns.Markdown> newValue = ImmutableList.copyOf(elements);
    return new ImmutableMarkdowns(newValue, this.images, this.links, this.locales);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Markdowns#getImages() images}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMarkdowns withImages(Markdowns.ImageResource... elements) {
    ImmutableList<Markdowns.ImageResource> newValue = ImmutableList.copyOf(elements);
    return new ImmutableMarkdowns(this.values, newValue, this.links, this.locales);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Markdowns#getImages() images}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of images elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMarkdowns withImages(Iterable<? extends Markdowns.ImageResource> elements) {
    if (this.images == elements) return this;
    ImmutableList<Markdowns.ImageResource> newValue = ImmutableList.copyOf(elements);
    return new ImmutableMarkdowns(this.values, newValue, this.links, this.locales);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Markdowns#getLinks() links}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMarkdowns withLinks(Markdowns.LinkResource... elements) {
    ImmutableList<Markdowns.LinkResource> newValue = ImmutableList.copyOf(elements);
    return new ImmutableMarkdowns(this.values, this.images, newValue, this.locales);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Markdowns#getLinks() links}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of links elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMarkdowns withLinks(Iterable<? extends Markdowns.LinkResource> elements) {
    if (this.links == elements) return this;
    ImmutableList<Markdowns.LinkResource> newValue = ImmutableList.copyOf(elements);
    return new ImmutableMarkdowns(this.values, this.images, newValue, this.locales);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Markdowns#getLocales() locales}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMarkdowns withLocales(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableMarkdowns(this.values, this.images, this.links, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Markdowns#getLocales() locales}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of locales elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMarkdowns withLocales(Iterable<String> elements) {
    if (this.locales == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableMarkdowns(this.values, this.images, this.links, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMarkdowns} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMarkdowns
        && equalTo((ImmutableMarkdowns) another);
  }

  private boolean equalTo(ImmutableMarkdowns another) {
    return values.equals(another.values)
        && images.equals(another.images)
        && links.equals(another.links)
        && locales.equals(another.locales);
  }

  /**
   * Computes a hash code from attributes: {@code values}, {@code images}, {@code links}, {@code locales}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + values.hashCode();
    h += (h << 5) + images.hashCode();
    h += (h << 5) + links.hashCode();
    h += (h << 5) + locales.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Markdowns} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Markdowns")
        .omitNullValues()
        .add("values", values)
        .add("images", images)
        .add("links", links)
        .add("locales", locales)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Markdowns} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Markdowns instance
   */
  public static ImmutableMarkdowns copyOf(Markdowns instance) {
    if (instance instanceof ImmutableMarkdowns) {
      return (ImmutableMarkdowns) instance;
    }
    return ImmutableMarkdowns.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMarkdowns ImmutableMarkdowns}.
   * <pre>
   * ImmutableMarkdowns.builder()
   *    .addValues|addAllValues(io.thestencil.client.api.Markdowns.Markdown) // {@link Markdowns#getValues() values} elements
   *    .addImages|addAllImages(io.thestencil.client.api.Markdowns.ImageResource) // {@link Markdowns#getImages() images} elements
   *    .addLinks|addAllLinks(io.thestencil.client.api.Markdowns.LinkResource) // {@link Markdowns#getLinks() links} elements
   *    .addLocales|addAllLocales(String) // {@link Markdowns#getLocales() locales} elements
   *    .build();
   * </pre>
   * @return A new ImmutableMarkdowns builder
   */
  public static ImmutableMarkdowns.Builder builder() {
    return new ImmutableMarkdowns.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMarkdowns ImmutableMarkdowns}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Markdowns", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableList.Builder<Markdowns.Markdown> values = ImmutableList.builder();
    private ImmutableList.Builder<Markdowns.ImageResource> images = ImmutableList.builder();
    private ImmutableList.Builder<Markdowns.LinkResource> links = ImmutableList.builder();
    private ImmutableList.Builder<String> locales = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Markdowns} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Markdowns instance) {
      Objects.requireNonNull(instance, "instance");
      addAllValues(instance.getValues());
      addAllImages(instance.getImages());
      addAllLinks(instance.getLinks());
      addAllLocales(instance.getLocales());
      return this;
    }

    /**
     * Adds one element to {@link Markdowns#getValues() values} list.
     * @param element A values element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addValues(Markdowns.Markdown element) {
      this.values.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Markdowns#getValues() values} list.
     * @param elements An array of values elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addValues(Markdowns.Markdown... elements) {
      this.values.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Markdowns#getValues() values} list.
     * @param elements An iterable of values elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder values(Iterable<? extends Markdowns.Markdown> elements) {
      this.values = ImmutableList.builder();
      return addAllValues(elements);
    }

    /**
     * Adds elements to {@link Markdowns#getValues() values} list.
     * @param elements An iterable of values elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllValues(Iterable<? extends Markdowns.Markdown> elements) {
      this.values.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link Markdowns#getImages() images} list.
     * @param element A images element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addImages(Markdowns.ImageResource element) {
      this.images.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Markdowns#getImages() images} list.
     * @param elements An array of images elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addImages(Markdowns.ImageResource... elements) {
      this.images.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Markdowns#getImages() images} list.
     * @param elements An iterable of images elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder images(Iterable<? extends Markdowns.ImageResource> elements) {
      this.images = ImmutableList.builder();
      return addAllImages(elements);
    }

    /**
     * Adds elements to {@link Markdowns#getImages() images} list.
     * @param elements An iterable of images elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllImages(Iterable<? extends Markdowns.ImageResource> elements) {
      this.images.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link Markdowns#getLinks() links} list.
     * @param element A links element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLinks(Markdowns.LinkResource element) {
      this.links.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Markdowns#getLinks() links} list.
     * @param elements An array of links elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLinks(Markdowns.LinkResource... elements) {
      this.links.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Markdowns#getLinks() links} list.
     * @param elements An iterable of links elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder links(Iterable<? extends Markdowns.LinkResource> elements) {
      this.links = ImmutableList.builder();
      return addAllLinks(elements);
    }

    /**
     * Adds elements to {@link Markdowns#getLinks() links} list.
     * @param elements An iterable of links elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllLinks(Iterable<? extends Markdowns.LinkResource> elements) {
      this.links.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link Markdowns#getLocales() locales} list.
     * @param element A locales element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLocales(String element) {
      this.locales.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Markdowns#getLocales() locales} list.
     * @param elements An array of locales elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLocales(String... elements) {
      this.locales.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Markdowns#getLocales() locales} list.
     * @param elements An iterable of locales elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder locales(Iterable<String> elements) {
      this.locales = ImmutableList.builder();
      return addAllLocales(elements);
    }

    /**
     * Adds elements to {@link Markdowns#getLocales() locales} list.
     * @param elements An iterable of locales elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllLocales(Iterable<String> elements) {
      this.locales.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableMarkdowns ImmutableMarkdowns}.
     * @return An immutable instance of Markdowns
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMarkdowns build() {
      return new ImmutableMarkdowns(values.build(), images.build(), links.build(), locales.build());
    }
  }
}
