package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link StencilClient.Link}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableLink.builder()}.
 */
@Generated(from = "StencilClient.Link", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableLink implements StencilClient.Link {
  private final String value;
  private final @Nullable Boolean devMode;
  private final String contentType;
  private final ImmutableList<String> articles;
  private final ImmutableList<StencilClient.LocaleLabel> labels;

  private ImmutableLink(
      String value,
      @Nullable Boolean devMode,
      String contentType,
      ImmutableList<String> articles,
      ImmutableList<StencilClient.LocaleLabel> labels) {
    this.value = value;
    this.devMode = devMode;
    this.contentType = contentType;
    this.articles = articles;
    this.labels = labels;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @JsonProperty("value")
  @Override
  public String getValue() {
    return value;
  }

  /**
   * @return The value of the {@code devMode} attribute
   */
  @JsonProperty("devMode")
  @JsonInclude(JsonInclude.Include.NON_NULL)
  @Override
  public @Nullable Boolean getDevMode() {
    return devMode;
  }

  /**
   * @return The value of the {@code contentType} attribute
   */
  @JsonProperty("contentType")
  @Override
  public String getContentType() {
    return contentType;
  }

  /**
   * @return The value of the {@code articles} attribute
   */
  @JsonProperty("articles")
  @Override
  public ImmutableList<String> getArticles() {
    return articles;
  }

  /**
   * @return The value of the {@code labels} attribute
   */
  @JsonProperty("labels")
  @Override
  public ImmutableList<StencilClient.LocaleLabel> getLabels() {
    return labels;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.Link#getValue() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLink withValue(String value) {
    String newValue = Objects.requireNonNull(value, "value");
    if (this.value.equals(newValue)) return this;
    return new ImmutableLink(newValue, this.devMode, this.contentType, this.articles, this.labels);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.Link#getDevMode() devMode} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for devMode (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLink withDevMode(@Nullable Boolean value) {
    if (Objects.equals(this.devMode, value)) return this;
    return new ImmutableLink(this.value, value, this.contentType, this.articles, this.labels);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.Link#getContentType() contentType} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for contentType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLink withContentType(String value) {
    String newValue = Objects.requireNonNull(value, "contentType");
    if (this.contentType.equals(newValue)) return this;
    return new ImmutableLink(this.value, this.devMode, newValue, this.articles, this.labels);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StencilClient.Link#getArticles() articles}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableLink withArticles(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableLink(this.value, this.devMode, this.contentType, newValue, this.labels);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StencilClient.Link#getArticles() articles}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of articles elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableLink withArticles(Iterable<String> elements) {
    if (this.articles == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableLink(this.value, this.devMode, this.contentType, newValue, this.labels);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StencilClient.Link#getLabels() labels}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableLink withLabels(StencilClient.LocaleLabel... elements) {
    ImmutableList<StencilClient.LocaleLabel> newValue = ImmutableList.copyOf(elements);
    return new ImmutableLink(this.value, this.devMode, this.contentType, this.articles, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StencilClient.Link#getLabels() labels}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of labels elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableLink withLabels(Iterable<? extends StencilClient.LocaleLabel> elements) {
    if (this.labels == elements) return this;
    ImmutableList<StencilClient.LocaleLabel> newValue = ImmutableList.copyOf(elements);
    return new ImmutableLink(this.value, this.devMode, this.contentType, this.articles, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableLink} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableLink
        && equalTo((ImmutableLink) another);
  }

  private boolean equalTo(ImmutableLink another) {
    return value.equals(another.value)
        && Objects.equals(devMode, another.devMode)
        && contentType.equals(another.contentType)
        && articles.equals(another.articles)
        && labels.equals(another.labels);
  }

  /**
   * Computes a hash code from attributes: {@code value}, {@code devMode}, {@code contentType}, {@code articles}, {@code labels}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + value.hashCode();
    h += (h << 5) + Objects.hashCode(devMode);
    h += (h << 5) + contentType.hashCode();
    h += (h << 5) + articles.hashCode();
    h += (h << 5) + labels.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Link} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Link")
        .omitNullValues()
        .add("value", value)
        .add("devMode", devMode)
        .add("contentType", contentType)
        .add("articles", articles)
        .add("labels", labels)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "StencilClient.Link", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements StencilClient.Link {
    @Nullable String value;
    @Nullable Boolean devMode;
    @Nullable String contentType;
    @Nullable List<String> articles = ImmutableList.of();
    @Nullable List<StencilClient.LocaleLabel> labels = ImmutableList.of();
    @JsonProperty("value")
    public void setValue(String value) {
      this.value = value;
    }
    @JsonProperty("devMode")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public void setDevMode(@Nullable Boolean devMode) {
      this.devMode = devMode;
    }
    @JsonProperty("contentType")
    public void setContentType(String contentType) {
      this.contentType = contentType;
    }
    @JsonProperty("articles")
    public void setArticles(List<String> articles) {
      this.articles = articles;
    }
    @JsonProperty("labels")
    public void setLabels(List<StencilClient.LocaleLabel> labels) {
      this.labels = labels;
    }
    @Override
    public String getValue() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getDevMode() { throw new UnsupportedOperationException(); }
    @Override
    public String getContentType() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getArticles() { throw new UnsupportedOperationException(); }
    @Override
    public List<StencilClient.LocaleLabel> getLabels() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableLink fromJson(Json json) {
    ImmutableLink.Builder builder = ImmutableLink.builder();
    if (json.value != null) {
      builder.value(json.value);
    }
    if (json.devMode != null) {
      builder.devMode(json.devMode);
    }
    if (json.contentType != null) {
      builder.contentType(json.contentType);
    }
    if (json.articles != null) {
      builder.addAllArticles(json.articles);
    }
    if (json.labels != null) {
      builder.addAllLabels(json.labels);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link StencilClient.Link} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Link instance
   */
  public static ImmutableLink copyOf(StencilClient.Link instance) {
    if (instance instanceof ImmutableLink) {
      return (ImmutableLink) instance;
    }
    return ImmutableLink.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableLink ImmutableLink}.
   * <pre>
   * ImmutableLink.builder()
   *    .value(String) // required {@link StencilClient.Link#getValue() value}
   *    .devMode(Boolean | null) // nullable {@link StencilClient.Link#getDevMode() devMode}
   *    .contentType(String) // required {@link StencilClient.Link#getContentType() contentType}
   *    .addArticles|addAllArticles(String) // {@link StencilClient.Link#getArticles() articles} elements
   *    .addLabels|addAllLabels(io.thestencil.client.api.StencilClient.LocaleLabel) // {@link StencilClient.Link#getLabels() labels} elements
   *    .build();
   * </pre>
   * @return A new ImmutableLink builder
   */
  public static ImmutableLink.Builder builder() {
    return new ImmutableLink.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableLink ImmutableLink}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "StencilClient.Link", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_VALUE = 0x1L;
    private static final long INIT_BIT_CONTENT_TYPE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String value;
    private @Nullable Boolean devMode;
    private @Nullable String contentType;
    private ImmutableList.Builder<String> articles = ImmutableList.builder();
    private ImmutableList.Builder<StencilClient.LocaleLabel> labels = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Link} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StencilClient.Link instance) {
      Objects.requireNonNull(instance, "instance");
      value(instance.getValue());
      @Nullable Boolean devModeValue = instance.getDevMode();
      if (devModeValue != null) {
        devMode(devModeValue);
      }
      contentType(instance.getContentType());
      addAllArticles(instance.getArticles());
      addAllLabels(instance.getLabels());
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.Link#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("value")
    public final Builder value(String value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.Link#getDevMode() devMode} attribute.
     * @param devMode The value for devMode (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("devMode")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public final Builder devMode(@Nullable Boolean devMode) {
      this.devMode = devMode;
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.Link#getContentType() contentType} attribute.
     * @param contentType The value for contentType 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("contentType")
    public final Builder contentType(String contentType) {
      this.contentType = Objects.requireNonNull(contentType, "contentType");
      initBits &= ~INIT_BIT_CONTENT_TYPE;
      return this;
    }

    /**
     * Adds one element to {@link StencilClient.Link#getArticles() articles} list.
     * @param element A articles element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addArticles(String element) {
      this.articles.add(element);
      return this;
    }

    /**
     * Adds elements to {@link StencilClient.Link#getArticles() articles} list.
     * @param elements An array of articles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addArticles(String... elements) {
      this.articles.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link StencilClient.Link#getArticles() articles} list.
     * @param elements An iterable of articles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("articles")
    public final Builder articles(Iterable<String> elements) {
      this.articles = ImmutableList.builder();
      return addAllArticles(elements);
    }

    /**
     * Adds elements to {@link StencilClient.Link#getArticles() articles} list.
     * @param elements An iterable of articles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllArticles(Iterable<String> elements) {
      this.articles.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link StencilClient.Link#getLabels() labels} list.
     * @param element A labels element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLabels(StencilClient.LocaleLabel element) {
      this.labels.add(element);
      return this;
    }

    /**
     * Adds elements to {@link StencilClient.Link#getLabels() labels} list.
     * @param elements An array of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLabels(StencilClient.LocaleLabel... elements) {
      this.labels.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link StencilClient.Link#getLabels() labels} list.
     * @param elements An iterable of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("labels")
    public final Builder labels(Iterable<? extends StencilClient.LocaleLabel> elements) {
      this.labels = ImmutableList.builder();
      return addAllLabels(elements);
    }

    /**
     * Adds elements to {@link StencilClient.Link#getLabels() labels} list.
     * @param elements An iterable of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllLabels(Iterable<? extends StencilClient.LocaleLabel> elements) {
      this.labels.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableLink ImmutableLink}.
     * @return An immutable instance of Link
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableLink build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableLink(value, devMode, contentType, articles.build(), labels.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      if ((initBits & INIT_BIT_CONTENT_TYPE) != 0) attributes.add("contentType");
      return "Cannot build Link, some of required attributes are not set " + attributes;
    }
  }
}
