package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CreateBuilder.CreateTemplate}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCreateTemplate.builder()}.
 */
@Generated(from = "CreateBuilder.CreateTemplate", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCreateTemplate implements CreateBuilder.CreateTemplate {
  private final @Nullable String id;
  private final String name;
  private final String description;
  private final String content;
  private final String type;

  private ImmutableCreateTemplate(
      @Nullable String id,
      String name,
      String description,
      String content,
      String type) {
    this.id = id;
    this.name = name;
    this.description = description;
    this.content = content;
    this.type = type;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public @Nullable String getId() {
    return id;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @Override
  public String getDescription() {
    return description;
  }

  /**
   * @return The value of the {@code content} attribute
   */
  @JsonProperty("content")
  @Override
  public String getContent() {
    return content;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public String getType() {
    return type;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CreateBuilder.CreateTemplate#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCreateTemplate withId(@Nullable String value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableCreateTemplate(value, this.name, this.description, this.content, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CreateBuilder.CreateTemplate#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCreateTemplate withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableCreateTemplate(this.id, newValue, this.description, this.content, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CreateBuilder.CreateTemplate#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCreateTemplate withDescription(String value) {
    String newValue = Objects.requireNonNull(value, "description");
    if (this.description.equals(newValue)) return this;
    return new ImmutableCreateTemplate(this.id, this.name, newValue, this.content, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CreateBuilder.CreateTemplate#getContent() content} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for content
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCreateTemplate withContent(String value) {
    String newValue = Objects.requireNonNull(value, "content");
    if (this.content.equals(newValue)) return this;
    return new ImmutableCreateTemplate(this.id, this.name, this.description, newValue, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CreateBuilder.CreateTemplate#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCreateTemplate withType(String value) {
    String newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableCreateTemplate(this.id, this.name, this.description, this.content, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCreateTemplate} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCreateTemplate
        && equalTo((ImmutableCreateTemplate) another);
  }

  private boolean equalTo(ImmutableCreateTemplate another) {
    return Objects.equals(id, another.id)
        && name.equals(another.name)
        && description.equals(another.description)
        && content.equals(another.content)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code name}, {@code description}, {@code content}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + description.hashCode();
    h += (h << 5) + content.hashCode();
    h += (h << 5) + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CreateTemplate} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CreateTemplate")
        .omitNullValues()
        .add("id", id)
        .add("name", name)
        .add("description", description)
        .add("content", content)
        .add("type", type)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "CreateBuilder.CreateTemplate", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements CreateBuilder.CreateTemplate {
    @Nullable String id;
    @Nullable String name;
    @Nullable String description;
    @Nullable String content;
    @Nullable String type;
    @JsonProperty("id")
    public void setId(@Nullable String id) {
      this.id = id;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("description")
    public void setDescription(String description) {
      this.description = description;
    }
    @JsonProperty("content")
    public void setContent(String content) {
      this.content = content;
    }
    @JsonProperty("type")
    public void setType(String type) {
      this.type = type;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public String getContent() { throw new UnsupportedOperationException(); }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableCreateTemplate fromJson(Json json) {
    ImmutableCreateTemplate.Builder builder = ImmutableCreateTemplate.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.content != null) {
      builder.content(json.content);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link CreateBuilder.CreateTemplate} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CreateTemplate instance
   */
  public static ImmutableCreateTemplate copyOf(CreateBuilder.CreateTemplate instance) {
    if (instance instanceof ImmutableCreateTemplate) {
      return (ImmutableCreateTemplate) instance;
    }
    return ImmutableCreateTemplate.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCreateTemplate ImmutableCreateTemplate}.
   * <pre>
   * ImmutableCreateTemplate.builder()
   *    .id(String | null) // nullable {@link CreateBuilder.CreateTemplate#getId() id}
   *    .name(String) // required {@link CreateBuilder.CreateTemplate#getName() name}
   *    .description(String) // required {@link CreateBuilder.CreateTemplate#getDescription() description}
   *    .content(String) // required {@link CreateBuilder.CreateTemplate#getContent() content}
   *    .type(String) // required {@link CreateBuilder.CreateTemplate#getType() type}
   *    .build();
   * </pre>
   * @return A new ImmutableCreateTemplate builder
   */
  public static ImmutableCreateTemplate.Builder builder() {
    return new ImmutableCreateTemplate.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCreateTemplate ImmutableCreateTemplate}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CreateBuilder.CreateTemplate", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_DESCRIPTION = 0x2L;
    private static final long INIT_BIT_CONTENT = 0x4L;
    private static final long INIT_BIT_TYPE = 0x8L;
    private long initBits = 0xfL;

    private @Nullable String id;
    private @Nullable String name;
    private @Nullable String description;
    private @Nullable String content;
    private @Nullable String type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateTemplate} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CreateBuilder.CreateTemplate instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String idValue = instance.getId();
      if (idValue != null) {
        id(idValue);
      }
      name(instance.getName());
      description(instance.getDescription());
      content(instance.getContent());
      type(instance.getType());
      return this;
    }

    /**
     * Initializes the value for the {@link CreateBuilder.CreateTemplate#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateBuilder.CreateTemplate#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateBuilder.CreateTemplate#getDescription() description} attribute.
     * @param description The value for description 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("description")
    public final Builder description(String description) {
      this.description = Objects.requireNonNull(description, "description");
      initBits &= ~INIT_BIT_DESCRIPTION;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateBuilder.CreateTemplate#getContent() content} attribute.
     * @param content The value for content 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("content")
    public final Builder content(String content) {
      this.content = Objects.requireNonNull(content, "content");
      initBits &= ~INIT_BIT_CONTENT;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateBuilder.CreateTemplate#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("type")
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableCreateTemplate ImmutableCreateTemplate}.
     * @return An immutable instance of CreateTemplate
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCreateTemplate build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCreateTemplate(id, name, description, content, type);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_DESCRIPTION) != 0) attributes.add("description");
      if ((initBits & INIT_BIT_CONTENT) != 0) attributes.add("content");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build CreateTemplate, some of required attributes are not set " + attributes;
    }
  }
}
