package io.thestencil.client.spi.staticontent.visitors;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.thestencil.client.api.MigrationBuilder;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SiteVisitor.SiteVisitorOutput}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSiteVisitorOutput.builder()}.
 */
@Generated(from = "SiteVisitor.SiteVisitorOutput", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSiteVisitorOutput
    implements SiteVisitor.SiteVisitorOutput {
  private final ImmutableList<SiteVisitor.Message> message;
  private final ImmutableList<MigrationBuilder.LocalizedSite> sites;

  private ImmutableSiteVisitorOutput(
      ImmutableList<SiteVisitor.Message> message,
      ImmutableList<MigrationBuilder.LocalizedSite> sites) {
    this.message = message;
    this.sites = sites;
  }

  /**
   * @return The value of the {@code message} attribute
   */
  @Override
  public ImmutableList<SiteVisitor.Message> getMessage() {
    return message;
  }

  /**
   * @return The value of the {@code sites} attribute
   */
  @Override
  public ImmutableList<MigrationBuilder.LocalizedSite> getSites() {
    return sites;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SiteVisitor.SiteVisitorOutput#getMessage() message}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSiteVisitorOutput withMessage(SiteVisitor.Message... elements) {
    ImmutableList<SiteVisitor.Message> newValue = ImmutableList.copyOf(elements);
    return new ImmutableSiteVisitorOutput(newValue, this.sites);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SiteVisitor.SiteVisitorOutput#getMessage() message}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of message elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSiteVisitorOutput withMessage(Iterable<? extends SiteVisitor.Message> elements) {
    if (this.message == elements) return this;
    ImmutableList<SiteVisitor.Message> newValue = ImmutableList.copyOf(elements);
    return new ImmutableSiteVisitorOutput(newValue, this.sites);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SiteVisitor.SiteVisitorOutput#getSites() sites}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSiteVisitorOutput withSites(MigrationBuilder.LocalizedSite... elements) {
    ImmutableList<MigrationBuilder.LocalizedSite> newValue = ImmutableList.copyOf(elements);
    return new ImmutableSiteVisitorOutput(this.message, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SiteVisitor.SiteVisitorOutput#getSites() sites}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of sites elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSiteVisitorOutput withSites(Iterable<? extends MigrationBuilder.LocalizedSite> elements) {
    if (this.sites == elements) return this;
    ImmutableList<MigrationBuilder.LocalizedSite> newValue = ImmutableList.copyOf(elements);
    return new ImmutableSiteVisitorOutput(this.message, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSiteVisitorOutput} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSiteVisitorOutput
        && equalTo((ImmutableSiteVisitorOutput) another);
  }

  private boolean equalTo(ImmutableSiteVisitorOutput another) {
    return message.equals(another.message)
        && sites.equals(another.sites);
  }

  /**
   * Computes a hash code from attributes: {@code message}, {@code sites}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + message.hashCode();
    h += (h << 5) + sites.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SiteVisitorOutput} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SiteVisitorOutput")
        .omitNullValues()
        .add("message", message)
        .add("sites", sites)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link SiteVisitor.SiteVisitorOutput} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SiteVisitorOutput instance
   */
  public static ImmutableSiteVisitorOutput copyOf(SiteVisitor.SiteVisitorOutput instance) {
    if (instance instanceof ImmutableSiteVisitorOutput) {
      return (ImmutableSiteVisitorOutput) instance;
    }
    return ImmutableSiteVisitorOutput.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSiteVisitorOutput ImmutableSiteVisitorOutput}.
   * <pre>
   * ImmutableSiteVisitorOutput.builder()
   *    .addMessage|addAllMessage(io.thestencil.client.spi.staticontent.visitors.SiteVisitor.Message) // {@link SiteVisitor.SiteVisitorOutput#getMessage() message} elements
   *    .addSites|addAllSites(io.thestencil.client.api.MigrationBuilder.LocalizedSite) // {@link SiteVisitor.SiteVisitorOutput#getSites() sites} elements
   *    .build();
   * </pre>
   * @return A new ImmutableSiteVisitorOutput builder
   */
  public static ImmutableSiteVisitorOutput.Builder builder() {
    return new ImmutableSiteVisitorOutput.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSiteVisitorOutput ImmutableSiteVisitorOutput}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SiteVisitor.SiteVisitorOutput", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableList.Builder<SiteVisitor.Message> message = ImmutableList.builder();
    private ImmutableList.Builder<MigrationBuilder.LocalizedSite> sites = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SiteVisitorOutput} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SiteVisitor.SiteVisitorOutput instance) {
      Objects.requireNonNull(instance, "instance");
      addAllMessage(instance.getMessage());
      addAllSites(instance.getSites());
      return this;
    }

    /**
     * Adds one element to {@link SiteVisitor.SiteVisitorOutput#getMessage() message} list.
     * @param element A message element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addMessage(SiteVisitor.Message element) {
      this.message.add(element);
      return this;
    }

    /**
     * Adds elements to {@link SiteVisitor.SiteVisitorOutput#getMessage() message} list.
     * @param elements An array of message elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addMessage(SiteVisitor.Message... elements) {
      this.message.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link SiteVisitor.SiteVisitorOutput#getMessage() message} list.
     * @param elements An iterable of message elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder message(Iterable<? extends SiteVisitor.Message> elements) {
      this.message = ImmutableList.builder();
      return addAllMessage(elements);
    }

    /**
     * Adds elements to {@link SiteVisitor.SiteVisitorOutput#getMessage() message} list.
     * @param elements An iterable of message elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllMessage(Iterable<? extends SiteVisitor.Message> elements) {
      this.message.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link SiteVisitor.SiteVisitorOutput#getSites() sites} list.
     * @param element A sites element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addSites(MigrationBuilder.LocalizedSite element) {
      this.sites.add(element);
      return this;
    }

    /**
     * Adds elements to {@link SiteVisitor.SiteVisitorOutput#getSites() sites} list.
     * @param elements An array of sites elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addSites(MigrationBuilder.LocalizedSite... elements) {
      this.sites.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link SiteVisitor.SiteVisitorOutput#getSites() sites} list.
     * @param elements An iterable of sites elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder sites(Iterable<? extends MigrationBuilder.LocalizedSite> elements) {
      this.sites = ImmutableList.builder();
      return addAllSites(elements);
    }

    /**
     * Adds elements to {@link SiteVisitor.SiteVisitorOutput#getSites() sites} list.
     * @param elements An iterable of sites elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllSites(Iterable<? extends MigrationBuilder.LocalizedSite> elements) {
      this.sites.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableSiteVisitorOutput ImmutableSiteVisitorOutput}.
     * @return An immutable instance of SiteVisitorOutput
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSiteVisitorOutput build() {
      return new ImmutableSiteVisitorOutput(message.build(), sites.build());
    }
  }
}
