package io.thestencil.client.spi.staticontent.visitors;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SiteVisitor.Message}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMessage.builder()}.
 */
@Generated(from = "SiteVisitor.Message", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableMessage
    implements SiteVisitor.Message {
  private final String text;
  private final @Nullable Object object;

  private ImmutableMessage(String text, @Nullable Object object) {
    this.text = text;
    this.object = object;
  }

  /**
   * @return The value of the {@code text} attribute
   */
  @Override
  public String getText() {
    return text;
  }

  /**
   * @return The value of the {@code object} attribute
   */
  @Override
  public @Nullable Object getObject() {
    return object;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SiteVisitor.Message#getText() text} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for text
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMessage withText(String value) {
    String newValue = Objects.requireNonNull(value, "text");
    if (this.text.equals(newValue)) return this;
    return new ImmutableMessage(newValue, this.object);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SiteVisitor.Message#getObject() object} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for object (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMessage withObject(@Nullable Object value) {
    if (this.object == value) return this;
    return new ImmutableMessage(this.text, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMessage} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMessage
        && equalTo((ImmutableMessage) another);
  }

  private boolean equalTo(ImmutableMessage another) {
    return text.equals(another.text)
        && Objects.equals(object, another.object);
  }

  /**
   * Computes a hash code from attributes: {@code text}, {@code object}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + text.hashCode();
    h += (h << 5) + Objects.hashCode(object);
    return h;
  }

  /**
   * Prints the immutable value {@code Message} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Message")
        .omitNullValues()
        .add("text", text)
        .add("object", object)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link SiteVisitor.Message} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Message instance
   */
  public static ImmutableMessage copyOf(SiteVisitor.Message instance) {
    if (instance instanceof ImmutableMessage) {
      return (ImmutableMessage) instance;
    }
    return ImmutableMessage.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMessage ImmutableMessage}.
   * <pre>
   * ImmutableMessage.builder()
   *    .text(String) // required {@link SiteVisitor.Message#getText() text}
   *    .object(Object | null) // nullable {@link SiteVisitor.Message#getObject() object}
   *    .build();
   * </pre>
   * @return A new ImmutableMessage builder
   */
  public static ImmutableMessage.Builder builder() {
    return new ImmutableMessage.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMessage ImmutableMessage}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SiteVisitor.Message", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TEXT = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String text;
    private @Nullable Object object;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Message} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SiteVisitor.Message instance) {
      Objects.requireNonNull(instance, "instance");
      text(instance.getText());
      @Nullable Object objectValue = instance.getObject();
      if (objectValue != null) {
        object(objectValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link SiteVisitor.Message#getText() text} attribute.
     * @param text The value for text 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder text(String text) {
      this.text = Objects.requireNonNull(text, "text");
      initBits &= ~INIT_BIT_TEXT;
      return this;
    }

    /**
     * Initializes the value for the {@link SiteVisitor.Message#getObject() object} attribute.
     * @param object The value for object (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder object(@Nullable Object object) {
      this.object = object;
      return this;
    }

    /**
     * Builds a new {@link ImmutableMessage ImmutableMessage}.
     * @return An immutable instance of Message
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMessage build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableMessage(text, object);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TEXT) != 0) attributes.add("text");
      return "Cannot build Message, some of required attributes are not set " + attributes;
    }
  }
}
