package io.thestencil.client.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.resys.thena.docdb.api.DocDB;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link StencilConfig}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableStencilConfig.builder()}.
 */
@Generated(from = "StencilConfig", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableStencilConfig implements StencilConfig {
  private final DocDB client;
  private final String repoName;
  private final String headName;
  private final StencilConfig.AuthorProvider authorProvider;
  private final ObjectMapper objectMapper;
  private final StencilConfig.Serializer serializer;
  private final StencilConfig.Deserializer deserializer;
  private final StencilConfig.GidProvider gidProvider;

  private ImmutableStencilConfig(
      DocDB client,
      String repoName,
      String headName,
      StencilConfig.AuthorProvider authorProvider,
      ObjectMapper objectMapper,
      StencilConfig.Serializer serializer,
      StencilConfig.Deserializer deserializer,
      StencilConfig.GidProvider gidProvider) {
    this.client = client;
    this.repoName = repoName;
    this.headName = headName;
    this.authorProvider = authorProvider;
    this.objectMapper = objectMapper;
    this.serializer = serializer;
    this.deserializer = deserializer;
    this.gidProvider = gidProvider;
  }

  /**
   * @return The value of the {@code client} attribute
   */
  @Override
  public DocDB getClient() {
    return client;
  }

  /**
   * @return The value of the {@code repoName} attribute
   */
  @Override
  public String getRepoName() {
    return repoName;
  }

  /**
   * @return The value of the {@code headName} attribute
   */
  @Override
  public String getHeadName() {
    return headName;
  }

  /**
   * @return The value of the {@code authorProvider} attribute
   */
  @Override
  public StencilConfig.AuthorProvider getAuthorProvider() {
    return authorProvider;
  }

  /**
   * @return The value of the {@code objectMapper} attribute
   */
  @Override
  public ObjectMapper getObjectMapper() {
    return objectMapper;
  }

  /**
   * @return The value of the {@code serializer} attribute
   */
  @Override
  public StencilConfig.Serializer getSerializer() {
    return serializer;
  }

  /**
   * @return The value of the {@code deserializer} attribute
   */
  @Override
  public StencilConfig.Deserializer getDeserializer() {
    return deserializer;
  }

  /**
   * @return The value of the {@code gidProvider} attribute
   */
  @Override
  public StencilConfig.GidProvider getGidProvider() {
    return gidProvider;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilConfig#getClient() client} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for client
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStencilConfig withClient(DocDB value) {
    if (this.client == value) return this;
    DocDB newValue = Objects.requireNonNull(value, "client");
    return new ImmutableStencilConfig(
        newValue,
        this.repoName,
        this.headName,
        this.authorProvider,
        this.objectMapper,
        this.serializer,
        this.deserializer,
        this.gidProvider);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilConfig#getRepoName() repoName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for repoName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStencilConfig withRepoName(String value) {
    String newValue = Objects.requireNonNull(value, "repoName");
    if (this.repoName.equals(newValue)) return this;
    return new ImmutableStencilConfig(
        this.client,
        newValue,
        this.headName,
        this.authorProvider,
        this.objectMapper,
        this.serializer,
        this.deserializer,
        this.gidProvider);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilConfig#getHeadName() headName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for headName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStencilConfig withHeadName(String value) {
    String newValue = Objects.requireNonNull(value, "headName");
    if (this.headName.equals(newValue)) return this;
    return new ImmutableStencilConfig(
        this.client,
        this.repoName,
        newValue,
        this.authorProvider,
        this.objectMapper,
        this.serializer,
        this.deserializer,
        this.gidProvider);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilConfig#getAuthorProvider() authorProvider} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for authorProvider
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStencilConfig withAuthorProvider(StencilConfig.AuthorProvider value) {
    if (this.authorProvider == value) return this;
    StencilConfig.AuthorProvider newValue = Objects.requireNonNull(value, "authorProvider");
    return new ImmutableStencilConfig(
        this.client,
        this.repoName,
        this.headName,
        newValue,
        this.objectMapper,
        this.serializer,
        this.deserializer,
        this.gidProvider);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilConfig#getObjectMapper() objectMapper} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for objectMapper
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStencilConfig withObjectMapper(ObjectMapper value) {
    if (this.objectMapper == value) return this;
    ObjectMapper newValue = Objects.requireNonNull(value, "objectMapper");
    return new ImmutableStencilConfig(
        this.client,
        this.repoName,
        this.headName,
        this.authorProvider,
        newValue,
        this.serializer,
        this.deserializer,
        this.gidProvider);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilConfig#getSerializer() serializer} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for serializer
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStencilConfig withSerializer(StencilConfig.Serializer value) {
    if (this.serializer == value) return this;
    StencilConfig.Serializer newValue = Objects.requireNonNull(value, "serializer");
    return new ImmutableStencilConfig(
        this.client,
        this.repoName,
        this.headName,
        this.authorProvider,
        this.objectMapper,
        newValue,
        this.deserializer,
        this.gidProvider);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilConfig#getDeserializer() deserializer} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for deserializer
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStencilConfig withDeserializer(StencilConfig.Deserializer value) {
    if (this.deserializer == value) return this;
    StencilConfig.Deserializer newValue = Objects.requireNonNull(value, "deserializer");
    return new ImmutableStencilConfig(
        this.client,
        this.repoName,
        this.headName,
        this.authorProvider,
        this.objectMapper,
        this.serializer,
        newValue,
        this.gidProvider);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilConfig#getGidProvider() gidProvider} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for gidProvider
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStencilConfig withGidProvider(StencilConfig.GidProvider value) {
    if (this.gidProvider == value) return this;
    StencilConfig.GidProvider newValue = Objects.requireNonNull(value, "gidProvider");
    return new ImmutableStencilConfig(
        this.client,
        this.repoName,
        this.headName,
        this.authorProvider,
        this.objectMapper,
        this.serializer,
        this.deserializer,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableStencilConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableStencilConfig
        && equalTo((ImmutableStencilConfig) another);
  }

  private boolean equalTo(ImmutableStencilConfig another) {
    return client.equals(another.client)
        && repoName.equals(another.repoName)
        && headName.equals(another.headName)
        && authorProvider.equals(another.authorProvider)
        && objectMapper.equals(another.objectMapper)
        && serializer.equals(another.serializer)
        && deserializer.equals(another.deserializer)
        && gidProvider.equals(another.gidProvider);
  }

  /**
   * Computes a hash code from attributes: {@code client}, {@code repoName}, {@code headName}, {@code authorProvider}, {@code objectMapper}, {@code serializer}, {@code deserializer}, {@code gidProvider}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + client.hashCode();
    h += (h << 5) + repoName.hashCode();
    h += (h << 5) + headName.hashCode();
    h += (h << 5) + authorProvider.hashCode();
    h += (h << 5) + objectMapper.hashCode();
    h += (h << 5) + serializer.hashCode();
    h += (h << 5) + deserializer.hashCode();
    h += (h << 5) + gidProvider.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code StencilConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("StencilConfig")
        .omitNullValues()
        .add("client", client)
        .add("repoName", repoName)
        .add("headName", headName)
        .add("authorProvider", authorProvider)
        .add("objectMapper", objectMapper)
        .add("serializer", serializer)
        .add("deserializer", deserializer)
        .add("gidProvider", gidProvider)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link StencilConfig} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable StencilConfig instance
   */
  public static ImmutableStencilConfig copyOf(StencilConfig instance) {
    if (instance instanceof ImmutableStencilConfig) {
      return (ImmutableStencilConfig) instance;
    }
    return ImmutableStencilConfig.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableStencilConfig ImmutableStencilConfig}.
   * <pre>
   * ImmutableStencilConfig.builder()
   *    .client(io.resys.thena.docdb.api.DocDB) // required {@link StencilConfig#getClient() client}
   *    .repoName(String) // required {@link StencilConfig#getRepoName() repoName}
   *    .headName(String) // required {@link StencilConfig#getHeadName() headName}
   *    .authorProvider(io.thestencil.client.api.StencilConfig.AuthorProvider) // required {@link StencilConfig#getAuthorProvider() authorProvider}
   *    .objectMapper(com.fasterxml.jackson.databind.ObjectMapper) // required {@link StencilConfig#getObjectMapper() objectMapper}
   *    .serializer(io.thestencil.client.api.StencilConfig.Serializer) // required {@link StencilConfig#getSerializer() serializer}
   *    .deserializer(io.thestencil.client.api.StencilConfig.Deserializer) // required {@link StencilConfig#getDeserializer() deserializer}
   *    .gidProvider(io.thestencil.client.api.StencilConfig.GidProvider) // required {@link StencilConfig#getGidProvider() gidProvider}
   *    .build();
   * </pre>
   * @return A new ImmutableStencilConfig builder
   */
  public static ImmutableStencilConfig.Builder builder() {
    return new ImmutableStencilConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableStencilConfig ImmutableStencilConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "StencilConfig", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CLIENT = 0x1L;
    private static final long INIT_BIT_REPO_NAME = 0x2L;
    private static final long INIT_BIT_HEAD_NAME = 0x4L;
    private static final long INIT_BIT_AUTHOR_PROVIDER = 0x8L;
    private static final long INIT_BIT_OBJECT_MAPPER = 0x10L;
    private static final long INIT_BIT_SERIALIZER = 0x20L;
    private static final long INIT_BIT_DESERIALIZER = 0x40L;
    private static final long INIT_BIT_GID_PROVIDER = 0x80L;
    private long initBits = 0xffL;

    private @Nullable DocDB client;
    private @Nullable String repoName;
    private @Nullable String headName;
    private @Nullable StencilConfig.AuthorProvider authorProvider;
    private @Nullable ObjectMapper objectMapper;
    private @Nullable StencilConfig.Serializer serializer;
    private @Nullable StencilConfig.Deserializer deserializer;
    private @Nullable StencilConfig.GidProvider gidProvider;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code StencilConfig} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StencilConfig instance) {
      Objects.requireNonNull(instance, "instance");
      client(instance.getClient());
      repoName(instance.getRepoName());
      headName(instance.getHeadName());
      authorProvider(instance.getAuthorProvider());
      objectMapper(instance.getObjectMapper());
      serializer(instance.getSerializer());
      deserializer(instance.getDeserializer());
      gidProvider(instance.getGidProvider());
      return this;
    }

    /**
     * Initializes the value for the {@link StencilConfig#getClient() client} attribute.
     * @param client The value for client 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder client(DocDB client) {
      this.client = Objects.requireNonNull(client, "client");
      initBits &= ~INIT_BIT_CLIENT;
      return this;
    }

    /**
     * Initializes the value for the {@link StencilConfig#getRepoName() repoName} attribute.
     * @param repoName The value for repoName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder repoName(String repoName) {
      this.repoName = Objects.requireNonNull(repoName, "repoName");
      initBits &= ~INIT_BIT_REPO_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link StencilConfig#getHeadName() headName} attribute.
     * @param headName The value for headName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder headName(String headName) {
      this.headName = Objects.requireNonNull(headName, "headName");
      initBits &= ~INIT_BIT_HEAD_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link StencilConfig#getAuthorProvider() authorProvider} attribute.
     * @param authorProvider The value for authorProvider 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder authorProvider(StencilConfig.AuthorProvider authorProvider) {
      this.authorProvider = Objects.requireNonNull(authorProvider, "authorProvider");
      initBits &= ~INIT_BIT_AUTHOR_PROVIDER;
      return this;
    }

    /**
     * Initializes the value for the {@link StencilConfig#getObjectMapper() objectMapper} attribute.
     * @param objectMapper The value for objectMapper 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder objectMapper(ObjectMapper objectMapper) {
      this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper");
      initBits &= ~INIT_BIT_OBJECT_MAPPER;
      return this;
    }

    /**
     * Initializes the value for the {@link StencilConfig#getSerializer() serializer} attribute.
     * @param serializer The value for serializer 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder serializer(StencilConfig.Serializer serializer) {
      this.serializer = Objects.requireNonNull(serializer, "serializer");
      initBits &= ~INIT_BIT_SERIALIZER;
      return this;
    }

    /**
     * Initializes the value for the {@link StencilConfig#getDeserializer() deserializer} attribute.
     * @param deserializer The value for deserializer 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder deserializer(StencilConfig.Deserializer deserializer) {
      this.deserializer = Objects.requireNonNull(deserializer, "deserializer");
      initBits &= ~INIT_BIT_DESERIALIZER;
      return this;
    }

    /**
     * Initializes the value for the {@link StencilConfig#getGidProvider() gidProvider} attribute.
     * @param gidProvider The value for gidProvider 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder gidProvider(StencilConfig.GidProvider gidProvider) {
      this.gidProvider = Objects.requireNonNull(gidProvider, "gidProvider");
      initBits &= ~INIT_BIT_GID_PROVIDER;
      return this;
    }

    /**
     * Builds a new {@link ImmutableStencilConfig ImmutableStencilConfig}.
     * @return An immutable instance of StencilConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableStencilConfig build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableStencilConfig(
          client,
          repoName,
          headName,
          authorProvider,
          objectMapper,
          serializer,
          deserializer,
          gidProvider);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CLIENT) != 0) attributes.add("client");
      if ((initBits & INIT_BIT_REPO_NAME) != 0) attributes.add("repoName");
      if ((initBits & INIT_BIT_HEAD_NAME) != 0) attributes.add("headName");
      if ((initBits & INIT_BIT_AUTHOR_PROVIDER) != 0) attributes.add("authorProvider");
      if ((initBits & INIT_BIT_OBJECT_MAPPER) != 0) attributes.add("objectMapper");
      if ((initBits & INIT_BIT_SERIALIZER) != 0) attributes.add("serializer");
      if ((initBits & INIT_BIT_DESERIALIZER) != 0) attributes.add("deserializer");
      if ((initBits & INIT_BIT_GID_PROVIDER) != 0) attributes.add("gidProvider");
      return "Cannot build StencilConfig, some of required attributes are not set " + attributes;
    }
  }
}
