package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CreateBuilder.CreateLocale}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCreateLocale.builder()}.
 */
@Generated(from = "CreateBuilder.CreateLocale", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCreateLocale implements CreateBuilder.CreateLocale {
  private final @Nullable String id;
  private final String locale;

  private ImmutableCreateLocale(@Nullable String id, String locale) {
    this.id = id;
    this.locale = locale;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public @Nullable String getId() {
    return id;
  }

  /**
   * @return The value of the {@code locale} attribute
   */
  @JsonProperty("locale")
  @Override
  public String getLocale() {
    return locale;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CreateBuilder.CreateLocale#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCreateLocale withId(@Nullable String value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableCreateLocale(value, this.locale);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CreateBuilder.CreateLocale#getLocale() locale} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for locale
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCreateLocale withLocale(String value) {
    String newValue = Objects.requireNonNull(value, "locale");
    if (this.locale.equals(newValue)) return this;
    return new ImmutableCreateLocale(this.id, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCreateLocale} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCreateLocale
        && equalTo((ImmutableCreateLocale) another);
  }

  private boolean equalTo(ImmutableCreateLocale another) {
    return Objects.equals(id, another.id)
        && locale.equals(another.locale);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code locale}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + locale.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CreateLocale} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CreateLocale")
        .omitNullValues()
        .add("id", id)
        .add("locale", locale)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "CreateBuilder.CreateLocale", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements CreateBuilder.CreateLocale {
    @Nullable String id;
    @Nullable String locale;
    @JsonProperty("id")
    public void setId(@Nullable String id) {
      this.id = id;
    }
    @JsonProperty("locale")
    public void setLocale(String locale) {
      this.locale = locale;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getLocale() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableCreateLocale fromJson(Json json) {
    ImmutableCreateLocale.Builder builder = ImmutableCreateLocale.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.locale != null) {
      builder.locale(json.locale);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link CreateBuilder.CreateLocale} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CreateLocale instance
   */
  public static ImmutableCreateLocale copyOf(CreateBuilder.CreateLocale instance) {
    if (instance instanceof ImmutableCreateLocale) {
      return (ImmutableCreateLocale) instance;
    }
    return ImmutableCreateLocale.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCreateLocale ImmutableCreateLocale}.
   * <pre>
   * ImmutableCreateLocale.builder()
   *    .id(String | null) // nullable {@link CreateBuilder.CreateLocale#getId() id}
   *    .locale(String) // required {@link CreateBuilder.CreateLocale#getLocale() locale}
   *    .build();
   * </pre>
   * @return A new ImmutableCreateLocale builder
   */
  public static ImmutableCreateLocale.Builder builder() {
    return new ImmutableCreateLocale.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCreateLocale ImmutableCreateLocale}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CreateBuilder.CreateLocale", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_LOCALE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String id;
    private @Nullable String locale;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateLocale} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CreateBuilder.CreateLocale instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String idValue = instance.getId();
      if (idValue != null) {
        id(idValue);
      }
      locale(instance.getLocale());
      return this;
    }

    /**
     * Initializes the value for the {@link CreateBuilder.CreateLocale#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateBuilder.CreateLocale#getLocale() locale} attribute.
     * @param locale The value for locale 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("locale")
    public final Builder locale(String locale) {
      this.locale = Objects.requireNonNull(locale, "locale");
      initBits &= ~INIT_BIT_LOCALE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableCreateLocale ImmutableCreateLocale}.
     * @return An immutable instance of CreateLocale
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCreateLocale build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCreateLocale(id, locale);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_LOCALE) != 0) attributes.add("locale");
      return "Cannot build CreateLocale, some of required attributes are not set " + attributes;
    }
  }
}
