package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CreateBuilder.BatchSite}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableBatchSite.builder()}.
 */
@Generated(from = "CreateBuilder.BatchSite", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableBatchSite implements CreateBuilder.BatchSite {
  private final ImmutableList<CreateBuilder.CreateLocale> locales;
  private final ImmutableList<CreateBuilder.CreatePage> pages;
  private final ImmutableList<CreateBuilder.CreateArticle> articles;
  private final ImmutableList<CreateBuilder.CreateWorkflow> workflows;
  private final ImmutableList<CreateBuilder.CreateLink> links;

  private ImmutableBatchSite(
      ImmutableList<CreateBuilder.CreateLocale> locales,
      ImmutableList<CreateBuilder.CreatePage> pages,
      ImmutableList<CreateBuilder.CreateArticle> articles,
      ImmutableList<CreateBuilder.CreateWorkflow> workflows,
      ImmutableList<CreateBuilder.CreateLink> links) {
    this.locales = locales;
    this.pages = pages;
    this.articles = articles;
    this.workflows = workflows;
    this.links = links;
  }

  /**
   * @return The value of the {@code locales} attribute
   */
  @JsonProperty("locales")
  @Override
  public ImmutableList<CreateBuilder.CreateLocale> getLocales() {
    return locales;
  }

  /**
   * @return The value of the {@code pages} attribute
   */
  @JsonProperty("pages")
  @Override
  public ImmutableList<CreateBuilder.CreatePage> getPages() {
    return pages;
  }

  /**
   * @return The value of the {@code articles} attribute
   */
  @JsonProperty("articles")
  @Override
  public ImmutableList<CreateBuilder.CreateArticle> getArticles() {
    return articles;
  }

  /**
   * @return The value of the {@code workflows} attribute
   */
  @JsonProperty("workflows")
  @Override
  public ImmutableList<CreateBuilder.CreateWorkflow> getWorkflows() {
    return workflows;
  }

  /**
   * @return The value of the {@code links} attribute
   */
  @JsonProperty("links")
  @Override
  public ImmutableList<CreateBuilder.CreateLink> getLinks() {
    return links;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CreateBuilder.BatchSite#getLocales() locales}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBatchSite withLocales(CreateBuilder.CreateLocale... elements) {
    ImmutableList<CreateBuilder.CreateLocale> newValue = ImmutableList.copyOf(elements);
    return new ImmutableBatchSite(newValue, this.pages, this.articles, this.workflows, this.links);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CreateBuilder.BatchSite#getLocales() locales}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of locales elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBatchSite withLocales(Iterable<? extends CreateBuilder.CreateLocale> elements) {
    if (this.locales == elements) return this;
    ImmutableList<CreateBuilder.CreateLocale> newValue = ImmutableList.copyOf(elements);
    return new ImmutableBatchSite(newValue, this.pages, this.articles, this.workflows, this.links);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CreateBuilder.BatchSite#getPages() pages}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBatchSite withPages(CreateBuilder.CreatePage... elements) {
    ImmutableList<CreateBuilder.CreatePage> newValue = ImmutableList.copyOf(elements);
    return new ImmutableBatchSite(this.locales, newValue, this.articles, this.workflows, this.links);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CreateBuilder.BatchSite#getPages() pages}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of pages elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBatchSite withPages(Iterable<? extends CreateBuilder.CreatePage> elements) {
    if (this.pages == elements) return this;
    ImmutableList<CreateBuilder.CreatePage> newValue = ImmutableList.copyOf(elements);
    return new ImmutableBatchSite(this.locales, newValue, this.articles, this.workflows, this.links);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CreateBuilder.BatchSite#getArticles() articles}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBatchSite withArticles(CreateBuilder.CreateArticle... elements) {
    ImmutableList<CreateBuilder.CreateArticle> newValue = ImmutableList.copyOf(elements);
    return new ImmutableBatchSite(this.locales, this.pages, newValue, this.workflows, this.links);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CreateBuilder.BatchSite#getArticles() articles}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of articles elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBatchSite withArticles(Iterable<? extends CreateBuilder.CreateArticle> elements) {
    if (this.articles == elements) return this;
    ImmutableList<CreateBuilder.CreateArticle> newValue = ImmutableList.copyOf(elements);
    return new ImmutableBatchSite(this.locales, this.pages, newValue, this.workflows, this.links);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CreateBuilder.BatchSite#getWorkflows() workflows}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBatchSite withWorkflows(CreateBuilder.CreateWorkflow... elements) {
    ImmutableList<CreateBuilder.CreateWorkflow> newValue = ImmutableList.copyOf(elements);
    return new ImmutableBatchSite(this.locales, this.pages, this.articles, newValue, this.links);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CreateBuilder.BatchSite#getWorkflows() workflows}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of workflows elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBatchSite withWorkflows(Iterable<? extends CreateBuilder.CreateWorkflow> elements) {
    if (this.workflows == elements) return this;
    ImmutableList<CreateBuilder.CreateWorkflow> newValue = ImmutableList.copyOf(elements);
    return new ImmutableBatchSite(this.locales, this.pages, this.articles, newValue, this.links);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CreateBuilder.BatchSite#getLinks() links}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBatchSite withLinks(CreateBuilder.CreateLink... elements) {
    ImmutableList<CreateBuilder.CreateLink> newValue = ImmutableList.copyOf(elements);
    return new ImmutableBatchSite(this.locales, this.pages, this.articles, this.workflows, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CreateBuilder.BatchSite#getLinks() links}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of links elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBatchSite withLinks(Iterable<? extends CreateBuilder.CreateLink> elements) {
    if (this.links == elements) return this;
    ImmutableList<CreateBuilder.CreateLink> newValue = ImmutableList.copyOf(elements);
    return new ImmutableBatchSite(this.locales, this.pages, this.articles, this.workflows, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableBatchSite} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableBatchSite
        && equalTo((ImmutableBatchSite) another);
  }

  private boolean equalTo(ImmutableBatchSite another) {
    return locales.equals(another.locales)
        && pages.equals(another.pages)
        && articles.equals(another.articles)
        && workflows.equals(another.workflows)
        && links.equals(another.links);
  }

  /**
   * Computes a hash code from attributes: {@code locales}, {@code pages}, {@code articles}, {@code workflows}, {@code links}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + locales.hashCode();
    h += (h << 5) + pages.hashCode();
    h += (h << 5) + articles.hashCode();
    h += (h << 5) + workflows.hashCode();
    h += (h << 5) + links.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code BatchSite} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("BatchSite")
        .omitNullValues()
        .add("locales", locales)
        .add("pages", pages)
        .add("articles", articles)
        .add("workflows", workflows)
        .add("links", links)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "CreateBuilder.BatchSite", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements CreateBuilder.BatchSite {
    @Nullable List<CreateBuilder.CreateLocale> locales = ImmutableList.of();
    @Nullable List<CreateBuilder.CreatePage> pages = ImmutableList.of();
    @Nullable List<CreateBuilder.CreateArticle> articles = ImmutableList.of();
    @Nullable List<CreateBuilder.CreateWorkflow> workflows = ImmutableList.of();
    @Nullable List<CreateBuilder.CreateLink> links = ImmutableList.of();
    @JsonProperty("locales")
    public void setLocales(List<CreateBuilder.CreateLocale> locales) {
      this.locales = locales;
    }
    @JsonProperty("pages")
    public void setPages(List<CreateBuilder.CreatePage> pages) {
      this.pages = pages;
    }
    @JsonProperty("articles")
    public void setArticles(List<CreateBuilder.CreateArticle> articles) {
      this.articles = articles;
    }
    @JsonProperty("workflows")
    public void setWorkflows(List<CreateBuilder.CreateWorkflow> workflows) {
      this.workflows = workflows;
    }
    @JsonProperty("links")
    public void setLinks(List<CreateBuilder.CreateLink> links) {
      this.links = links;
    }
    @Override
    public List<CreateBuilder.CreateLocale> getLocales() { throw new UnsupportedOperationException(); }
    @Override
    public List<CreateBuilder.CreatePage> getPages() { throw new UnsupportedOperationException(); }
    @Override
    public List<CreateBuilder.CreateArticle> getArticles() { throw new UnsupportedOperationException(); }
    @Override
    public List<CreateBuilder.CreateWorkflow> getWorkflows() { throw new UnsupportedOperationException(); }
    @Override
    public List<CreateBuilder.CreateLink> getLinks() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableBatchSite fromJson(Json json) {
    ImmutableBatchSite.Builder builder = ImmutableBatchSite.builder();
    if (json.locales != null) {
      builder.addAllLocales(json.locales);
    }
    if (json.pages != null) {
      builder.addAllPages(json.pages);
    }
    if (json.articles != null) {
      builder.addAllArticles(json.articles);
    }
    if (json.workflows != null) {
      builder.addAllWorkflows(json.workflows);
    }
    if (json.links != null) {
      builder.addAllLinks(json.links);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link CreateBuilder.BatchSite} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable BatchSite instance
   */
  public static ImmutableBatchSite copyOf(CreateBuilder.BatchSite instance) {
    if (instance instanceof ImmutableBatchSite) {
      return (ImmutableBatchSite) instance;
    }
    return ImmutableBatchSite.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableBatchSite ImmutableBatchSite}.
   * <pre>
   * ImmutableBatchSite.builder()
   *    .addLocales|addAllLocales(io.thestencil.client.api.CreateBuilder.CreateLocale) // {@link CreateBuilder.BatchSite#getLocales() locales} elements
   *    .addPages|addAllPages(io.thestencil.client.api.CreateBuilder.CreatePage) // {@link CreateBuilder.BatchSite#getPages() pages} elements
   *    .addArticles|addAllArticles(io.thestencil.client.api.CreateBuilder.CreateArticle) // {@link CreateBuilder.BatchSite#getArticles() articles} elements
   *    .addWorkflows|addAllWorkflows(io.thestencil.client.api.CreateBuilder.CreateWorkflow) // {@link CreateBuilder.BatchSite#getWorkflows() workflows} elements
   *    .addLinks|addAllLinks(io.thestencil.client.api.CreateBuilder.CreateLink) // {@link CreateBuilder.BatchSite#getLinks() links} elements
   *    .build();
   * </pre>
   * @return A new ImmutableBatchSite builder
   */
  public static ImmutableBatchSite.Builder builder() {
    return new ImmutableBatchSite.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableBatchSite ImmutableBatchSite}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CreateBuilder.BatchSite", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableList.Builder<CreateBuilder.CreateLocale> locales = ImmutableList.builder();
    private ImmutableList.Builder<CreateBuilder.CreatePage> pages = ImmutableList.builder();
    private ImmutableList.Builder<CreateBuilder.CreateArticle> articles = ImmutableList.builder();
    private ImmutableList.Builder<CreateBuilder.CreateWorkflow> workflows = ImmutableList.builder();
    private ImmutableList.Builder<CreateBuilder.CreateLink> links = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code BatchSite} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CreateBuilder.BatchSite instance) {
      Objects.requireNonNull(instance, "instance");
      addAllLocales(instance.getLocales());
      addAllPages(instance.getPages());
      addAllArticles(instance.getArticles());
      addAllWorkflows(instance.getWorkflows());
      addAllLinks(instance.getLinks());
      return this;
    }

    /**
     * Adds one element to {@link CreateBuilder.BatchSite#getLocales() locales} list.
     * @param element A locales element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLocales(CreateBuilder.CreateLocale element) {
      this.locales.add(element);
      return this;
    }

    /**
     * Adds elements to {@link CreateBuilder.BatchSite#getLocales() locales} list.
     * @param elements An array of locales elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLocales(CreateBuilder.CreateLocale... elements) {
      this.locales.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CreateBuilder.BatchSite#getLocales() locales} list.
     * @param elements An iterable of locales elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("locales")
    public final Builder locales(Iterable<? extends CreateBuilder.CreateLocale> elements) {
      this.locales = ImmutableList.builder();
      return addAllLocales(elements);
    }

    /**
     * Adds elements to {@link CreateBuilder.BatchSite#getLocales() locales} list.
     * @param elements An iterable of locales elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllLocales(Iterable<? extends CreateBuilder.CreateLocale> elements) {
      this.locales.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link CreateBuilder.BatchSite#getPages() pages} list.
     * @param element A pages element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addPages(CreateBuilder.CreatePage element) {
      this.pages.add(element);
      return this;
    }

    /**
     * Adds elements to {@link CreateBuilder.BatchSite#getPages() pages} list.
     * @param elements An array of pages elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addPages(CreateBuilder.CreatePage... elements) {
      this.pages.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CreateBuilder.BatchSite#getPages() pages} list.
     * @param elements An iterable of pages elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("pages")
    public final Builder pages(Iterable<? extends CreateBuilder.CreatePage> elements) {
      this.pages = ImmutableList.builder();
      return addAllPages(elements);
    }

    /**
     * Adds elements to {@link CreateBuilder.BatchSite#getPages() pages} list.
     * @param elements An iterable of pages elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllPages(Iterable<? extends CreateBuilder.CreatePage> elements) {
      this.pages.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link CreateBuilder.BatchSite#getArticles() articles} list.
     * @param element A articles element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addArticles(CreateBuilder.CreateArticle element) {
      this.articles.add(element);
      return this;
    }

    /**
     * Adds elements to {@link CreateBuilder.BatchSite#getArticles() articles} list.
     * @param elements An array of articles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addArticles(CreateBuilder.CreateArticle... elements) {
      this.articles.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CreateBuilder.BatchSite#getArticles() articles} list.
     * @param elements An iterable of articles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("articles")
    public final Builder articles(Iterable<? extends CreateBuilder.CreateArticle> elements) {
      this.articles = ImmutableList.builder();
      return addAllArticles(elements);
    }

    /**
     * Adds elements to {@link CreateBuilder.BatchSite#getArticles() articles} list.
     * @param elements An iterable of articles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllArticles(Iterable<? extends CreateBuilder.CreateArticle> elements) {
      this.articles.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link CreateBuilder.BatchSite#getWorkflows() workflows} list.
     * @param element A workflows element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addWorkflows(CreateBuilder.CreateWorkflow element) {
      this.workflows.add(element);
      return this;
    }

    /**
     * Adds elements to {@link CreateBuilder.BatchSite#getWorkflows() workflows} list.
     * @param elements An array of workflows elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addWorkflows(CreateBuilder.CreateWorkflow... elements) {
      this.workflows.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CreateBuilder.BatchSite#getWorkflows() workflows} list.
     * @param elements An iterable of workflows elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("workflows")
    public final Builder workflows(Iterable<? extends CreateBuilder.CreateWorkflow> elements) {
      this.workflows = ImmutableList.builder();
      return addAllWorkflows(elements);
    }

    /**
     * Adds elements to {@link CreateBuilder.BatchSite#getWorkflows() workflows} list.
     * @param elements An iterable of workflows elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllWorkflows(Iterable<? extends CreateBuilder.CreateWorkflow> elements) {
      this.workflows.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link CreateBuilder.BatchSite#getLinks() links} list.
     * @param element A links element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLinks(CreateBuilder.CreateLink element) {
      this.links.add(element);
      return this;
    }

    /**
     * Adds elements to {@link CreateBuilder.BatchSite#getLinks() links} list.
     * @param elements An array of links elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLinks(CreateBuilder.CreateLink... elements) {
      this.links.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CreateBuilder.BatchSite#getLinks() links} list.
     * @param elements An iterable of links elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("links")
    public final Builder links(Iterable<? extends CreateBuilder.CreateLink> elements) {
      this.links = ImmutableList.builder();
      return addAllLinks(elements);
    }

    /**
     * Adds elements to {@link CreateBuilder.BatchSite#getLinks() links} list.
     * @param elements An iterable of links elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllLinks(Iterable<? extends CreateBuilder.CreateLink> elements) {
      this.links.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableBatchSite ImmutableBatchSite}.
     * @return An immutable instance of BatchSite
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableBatchSite build() {
      return new ImmutableBatchSite(locales.build(), pages.build(), articles.build(), workflows.build(), links.build());
    }
  }
}
