package io.thestencil.client.api;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link StencilStore.BatchCommand}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableBatchCommand.builder()}.
 */
@Generated(from = "StencilStore.BatchCommand", generator = "Immutables")
@SuppressWarnings({"rawtypes", "all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableBatchCommand implements StencilStore.BatchCommand {
  private final ImmutableList<StencilClient.Entity> toBeCreated;
  private final ImmutableList<StencilClient.Entity> toBeSaved;
  private final ImmutableList<StencilClient.Entity> toBeDeleted;

  private ImmutableBatchCommand(
      ImmutableList<StencilClient.Entity> toBeCreated,
      ImmutableList<StencilClient.Entity> toBeSaved,
      ImmutableList<StencilClient.Entity> toBeDeleted) {
    this.toBeCreated = toBeCreated;
    this.toBeSaved = toBeSaved;
    this.toBeDeleted = toBeDeleted;
  }

  /**
   * @return The value of the {@code toBeCreated} attribute
   */
  @Override
  public ImmutableList<StencilClient.Entity> getToBeCreated() {
    return toBeCreated;
  }

  /**
   * @return The value of the {@code toBeSaved} attribute
   */
  @Override
  public ImmutableList<StencilClient.Entity> getToBeSaved() {
    return toBeSaved;
  }

  /**
   * @return The value of the {@code toBeDeleted} attribute
   */
  @Override
  public ImmutableList<StencilClient.Entity> getToBeDeleted() {
    return toBeDeleted;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StencilStore.BatchCommand#getToBeCreated() toBeCreated}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBatchCommand withToBeCreated(StencilClient.Entity... elements) {
    ImmutableList<StencilClient.Entity> newValue = ImmutableList.copyOf(elements);
    return new ImmutableBatchCommand(newValue, this.toBeSaved, this.toBeDeleted);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StencilStore.BatchCommand#getToBeCreated() toBeCreated}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of toBeCreated elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBatchCommand withToBeCreated(Iterable<? extends StencilClient.Entity> elements) {
    if (this.toBeCreated == elements) return this;
    ImmutableList<StencilClient.Entity> newValue = ImmutableList.copyOf(elements);
    return new ImmutableBatchCommand(newValue, this.toBeSaved, this.toBeDeleted);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StencilStore.BatchCommand#getToBeSaved() toBeSaved}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBatchCommand withToBeSaved(StencilClient.Entity... elements) {
    ImmutableList<StencilClient.Entity> newValue = ImmutableList.copyOf(elements);
    return new ImmutableBatchCommand(this.toBeCreated, newValue, this.toBeDeleted);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StencilStore.BatchCommand#getToBeSaved() toBeSaved}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of toBeSaved elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBatchCommand withToBeSaved(Iterable<? extends StencilClient.Entity> elements) {
    if (this.toBeSaved == elements) return this;
    ImmutableList<StencilClient.Entity> newValue = ImmutableList.copyOf(elements);
    return new ImmutableBatchCommand(this.toBeCreated, newValue, this.toBeDeleted);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StencilStore.BatchCommand#getToBeDeleted() toBeDeleted}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBatchCommand withToBeDeleted(StencilClient.Entity... elements) {
    ImmutableList<StencilClient.Entity> newValue = ImmutableList.copyOf(elements);
    return new ImmutableBatchCommand(this.toBeCreated, this.toBeSaved, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StencilStore.BatchCommand#getToBeDeleted() toBeDeleted}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of toBeDeleted elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBatchCommand withToBeDeleted(Iterable<? extends StencilClient.Entity> elements) {
    if (this.toBeDeleted == elements) return this;
    ImmutableList<StencilClient.Entity> newValue = ImmutableList.copyOf(elements);
    return new ImmutableBatchCommand(this.toBeCreated, this.toBeSaved, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableBatchCommand} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableBatchCommand
        && equalTo((ImmutableBatchCommand) another);
  }

  private boolean equalTo(ImmutableBatchCommand another) {
    return toBeCreated.equals(another.toBeCreated)
        && toBeSaved.equals(another.toBeSaved)
        && toBeDeleted.equals(another.toBeDeleted);
  }

  /**
   * Computes a hash code from attributes: {@code toBeCreated}, {@code toBeSaved}, {@code toBeDeleted}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + toBeCreated.hashCode();
    h += (h << 5) + toBeSaved.hashCode();
    h += (h << 5) + toBeDeleted.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code BatchCommand} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("BatchCommand")
        .omitNullValues()
        .add("toBeCreated", toBeCreated)
        .add("toBeSaved", toBeSaved)
        .add("toBeDeleted", toBeDeleted)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link StencilStore.BatchCommand} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable BatchCommand instance
   */
  public static ImmutableBatchCommand copyOf(StencilStore.BatchCommand instance) {
    if (instance instanceof ImmutableBatchCommand) {
      return (ImmutableBatchCommand) instance;
    }
    return ImmutableBatchCommand.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableBatchCommand ImmutableBatchCommand}.
   * <pre>
   * ImmutableBatchCommand.builder()
   *    .addToBeCreated|addAllToBeCreated(io.thestencil.client.api.StencilClient.Entity) // {@link StencilStore.BatchCommand#getToBeCreated() toBeCreated} elements
   *    .addToBeSaved|addAllToBeSaved(io.thestencil.client.api.StencilClient.Entity) // {@link StencilStore.BatchCommand#getToBeSaved() toBeSaved} elements
   *    .addToBeDeleted|addAllToBeDeleted(io.thestencil.client.api.StencilClient.Entity) // {@link StencilStore.BatchCommand#getToBeDeleted() toBeDeleted} elements
   *    .build();
   * </pre>
   * @return A new ImmutableBatchCommand builder
   */
  public static ImmutableBatchCommand.Builder builder() {
    return new ImmutableBatchCommand.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableBatchCommand ImmutableBatchCommand}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "StencilStore.BatchCommand", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableList.Builder<StencilClient.Entity> toBeCreated = ImmutableList.builder();
    private ImmutableList.Builder<StencilClient.Entity> toBeSaved = ImmutableList.builder();
    private ImmutableList.Builder<StencilClient.Entity> toBeDeleted = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code BatchCommand} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StencilStore.BatchCommand instance) {
      Objects.requireNonNull(instance, "instance");
      addAllToBeCreated(instance.getToBeCreated());
      addAllToBeSaved(instance.getToBeSaved());
      addAllToBeDeleted(instance.getToBeDeleted());
      return this;
    }

    /**
     * Adds one element to {@link StencilStore.BatchCommand#getToBeCreated() toBeCreated} list.
     * @param element A toBeCreated element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addToBeCreated(StencilClient.Entity element) {
      this.toBeCreated.add(element);
      return this;
    }

    /**
     * Adds elements to {@link StencilStore.BatchCommand#getToBeCreated() toBeCreated} list.
     * @param elements An array of toBeCreated elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addToBeCreated(StencilClient.Entity... elements) {
      this.toBeCreated.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link StencilStore.BatchCommand#getToBeCreated() toBeCreated} list.
     * @param elements An iterable of toBeCreated elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder toBeCreated(Iterable<? extends StencilClient.Entity> elements) {
      this.toBeCreated = ImmutableList.builder();
      return addAllToBeCreated(elements);
    }

    /**
     * Adds elements to {@link StencilStore.BatchCommand#getToBeCreated() toBeCreated} list.
     * @param elements An iterable of toBeCreated elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllToBeCreated(Iterable<? extends StencilClient.Entity> elements) {
      this.toBeCreated.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link StencilStore.BatchCommand#getToBeSaved() toBeSaved} list.
     * @param element A toBeSaved element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addToBeSaved(StencilClient.Entity element) {
      this.toBeSaved.add(element);
      return this;
    }

    /**
     * Adds elements to {@link StencilStore.BatchCommand#getToBeSaved() toBeSaved} list.
     * @param elements An array of toBeSaved elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addToBeSaved(StencilClient.Entity... elements) {
      this.toBeSaved.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link StencilStore.BatchCommand#getToBeSaved() toBeSaved} list.
     * @param elements An iterable of toBeSaved elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder toBeSaved(Iterable<? extends StencilClient.Entity> elements) {
      this.toBeSaved = ImmutableList.builder();
      return addAllToBeSaved(elements);
    }

    /**
     * Adds elements to {@link StencilStore.BatchCommand#getToBeSaved() toBeSaved} list.
     * @param elements An iterable of toBeSaved elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllToBeSaved(Iterable<? extends StencilClient.Entity> elements) {
      this.toBeSaved.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link StencilStore.BatchCommand#getToBeDeleted() toBeDeleted} list.
     * @param element A toBeDeleted element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addToBeDeleted(StencilClient.Entity element) {
      this.toBeDeleted.add(element);
      return this;
    }

    /**
     * Adds elements to {@link StencilStore.BatchCommand#getToBeDeleted() toBeDeleted} list.
     * @param elements An array of toBeDeleted elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addToBeDeleted(StencilClient.Entity... elements) {
      this.toBeDeleted.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link StencilStore.BatchCommand#getToBeDeleted() toBeDeleted} list.
     * @param elements An iterable of toBeDeleted elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder toBeDeleted(Iterable<? extends StencilClient.Entity> elements) {
      this.toBeDeleted = ImmutableList.builder();
      return addAllToBeDeleted(elements);
    }

    /**
     * Adds elements to {@link StencilStore.BatchCommand#getToBeDeleted() toBeDeleted} list.
     * @param elements An iterable of toBeDeleted elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllToBeDeleted(Iterable<? extends StencilClient.Entity> elements) {
      this.toBeDeleted.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableBatchCommand ImmutableBatchCommand}.
     * @return An immutable instance of BatchCommand
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableBatchCommand build() {
      return new ImmutableBatchCommand(toBeCreated.build(), toBeSaved.build(), toBeDeleted.build());
    }
  }
}
