/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.thestencil.client.api.StencilClient;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="StencilClient.ArticleReleaseItem", generator="Immutables")
@Immutable
public final class ImmutableArticleReleaseItem
implements StencilClient.ArticleReleaseItem {
    private final String id;
    private final String hash;
    private final String name;
    @Nullable
    private final String parentId;

    private ImmutableArticleReleaseItem(String id, String hash, String name, @Nullable String parentId) {
        this.id = id;
        this.hash = hash;
        this.name = name;
        this.parentId = parentId;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="hash")
    public String getHash() {
        return this.hash;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="parentId")
    @Nullable
    public String getParentId() {
        return this.parentId;
    }

    public final ImmutableArticleReleaseItem withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableArticleReleaseItem(newValue, this.hash, this.name, this.parentId);
    }

    public final ImmutableArticleReleaseItem withHash(String value) {
        String newValue = Objects.requireNonNull(value, "hash");
        if (this.hash.equals(newValue)) {
            return this;
        }
        return new ImmutableArticleReleaseItem(this.id, newValue, this.name, this.parentId);
    }

    public final ImmutableArticleReleaseItem withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableArticleReleaseItem(this.id, this.hash, newValue, this.parentId);
    }

    public final ImmutableArticleReleaseItem withParentId(@Nullable String value) {
        if (Objects.equals(this.parentId, value)) {
            return this;
        }
        return new ImmutableArticleReleaseItem(this.id, this.hash, this.name, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableArticleReleaseItem && this.equalTo((ImmutableArticleReleaseItem)another);
    }

    private boolean equalTo(ImmutableArticleReleaseItem another) {
        return this.id.equals(another.id) && this.hash.equals(another.hash) && this.name.equals(another.name) && Objects.equals(this.parentId, another.parentId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.hash.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.parentId);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ArticleReleaseItem").omitNullValues().add("id", (Object)this.id).add("hash", (Object)this.hash).add("name", (Object)this.name).add("parentId", (Object)this.parentId).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableArticleReleaseItem fromJson(Json json) {
        Builder builder = ImmutableArticleReleaseItem.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.hash != null) {
            builder.hash(json.hash);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.parentId != null) {
            builder.parentId(json.parentId);
        }
        return builder.build();
    }

    public static ImmutableArticleReleaseItem copyOf(StencilClient.ArticleReleaseItem instance) {
        if (instance instanceof ImmutableArticleReleaseItem) {
            return (ImmutableArticleReleaseItem)instance;
        }
        return ImmutableArticleReleaseItem.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StencilClient.ArticleReleaseItem", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_HASH = 2L;
        private static final long INIT_BIT_NAME = 4L;
        private long initBits = 7L;
        @Nullable
        private String id;
        @Nullable
        private String hash;
        @Nullable
        private String name;
        @Nullable
        private String parentId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StencilClient.ArticleReleaseItem instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StencilClient.ReleaseItem instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            StencilClient.ReleaseItem instance;
            if (object instanceof StencilClient.ArticleReleaseItem) {
                instance = (StencilClient.ArticleReleaseItem)object;
                this.name(instance.getName());
                String parentIdValue = instance.getParentId();
                if (parentIdValue != null) {
                    this.parentId(parentIdValue);
                }
            }
            if (object instanceof StencilClient.ReleaseItem) {
                instance = (StencilClient.ReleaseItem)object;
                this.hash(instance.getHash());
                this.id(instance.getId());
            }
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="hash")
        @CanIgnoreReturnValue
        public final Builder hash(String hash) {
            this.hash = Objects.requireNonNull(hash, "hash");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="parentId")
        @CanIgnoreReturnValue
        public final Builder parentId(@Nullable String parentId) {
            this.parentId = parentId;
            return this;
        }

        public ImmutableArticleReleaseItem build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableArticleReleaseItem(this.id, this.hash, this.name, this.parentId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("hash");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build ArticleReleaseItem, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="StencilClient.ArticleReleaseItem", generator="Immutables")
    static final class Json
    implements StencilClient.ArticleReleaseItem {
        @Nullable
        String id;
        @Nullable
        String hash;
        @Nullable
        String name;
        @Nullable
        String parentId;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="hash")
        public void setHash(String hash) {
            this.hash = hash;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="parentId")
        public void setParentId(@Nullable String parentId) {
            this.parentId = parentId;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getParentId() {
            throw new UnsupportedOperationException();
        }
    }
}

