package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link StencilClient.WorkflowReleaseItem}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableWorkflowReleaseItem.builder()}.
 */
@Generated(from = "StencilClient.WorkflowReleaseItem", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableWorkflowReleaseItem
    implements StencilClient.WorkflowReleaseItem {
  private final String id;
  private final String hash;
  private final String value;
  private final ImmutableList<String> articles;
  private final ImmutableList<StencilClient.LocaleLabel> labels;

  private ImmutableWorkflowReleaseItem(
      String id,
      String hash,
      String value,
      ImmutableList<String> articles,
      ImmutableList<StencilClient.LocaleLabel> labels) {
    this.id = id;
    this.hash = hash;
    this.value = value;
    this.articles = articles;
    this.labels = labels;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code hash} attribute
   */
  @JsonProperty("hash")
  @Override
  public String getHash() {
    return hash;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @JsonProperty("value")
  @Override
  public String getValue() {
    return value;
  }

  /**
   * @return The value of the {@code articles} attribute
   */
  @JsonProperty("articles")
  @Override
  public ImmutableList<String> getArticles() {
    return articles;
  }

  /**
   * @return The value of the {@code labels} attribute
   */
  @JsonProperty("labels")
  @Override
  public ImmutableList<StencilClient.LocaleLabel> getLabels() {
    return labels;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.WorkflowReleaseItem#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWorkflowReleaseItem withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableWorkflowReleaseItem(newValue, this.hash, this.value, this.articles, this.labels);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.WorkflowReleaseItem#getHash() hash} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hash
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWorkflowReleaseItem withHash(String value) {
    String newValue = Objects.requireNonNull(value, "hash");
    if (this.hash.equals(newValue)) return this;
    return new ImmutableWorkflowReleaseItem(this.id, newValue, this.value, this.articles, this.labels);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.WorkflowReleaseItem#getValue() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWorkflowReleaseItem withValue(String value) {
    String newValue = Objects.requireNonNull(value, "value");
    if (this.value.equals(newValue)) return this;
    return new ImmutableWorkflowReleaseItem(this.id, this.hash, newValue, this.articles, this.labels);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StencilClient.WorkflowReleaseItem#getArticles() articles}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWorkflowReleaseItem withArticles(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableWorkflowReleaseItem(this.id, this.hash, this.value, newValue, this.labels);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StencilClient.WorkflowReleaseItem#getArticles() articles}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of articles elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWorkflowReleaseItem withArticles(Iterable<String> elements) {
    if (this.articles == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableWorkflowReleaseItem(this.id, this.hash, this.value, newValue, this.labels);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StencilClient.WorkflowReleaseItem#getLabels() labels}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWorkflowReleaseItem withLabels(StencilClient.LocaleLabel... elements) {
    ImmutableList<StencilClient.LocaleLabel> newValue = ImmutableList.copyOf(elements);
    return new ImmutableWorkflowReleaseItem(this.id, this.hash, this.value, this.articles, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StencilClient.WorkflowReleaseItem#getLabels() labels}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of labels elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWorkflowReleaseItem withLabels(Iterable<? extends StencilClient.LocaleLabel> elements) {
    if (this.labels == elements) return this;
    ImmutableList<StencilClient.LocaleLabel> newValue = ImmutableList.copyOf(elements);
    return new ImmutableWorkflowReleaseItem(this.id, this.hash, this.value, this.articles, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableWorkflowReleaseItem} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableWorkflowReleaseItem
        && equalTo((ImmutableWorkflowReleaseItem) another);
  }

  private boolean equalTo(ImmutableWorkflowReleaseItem another) {
    return id.equals(another.id)
        && hash.equals(another.hash)
        && value.equals(another.value)
        && articles.equals(another.articles)
        && labels.equals(another.labels);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code hash}, {@code value}, {@code articles}, {@code labels}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + hash.hashCode();
    h += (h << 5) + value.hashCode();
    h += (h << 5) + articles.hashCode();
    h += (h << 5) + labels.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code WorkflowReleaseItem} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("WorkflowReleaseItem")
        .omitNullValues()
        .add("id", id)
        .add("hash", hash)
        .add("value", value)
        .add("articles", articles)
        .add("labels", labels)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "StencilClient.WorkflowReleaseItem", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements StencilClient.WorkflowReleaseItem {
    @Nullable String id;
    @Nullable String hash;
    @Nullable String value;
    @Nullable List<String> articles = ImmutableList.of();
    @Nullable List<StencilClient.LocaleLabel> labels = ImmutableList.of();
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("hash")
    public void setHash(String hash) {
      this.hash = hash;
    }
    @JsonProperty("value")
    public void setValue(String value) {
      this.value = value;
    }
    @JsonProperty("articles")
    public void setArticles(List<String> articles) {
      this.articles = articles;
    }
    @JsonProperty("labels")
    public void setLabels(List<StencilClient.LocaleLabel> labels) {
      this.labels = labels;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getHash() { throw new UnsupportedOperationException(); }
    @Override
    public String getValue() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getArticles() { throw new UnsupportedOperationException(); }
    @Override
    public List<StencilClient.LocaleLabel> getLabels() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableWorkflowReleaseItem fromJson(Json json) {
    ImmutableWorkflowReleaseItem.Builder builder = ImmutableWorkflowReleaseItem.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.hash != null) {
      builder.hash(json.hash);
    }
    if (json.value != null) {
      builder.value(json.value);
    }
    if (json.articles != null) {
      builder.addAllArticles(json.articles);
    }
    if (json.labels != null) {
      builder.addAllLabels(json.labels);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link StencilClient.WorkflowReleaseItem} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable WorkflowReleaseItem instance
   */
  public static ImmutableWorkflowReleaseItem copyOf(StencilClient.WorkflowReleaseItem instance) {
    if (instance instanceof ImmutableWorkflowReleaseItem) {
      return (ImmutableWorkflowReleaseItem) instance;
    }
    return ImmutableWorkflowReleaseItem.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableWorkflowReleaseItem ImmutableWorkflowReleaseItem}.
   * <pre>
   * ImmutableWorkflowReleaseItem.builder()
   *    .id(String) // required {@link StencilClient.WorkflowReleaseItem#getId() id}
   *    .hash(String) // required {@link StencilClient.WorkflowReleaseItem#getHash() hash}
   *    .value(String) // required {@link StencilClient.WorkflowReleaseItem#getValue() value}
   *    .addArticles|addAllArticles(String) // {@link StencilClient.WorkflowReleaseItem#getArticles() articles} elements
   *    .addLabels|addAllLabels(io.thestencil.client.api.StencilClient.LocaleLabel) // {@link StencilClient.WorkflowReleaseItem#getLabels() labels} elements
   *    .build();
   * </pre>
   * @return A new ImmutableWorkflowReleaseItem builder
   */
  public static ImmutableWorkflowReleaseItem.Builder builder() {
    return new ImmutableWorkflowReleaseItem.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableWorkflowReleaseItem ImmutableWorkflowReleaseItem}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "StencilClient.WorkflowReleaseItem", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_HASH = 0x2L;
    private static final long INIT_BIT_VALUE = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String id;
    private @Nullable String hash;
    private @Nullable String value;
    private ImmutableList.Builder<String> articles = ImmutableList.builder();
    private ImmutableList.Builder<StencilClient.LocaleLabel> labels = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.thestencil.client.api.StencilClient.ReleaseItem} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StencilClient.ReleaseItem instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.thestencil.client.api.StencilClient.WorkflowReleaseItem} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StencilClient.WorkflowReleaseItem instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof StencilClient.ReleaseItem) {
        StencilClient.ReleaseItem instance = (StencilClient.ReleaseItem) object;
        hash(instance.getHash());
        id(instance.getId());
      }
      if (object instanceof StencilClient.WorkflowReleaseItem) {
        StencilClient.WorkflowReleaseItem instance = (StencilClient.WorkflowReleaseItem) object;
        value(instance.getValue());
        addAllArticles(instance.getArticles());
        addAllLabels(instance.getLabels());
      }
    }

    /**
     * Initializes the value for the {@link StencilClient.WorkflowReleaseItem#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.WorkflowReleaseItem#getHash() hash} attribute.
     * @param hash The value for hash 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("hash")
    public final Builder hash(String hash) {
      this.hash = Objects.requireNonNull(hash, "hash");
      initBits &= ~INIT_BIT_HASH;
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.WorkflowReleaseItem#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("value")
    public final Builder value(String value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Adds one element to {@link StencilClient.WorkflowReleaseItem#getArticles() articles} list.
     * @param element A articles element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addArticles(String element) {
      this.articles.add(element);
      return this;
    }

    /**
     * Adds elements to {@link StencilClient.WorkflowReleaseItem#getArticles() articles} list.
     * @param elements An array of articles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addArticles(String... elements) {
      this.articles.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link StencilClient.WorkflowReleaseItem#getArticles() articles} list.
     * @param elements An iterable of articles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("articles")
    public final Builder articles(Iterable<String> elements) {
      this.articles = ImmutableList.builder();
      return addAllArticles(elements);
    }

    /**
     * Adds elements to {@link StencilClient.WorkflowReleaseItem#getArticles() articles} list.
     * @param elements An iterable of articles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllArticles(Iterable<String> elements) {
      this.articles.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link StencilClient.WorkflowReleaseItem#getLabels() labels} list.
     * @param element A labels element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLabels(StencilClient.LocaleLabel element) {
      this.labels.add(element);
      return this;
    }

    /**
     * Adds elements to {@link StencilClient.WorkflowReleaseItem#getLabels() labels} list.
     * @param elements An array of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLabels(StencilClient.LocaleLabel... elements) {
      this.labels.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link StencilClient.WorkflowReleaseItem#getLabels() labels} list.
     * @param elements An iterable of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("labels")
    public final Builder labels(Iterable<? extends StencilClient.LocaleLabel> elements) {
      this.labels = ImmutableList.builder();
      return addAllLabels(elements);
    }

    /**
     * Adds elements to {@link StencilClient.WorkflowReleaseItem#getLabels() labels} list.
     * @param elements An iterable of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllLabels(Iterable<? extends StencilClient.LocaleLabel> elements) {
      this.labels.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableWorkflowReleaseItem ImmutableWorkflowReleaseItem}.
     * @return An immutable instance of WorkflowReleaseItem
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableWorkflowReleaseItem build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableWorkflowReleaseItem(id, hash, value, articles.build(), labels.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_HASH) != 0) attributes.add("hash");
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build WorkflowReleaseItem, some of required attributes are not set " + attributes;
    }
  }
}
