/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.thestencil.client.api.StencilClient;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="StencilClient.TemplateReleaseItem", generator="Immutables")
@Immutable
public final class ImmutableTemplateReleaseItem
implements StencilClient.TemplateReleaseItem {
    private final String id;
    private final String hash;
    private final String name;
    private final String content;
    private final String type;

    private ImmutableTemplateReleaseItem(String id, String hash, String name, String content, String type) {
        this.id = id;
        this.hash = hash;
        this.name = name;
        this.content = content;
        this.type = type;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="hash")
    public String getHash() {
        return this.hash;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="content")
    public String getContent() {
        return this.content;
    }

    @Override
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    public final ImmutableTemplateReleaseItem withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableTemplateReleaseItem(newValue, this.hash, this.name, this.content, this.type);
    }

    public final ImmutableTemplateReleaseItem withHash(String value) {
        String newValue = Objects.requireNonNull(value, "hash");
        if (this.hash.equals(newValue)) {
            return this;
        }
        return new ImmutableTemplateReleaseItem(this.id, newValue, this.name, this.content, this.type);
    }

    public final ImmutableTemplateReleaseItem withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableTemplateReleaseItem(this.id, this.hash, newValue, this.content, this.type);
    }

    public final ImmutableTemplateReleaseItem withContent(String value) {
        String newValue = Objects.requireNonNull(value, "content");
        if (this.content.equals(newValue)) {
            return this;
        }
        return new ImmutableTemplateReleaseItem(this.id, this.hash, this.name, newValue, this.type);
    }

    public final ImmutableTemplateReleaseItem withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ImmutableTemplateReleaseItem(this.id, this.hash, this.name, this.content, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTemplateReleaseItem && this.equalTo((ImmutableTemplateReleaseItem)another);
    }

    private boolean equalTo(ImmutableTemplateReleaseItem another) {
        return this.id.equals(another.id) && this.hash.equals(another.hash) && this.name.equals(another.name) && this.content.equals(another.content) && this.type.equals(another.type);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.hash.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.content.hashCode();
        h += (h << 5) + this.type.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TemplateReleaseItem").omitNullValues().add("id", (Object)this.id).add("hash", (Object)this.hash).add("name", (Object)this.name).add("content", (Object)this.content).add("type", (Object)this.type).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTemplateReleaseItem fromJson(Json json) {
        Builder builder = ImmutableTemplateReleaseItem.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.hash != null) {
            builder.hash(json.hash);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.content != null) {
            builder.content(json.content);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        return builder.build();
    }

    public static ImmutableTemplateReleaseItem copyOf(StencilClient.TemplateReleaseItem instance) {
        if (instance instanceof ImmutableTemplateReleaseItem) {
            return (ImmutableTemplateReleaseItem)instance;
        }
        return ImmutableTemplateReleaseItem.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StencilClient.TemplateReleaseItem", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_HASH = 2L;
        private static final long INIT_BIT_NAME = 4L;
        private static final long INIT_BIT_CONTENT = 8L;
        private static final long INIT_BIT_TYPE = 16L;
        private long initBits = 31L;
        @Nullable
        private String id;
        @Nullable
        private String hash;
        @Nullable
        private String name;
        @Nullable
        private String content;
        @Nullable
        private String type;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StencilClient.TemplateReleaseItem instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StencilClient.ReleaseItem instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            StencilClient.ReleaseItem instance;
            if (object instanceof StencilClient.TemplateReleaseItem) {
                instance = (StencilClient.TemplateReleaseItem)object;
                this.name(instance.getName());
                this.type(instance.getType());
                this.content(instance.getContent());
            }
            if (object instanceof StencilClient.ReleaseItem) {
                instance = (StencilClient.ReleaseItem)object;
                this.hash(instance.getHash());
                this.id(instance.getId());
            }
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="hash")
        @CanIgnoreReturnValue
        public final Builder hash(String hash) {
            this.hash = Objects.requireNonNull(hash, "hash");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="content")
        @CanIgnoreReturnValue
        public final Builder content(String content) {
            this.content = Objects.requireNonNull(content, "content");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableTemplateReleaseItem build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTemplateReleaseItem(this.id, this.hash, this.name, this.content, this.type);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("hash");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("content");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build TemplateReleaseItem, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="StencilClient.TemplateReleaseItem", generator="Immutables")
    static final class Json
    implements StencilClient.TemplateReleaseItem {
        @Nullable
        String id;
        @Nullable
        String hash;
        @Nullable
        String name;
        @Nullable
        String content;
        @Nullable
        String type;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="hash")
        public void setHash(String hash) {
            this.hash = hash;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="content")
        public void setContent(String content) {
            this.content = content;
        }

        @JsonProperty(value="type")
        public void setType(String type) {
            this.type = type;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getContent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }
    }
}

