/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.thestencil.client.api.UpdateBuilder;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="UpdateBuilder.PageMutator", generator="Immutables")
@Immutable
public final class ImmutablePageMutator
implements UpdateBuilder.PageMutator {
    private final String pageId;
    private final String content;
    private final String locale;

    private ImmutablePageMutator(String pageId, String content, String locale) {
        this.pageId = pageId;
        this.content = content;
        this.locale = locale;
    }

    @Override
    @JsonProperty(value="pageId")
    public String getPageId() {
        return this.pageId;
    }

    @Override
    @JsonProperty(value="content")
    public String getContent() {
        return this.content;
    }

    @Override
    @JsonProperty(value="locale")
    public String getLocale() {
        return this.locale;
    }

    public final ImmutablePageMutator withPageId(String value) {
        String newValue = Objects.requireNonNull(value, "pageId");
        if (this.pageId.equals(newValue)) {
            return this;
        }
        return new ImmutablePageMutator(newValue, this.content, this.locale);
    }

    public final ImmutablePageMutator withContent(String value) {
        String newValue = Objects.requireNonNull(value, "content");
        if (this.content.equals(newValue)) {
            return this;
        }
        return new ImmutablePageMutator(this.pageId, newValue, this.locale);
    }

    public final ImmutablePageMutator withLocale(String value) {
        String newValue = Objects.requireNonNull(value, "locale");
        if (this.locale.equals(newValue)) {
            return this;
        }
        return new ImmutablePageMutator(this.pageId, this.content, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePageMutator && this.equalTo((ImmutablePageMutator)another);
    }

    private boolean equalTo(ImmutablePageMutator another) {
        return this.pageId.equals(another.pageId) && this.content.equals(another.content) && this.locale.equals(another.locale);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.pageId.hashCode();
        h += (h << 5) + this.content.hashCode();
        h += (h << 5) + this.locale.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PageMutator").omitNullValues().add("pageId", (Object)this.pageId).add("content", (Object)this.content).add("locale", (Object)this.locale).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePageMutator fromJson(Json json) {
        Builder builder = ImmutablePageMutator.builder();
        if (json.pageId != null) {
            builder.pageId(json.pageId);
        }
        if (json.content != null) {
            builder.content(json.content);
        }
        if (json.locale != null) {
            builder.locale(json.locale);
        }
        return builder.build();
    }

    public static ImmutablePageMutator copyOf(UpdateBuilder.PageMutator instance) {
        if (instance instanceof ImmutablePageMutator) {
            return (ImmutablePageMutator)instance;
        }
        return ImmutablePageMutator.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="UpdateBuilder.PageMutator", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PAGE_ID = 1L;
        private static final long INIT_BIT_CONTENT = 2L;
        private static final long INIT_BIT_LOCALE = 4L;
        private long initBits = 7L;
        @Nullable
        private String pageId;
        @Nullable
        private String content;
        @Nullable
        private String locale;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(UpdateBuilder.PageMutator instance) {
            Objects.requireNonNull(instance, "instance");
            this.pageId(instance.getPageId());
            this.content(instance.getContent());
            this.locale(instance.getLocale());
            return this;
        }

        @JsonProperty(value="pageId")
        @CanIgnoreReturnValue
        public final Builder pageId(String pageId) {
            this.pageId = Objects.requireNonNull(pageId, "pageId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="content")
        @CanIgnoreReturnValue
        public final Builder content(String content) {
            this.content = Objects.requireNonNull(content, "content");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="locale")
        @CanIgnoreReturnValue
        public final Builder locale(String locale) {
            this.locale = Objects.requireNonNull(locale, "locale");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutablePageMutator build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePageMutator(this.pageId, this.content, this.locale);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("pageId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("content");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("locale");
            }
            return "Cannot build PageMutator, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="UpdateBuilder.PageMutator", generator="Immutables")
    static final class Json
    implements UpdateBuilder.PageMutator {
        @Nullable
        String pageId;
        @Nullable
        String content;
        @Nullable
        String locale;

        Json() {
        }

        @JsonProperty(value="pageId")
        public void setPageId(String pageId) {
            this.pageId = pageId;
        }

        @JsonProperty(value="content")
        public void setContent(String content) {
            this.content = content;
        }

        @JsonProperty(value="locale")
        public void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public String getPageId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getContent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getLocale() {
            throw new UnsupportedOperationException();
        }
    }
}

