/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.thestencil.client.api.CreateBuilder;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CreateBuilder.CreatePage", generator="Immutables")
@Immutable
public final class ImmutableCreatePage
implements CreateBuilder.CreatePage {
    private final String articleId;
    private final String locale;
    @Nullable
    private final String content;

    private ImmutableCreatePage(String articleId, String locale, @Nullable String content) {
        this.articleId = articleId;
        this.locale = locale;
        this.content = content;
    }

    @Override
    @JsonProperty(value="articleId")
    public String getArticleId() {
        return this.articleId;
    }

    @Override
    @JsonProperty(value="locale")
    public String getLocale() {
        return this.locale;
    }

    @Override
    @JsonProperty(value="content")
    @Nullable
    public String getContent() {
        return this.content;
    }

    public final ImmutableCreatePage withArticleId(String value) {
        String newValue = Objects.requireNonNull(value, "articleId");
        if (this.articleId.equals(newValue)) {
            return this;
        }
        return new ImmutableCreatePage(newValue, this.locale, this.content);
    }

    public final ImmutableCreatePage withLocale(String value) {
        String newValue = Objects.requireNonNull(value, "locale");
        if (this.locale.equals(newValue)) {
            return this;
        }
        return new ImmutableCreatePage(this.articleId, newValue, this.content);
    }

    public final ImmutableCreatePage withContent(@Nullable String value) {
        if (Objects.equals(this.content, value)) {
            return this;
        }
        return new ImmutableCreatePage(this.articleId, this.locale, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCreatePage && this.equalTo((ImmutableCreatePage)another);
    }

    private boolean equalTo(ImmutableCreatePage another) {
        return this.articleId.equals(another.articleId) && this.locale.equals(another.locale) && Objects.equals(this.content, another.content);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.articleId.hashCode();
        h += (h << 5) + this.locale.hashCode();
        h += (h << 5) + Objects.hashCode(this.content);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CreatePage").omitNullValues().add("articleId", (Object)this.articleId).add("locale", (Object)this.locale).add("content", (Object)this.content).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCreatePage fromJson(Json json) {
        Builder builder = ImmutableCreatePage.builder();
        if (json.articleId != null) {
            builder.articleId(json.articleId);
        }
        if (json.locale != null) {
            builder.locale(json.locale);
        }
        if (json.content != null) {
            builder.content(json.content);
        }
        return builder.build();
    }

    public static ImmutableCreatePage copyOf(CreateBuilder.CreatePage instance) {
        if (instance instanceof ImmutableCreatePage) {
            return (ImmutableCreatePage)instance;
        }
        return ImmutableCreatePage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CreateBuilder.CreatePage", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ARTICLE_ID = 1L;
        private static final long INIT_BIT_LOCALE = 2L;
        private long initBits = 3L;
        @Nullable
        private String articleId;
        @Nullable
        private String locale;
        @Nullable
        private String content;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CreateBuilder.CreatePage instance) {
            Objects.requireNonNull(instance, "instance");
            this.articleId(instance.getArticleId());
            this.locale(instance.getLocale());
            String contentValue = instance.getContent();
            if (contentValue != null) {
                this.content(contentValue);
            }
            return this;
        }

        @JsonProperty(value="articleId")
        @CanIgnoreReturnValue
        public final Builder articleId(String articleId) {
            this.articleId = Objects.requireNonNull(articleId, "articleId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="locale")
        @CanIgnoreReturnValue
        public final Builder locale(String locale) {
            this.locale = Objects.requireNonNull(locale, "locale");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="content")
        @CanIgnoreReturnValue
        public final Builder content(@Nullable String content) {
            this.content = content;
            return this;
        }

        public ImmutableCreatePage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCreatePage(this.articleId, this.locale, this.content);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("articleId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("locale");
            }
            return "Cannot build CreatePage, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CreateBuilder.CreatePage", generator="Immutables")
    static final class Json
    implements CreateBuilder.CreatePage {
        @Nullable
        String articleId;
        @Nullable
        String locale;
        @Nullable
        String content;

        Json() {
        }

        @JsonProperty(value="articleId")
        public void setArticleId(String articleId) {
            this.articleId = articleId;
        }

        @JsonProperty(value="locale")
        public void setLocale(String locale) {
            this.locale = locale;
        }

        @JsonProperty(value="content")
        public void setContent(@Nullable String content) {
            this.content = content;
        }

        @Override
        public String getArticleId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getLocale() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getContent() {
            throw new UnsupportedOperationException();
        }
    }
}

