package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link StencilClient.ArticleReleaseItem}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableArticleReleaseItem.builder()}.
 */
@Generated(from = "StencilClient.ArticleReleaseItem", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableArticleReleaseItem
    implements StencilClient.ArticleReleaseItem {
  private final String id;
  private final String hash;
  private final String name;
  private final @Nullable String parentId;

  private ImmutableArticleReleaseItem(
      String id,
      String hash,
      String name,
      @Nullable String parentId) {
    this.id = id;
    this.hash = hash;
    this.name = name;
    this.parentId = parentId;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code hash} attribute
   */
  @JsonProperty("hash")
  @Override
  public String getHash() {
    return hash;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code parentId} attribute
   */
  @JsonProperty("parentId")
  @Override
  public @Nullable String getParentId() {
    return parentId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.ArticleReleaseItem#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableArticleReleaseItem withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableArticleReleaseItem(newValue, this.hash, this.name, this.parentId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.ArticleReleaseItem#getHash() hash} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hash
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableArticleReleaseItem withHash(String value) {
    String newValue = Objects.requireNonNull(value, "hash");
    if (this.hash.equals(newValue)) return this;
    return new ImmutableArticleReleaseItem(this.id, newValue, this.name, this.parentId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.ArticleReleaseItem#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableArticleReleaseItem withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableArticleReleaseItem(this.id, this.hash, newValue, this.parentId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.ArticleReleaseItem#getParentId() parentId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for parentId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableArticleReleaseItem withParentId(@Nullable String value) {
    if (Objects.equals(this.parentId, value)) return this;
    return new ImmutableArticleReleaseItem(this.id, this.hash, this.name, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableArticleReleaseItem} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableArticleReleaseItem
        && equalTo((ImmutableArticleReleaseItem) another);
  }

  private boolean equalTo(ImmutableArticleReleaseItem another) {
    return id.equals(another.id)
        && hash.equals(another.hash)
        && name.equals(another.name)
        && Objects.equals(parentId, another.parentId);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code hash}, {@code name}, {@code parentId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + hash.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(parentId);
    return h;
  }

  /**
   * Prints the immutable value {@code ArticleReleaseItem} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ArticleReleaseItem")
        .omitNullValues()
        .add("id", id)
        .add("hash", hash)
        .add("name", name)
        .add("parentId", parentId)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "StencilClient.ArticleReleaseItem", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements StencilClient.ArticleReleaseItem {
    @Nullable String id;
    @Nullable String hash;
    @Nullable String name;
    @Nullable String parentId;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("hash")
    public void setHash(String hash) {
      this.hash = hash;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("parentId")
    public void setParentId(@Nullable String parentId) {
      this.parentId = parentId;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getHash() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getParentId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableArticleReleaseItem fromJson(Json json) {
    ImmutableArticleReleaseItem.Builder builder = ImmutableArticleReleaseItem.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.hash != null) {
      builder.hash(json.hash);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.parentId != null) {
      builder.parentId(json.parentId);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link StencilClient.ArticleReleaseItem} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ArticleReleaseItem instance
   */
  public static ImmutableArticleReleaseItem copyOf(StencilClient.ArticleReleaseItem instance) {
    if (instance instanceof ImmutableArticleReleaseItem) {
      return (ImmutableArticleReleaseItem) instance;
    }
    return ImmutableArticleReleaseItem.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableArticleReleaseItem ImmutableArticleReleaseItem}.
   * <pre>
   * ImmutableArticleReleaseItem.builder()
   *    .id(String) // required {@link StencilClient.ArticleReleaseItem#getId() id}
   *    .hash(String) // required {@link StencilClient.ArticleReleaseItem#getHash() hash}
   *    .name(String) // required {@link StencilClient.ArticleReleaseItem#getName() name}
   *    .parentId(String | null) // nullable {@link StencilClient.ArticleReleaseItem#getParentId() parentId}
   *    .build();
   * </pre>
   * @return A new ImmutableArticleReleaseItem builder
   */
  public static ImmutableArticleReleaseItem.Builder builder() {
    return new ImmutableArticleReleaseItem.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableArticleReleaseItem ImmutableArticleReleaseItem}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "StencilClient.ArticleReleaseItem", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_HASH = 0x2L;
    private static final long INIT_BIT_NAME = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String id;
    private @Nullable String hash;
    private @Nullable String name;
    private @Nullable String parentId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.thestencil.client.api.StencilClient.ArticleReleaseItem} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StencilClient.ArticleReleaseItem instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.thestencil.client.api.StencilClient.ReleaseItem} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StencilClient.ReleaseItem instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof StencilClient.ArticleReleaseItem) {
        StencilClient.ArticleReleaseItem instance = (StencilClient.ArticleReleaseItem) object;
        name(instance.getName());
        @Nullable String parentIdValue = instance.getParentId();
        if (parentIdValue != null) {
          parentId(parentIdValue);
        }
      }
      if (object instanceof StencilClient.ReleaseItem) {
        StencilClient.ReleaseItem instance = (StencilClient.ReleaseItem) object;
        hash(instance.getHash());
        id(instance.getId());
      }
    }

    /**
     * Initializes the value for the {@link StencilClient.ArticleReleaseItem#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.ArticleReleaseItem#getHash() hash} attribute.
     * @param hash The value for hash 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("hash")
    public final Builder hash(String hash) {
      this.hash = Objects.requireNonNull(hash, "hash");
      initBits &= ~INIT_BIT_HASH;
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.ArticleReleaseItem#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.ArticleReleaseItem#getParentId() parentId} attribute.
     * @param parentId The value for parentId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("parentId")
    public final Builder parentId(@Nullable String parentId) {
      this.parentId = parentId;
      return this;
    }

    /**
     * Builds a new {@link ImmutableArticleReleaseItem ImmutableArticleReleaseItem}.
     * @return An immutable instance of ArticleReleaseItem
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableArticleReleaseItem build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableArticleReleaseItem(id, hash, name, parentId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_HASH) != 0) attributes.add("hash");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build ArticleReleaseItem, some of required attributes are not set " + attributes;
    }
  }
}
