package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link StencilClient.PageReleaseItem}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePageReleaseItem.builder()}.
 */
@Generated(from = "StencilClient.PageReleaseItem", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutablePageReleaseItem implements StencilClient.PageReleaseItem {
  private final String id;
  private final String hash;
  private final String locale;
  private final String h1;

  private ImmutablePageReleaseItem(String id, String hash, String locale, String h1) {
    this.id = id;
    this.hash = hash;
    this.locale = locale;
    this.h1 = h1;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code hash} attribute
   */
  @JsonProperty("hash")
  @Override
  public String getHash() {
    return hash;
  }

  /**
   * @return The value of the {@code locale} attribute
   */
  @JsonProperty("locale")
  @Override
  public String getLocale() {
    return locale;
  }

  /**
   * @return The value of the {@code h1} attribute
   */
  @JsonProperty("h1")
  @Override
  public String getH1() {
    return h1;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.PageReleaseItem#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePageReleaseItem withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutablePageReleaseItem(newValue, this.hash, this.locale, this.h1);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.PageReleaseItem#getHash() hash} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hash
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePageReleaseItem withHash(String value) {
    String newValue = Objects.requireNonNull(value, "hash");
    if (this.hash.equals(newValue)) return this;
    return new ImmutablePageReleaseItem(this.id, newValue, this.locale, this.h1);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.PageReleaseItem#getLocale() locale} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for locale
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePageReleaseItem withLocale(String value) {
    String newValue = Objects.requireNonNull(value, "locale");
    if (this.locale.equals(newValue)) return this;
    return new ImmutablePageReleaseItem(this.id, this.hash, newValue, this.h1);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.PageReleaseItem#getH1() h1} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for h1
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePageReleaseItem withH1(String value) {
    String newValue = Objects.requireNonNull(value, "h1");
    if (this.h1.equals(newValue)) return this;
    return new ImmutablePageReleaseItem(this.id, this.hash, this.locale, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePageReleaseItem} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePageReleaseItem
        && equalTo((ImmutablePageReleaseItem) another);
  }

  private boolean equalTo(ImmutablePageReleaseItem another) {
    return id.equals(another.id)
        && hash.equals(another.hash)
        && locale.equals(another.locale)
        && h1.equals(another.h1);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code hash}, {@code locale}, {@code h1}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + hash.hashCode();
    h += (h << 5) + locale.hashCode();
    h += (h << 5) + h1.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code PageReleaseItem} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("PageReleaseItem")
        .omitNullValues()
        .add("id", id)
        .add("hash", hash)
        .add("locale", locale)
        .add("h1", h1)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "StencilClient.PageReleaseItem", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements StencilClient.PageReleaseItem {
    @Nullable String id;
    @Nullable String hash;
    @Nullable String locale;
    @Nullable String h1;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("hash")
    public void setHash(String hash) {
      this.hash = hash;
    }
    @JsonProperty("locale")
    public void setLocale(String locale) {
      this.locale = locale;
    }
    @JsonProperty("h1")
    public void setH1(String h1) {
      this.h1 = h1;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getHash() { throw new UnsupportedOperationException(); }
    @Override
    public String getLocale() { throw new UnsupportedOperationException(); }
    @Override
    public String getH1() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutablePageReleaseItem fromJson(Json json) {
    ImmutablePageReleaseItem.Builder builder = ImmutablePageReleaseItem.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.hash != null) {
      builder.hash(json.hash);
    }
    if (json.locale != null) {
      builder.locale(json.locale);
    }
    if (json.h1 != null) {
      builder.h1(json.h1);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link StencilClient.PageReleaseItem} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PageReleaseItem instance
   */
  public static ImmutablePageReleaseItem copyOf(StencilClient.PageReleaseItem instance) {
    if (instance instanceof ImmutablePageReleaseItem) {
      return (ImmutablePageReleaseItem) instance;
    }
    return ImmutablePageReleaseItem.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePageReleaseItem ImmutablePageReleaseItem}.
   * <pre>
   * ImmutablePageReleaseItem.builder()
   *    .id(String) // required {@link StencilClient.PageReleaseItem#getId() id}
   *    .hash(String) // required {@link StencilClient.PageReleaseItem#getHash() hash}
   *    .locale(String) // required {@link StencilClient.PageReleaseItem#getLocale() locale}
   *    .h1(String) // required {@link StencilClient.PageReleaseItem#getH1() h1}
   *    .build();
   * </pre>
   * @return A new ImmutablePageReleaseItem builder
   */
  public static ImmutablePageReleaseItem.Builder builder() {
    return new ImmutablePageReleaseItem.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePageReleaseItem ImmutablePageReleaseItem}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "StencilClient.PageReleaseItem", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_HASH = 0x2L;
    private static final long INIT_BIT_LOCALE = 0x4L;
    private static final long INIT_BIT_H1 = 0x8L;
    private long initBits = 0xfL;

    private @Nullable String id;
    private @Nullable String hash;
    private @Nullable String locale;
    private @Nullable String h1;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.thestencil.client.api.StencilClient.ReleaseItem} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StencilClient.ReleaseItem instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.thestencil.client.api.StencilClient.PageReleaseItem} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StencilClient.PageReleaseItem instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof StencilClient.ReleaseItem) {
        StencilClient.ReleaseItem instance = (StencilClient.ReleaseItem) object;
        hash(instance.getHash());
        id(instance.getId());
      }
      if (object instanceof StencilClient.PageReleaseItem) {
        StencilClient.PageReleaseItem instance = (StencilClient.PageReleaseItem) object;
        locale(instance.getLocale());
        h1(instance.getH1());
      }
    }

    /**
     * Initializes the value for the {@link StencilClient.PageReleaseItem#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.PageReleaseItem#getHash() hash} attribute.
     * @param hash The value for hash 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("hash")
    public final Builder hash(String hash) {
      this.hash = Objects.requireNonNull(hash, "hash");
      initBits &= ~INIT_BIT_HASH;
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.PageReleaseItem#getLocale() locale} attribute.
     * @param locale The value for locale 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("locale")
    public final Builder locale(String locale) {
      this.locale = Objects.requireNonNull(locale, "locale");
      initBits &= ~INIT_BIT_LOCALE;
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.PageReleaseItem#getH1() h1} attribute.
     * @param h1 The value for h1 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("h1")
    public final Builder h1(String h1) {
      this.h1 = Objects.requireNonNull(h1, "h1");
      initBits &= ~INIT_BIT_H1;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePageReleaseItem ImmutablePageReleaseItem}.
     * @return An immutable instance of PageReleaseItem
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePageReleaseItem build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePageReleaseItem(id, hash, locale, h1);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_HASH) != 0) attributes.add("hash");
      if ((initBits & INIT_BIT_LOCALE) != 0) attributes.add("locale");
      if ((initBits & INIT_BIT_H1) != 0) attributes.add("h1");
      return "Cannot build PageReleaseItem, some of required attributes are not set " + attributes;
    }
  }
}
